/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleException;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.Disposable;
import org.mule.runtime.core.api.lifecycle.Initialisable;
import org.mule.runtime.core.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.config.i18n.I18nMessageFactory;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.WrapperErrorMessageAwareException;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.processor.AbstractRequestResponseMessageProcessor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.util.Base64;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.cxf.CxfOutboundMessageProcessor;
import org.mule.runtime.module.cxf.builder.ProxyClientMessageProcessorBuilder;
import org.mule.runtime.module.ws.consumer.InputSoapHeadersInterceptor;
import org.mule.runtime.module.ws.consumer.NamespaceRestorerStaxInterceptor;
import org.mule.runtime.module.ws.consumer.NamespaceSaverStaxInterceptor;
import org.mule.runtime.module.ws.consumer.OutputSoapHeadersInterceptor;
import org.mule.runtime.module.ws.consumer.RequestBodyGenerator;
import org.mule.runtime.module.ws.consumer.SoapActionInterceptor;
import org.mule.runtime.module.ws.consumer.SoapFaultException;
import org.mule.runtime.module.ws.consumer.SoapVersion;
import org.mule.runtime.module.ws.consumer.WSConsumerConfig;
import org.mule.runtime.module.ws.consumer.WSDLUtils;
import org.mule.runtime.module.ws.security.SecurityStrategy;
import org.mule.runtime.module.ws.security.WSSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class WSConsumer
implements Processor,
Initialisable,
MuleContextAware,
FlowConstructAware,
Disposable {
    public static final String SOAP_HEADERS_PROPERTY_PREFIX = "soap.";
    private static final Logger logger = LoggerFactory.getLogger(WSConsumer.class);
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private String operation;
    private WSConsumerConfig config;
    private Processor messageProcessor;
    private String soapAction;
    private String requestBody;
    private SoapVersion soapVersion;
    private boolean mtomEnabled;

    public void initialise() throws InitialisationException {
        this.initializeConfiguration();
        this.parseWsdl();
        try {
            this.messageProcessor = this.createMessageProcessor();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public Event process(Event event) throws MuleException {
        return this.messageProcessor.process(event);
    }

    private void initializeConfiguration() throws InitialisationException {
        if (this.config == null) {
            try {
                this.config = (WSConsumerConfig)this.muleContext.getRegistry().lookupObject(WSConsumerConfig.class);
                if (this.config == null) {
                    throw new InitialisationException(CoreMessages.createStaticMessage((String)"No configuration defined for the web service consumer. Add a consumer-config element."), (Initialisable)this);
                }
            }
            catch (RegistrationException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    private Processor createMessageProcessor() throws MuleException {
        DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
        chainBuilder.chain(new Processor[]{this.createCopyAttachmentsMessageProcessor()});
        chainBuilder.chain(new Processor[]{this.createPropertyRemoverMessageProcessor("operation")});
        chainBuilder.chain(new Processor[]{this.createCxfOutboundMessageProcessor(this.config.getSecurity())});
        chainBuilder.chain(new Processor[]{this.createSoapHeadersPropertiesRemoverMessageProcessor()});
        chainBuilder.chain(new Processor[]{this.config.createOutboundMessageProcessor(this.flowConstruct)});
        MessageProcessorChain chain = chainBuilder.build();
        chain.setFlowConstruct(this.flowConstruct);
        chain.setMuleContext(this.muleContext);
        return chain;
    }

    private Processor createCopyAttachmentsMessageProcessor() {
        return new AbstractRequestResponseMessageProcessor(){

            protected Event processRequest(Event event) throws MuleException {
                InternalMessage message = event.getMessage();
                Event.Builder builder = Event.builder((Event)event);
                if (WSConsumer.this.requestBody != null) {
                    message = InternalMessage.builder((InternalMessage)event.getMessage()).payload((Object)WSConsumer.this.requestBody).build();
                    builder.message(message);
                }
                WSConsumer.this.copyAttachmentsRequest(builder, message);
                return super.processRequest(builder.build());
            }

            protected Event processNext(Event event) throws MuleException {
                try {
                    return super.processNext(event);
                }
                catch (MessagingException e) {
                    if (e.getCause() instanceof DispatchException && e.getCause().getCause() instanceof SoapFault) {
                        SoapFault soapFault = (SoapFault)e.getCause().getCause();
                        InternalMessage errorMessage = e.getEvent().getMessage();
                        if (e.getEvent().getError().isPresent() && ((Error)e.getEvent().getError().get()).getErrorMessage() != null) {
                            errorMessage = ((Error)e.getEvent().getError().get()).getErrorMessage();
                        }
                        SoapFaultException soapFaultException = new SoapFaultException(soapFault);
                        throw new WrapperErrorMessageAwareException((Message)InternalMessage.builder((Message)errorMessage).payload((Object)(soapFault.getDetail() != null ? soapFault.getDetail() : null)).build(), (Throwable)((Object)soapFaultException));
                    }
                    throw e;
                }
            }

            protected Event processResponse(Event response, Event request) throws MuleException {
                return super.processResponse(WSConsumer.this.copyAttachmentsResponse(response), request);
            }
        };
    }

    private Processor createPropertyRemoverMessageProcessor(final String propertyName) {
        return new AbstractRequestResponseMessageProcessor(){
            private Object propertyValue;

            protected Event processRequest(Event event) throws MuleException {
                this.propertyValue = Event.getVariableValueOrNull((String)propertyName, (Event)event);
                event = Event.builder((Event)event).removeVariable(propertyName).build();
                return super.processRequest(event);
            }

            protected Event processResponse(Event response, Event request) throws MuleException {
                if (this.propertyValue != null) {
                    response = Event.builder((Event)response).addVariable(propertyName, this.propertyValue).build();
                }
                return super.processResponse(response, request);
            }
        };
    }

    private Processor createSoapHeadersPropertiesRemoverMessageProcessor() {
        return new AbstractRequestResponseMessageProcessor(){

            protected Event processRequest(Event event) throws MuleException {
                ArrayList outboundProperties = new ArrayList(event.getMessage().getOutboundPropertyNames());
                InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)event.getMessage());
                for (String outboundProperty : outboundProperties) {
                    if (!outboundProperty.startsWith(WSConsumer.SOAP_HEADERS_PROPERTY_PREFIX)) continue;
                    builder.removeOutboundProperty(outboundProperty);
                }
                return super.processRequest(Event.builder((Event)event).message(builder.build()).build());
            }

            protected Event processResponse(Event response, Event request) throws MuleException {
                Serializable statusCode = response.getMessage().getInboundProperty("http.status", null);
                if (statusCode != null && !(statusCode instanceof String)) {
                    response = Event.builder((Event)request).message(InternalMessage.builder((InternalMessage)response.getMessage()).addInboundProperty("http.status", (Serializable)((Object)statusCode.toString())).build()).build();
                }
                return super.processResponse(response, request);
            }
        };
    }

    private CxfOutboundMessageProcessor createCxfOutboundMessageProcessor(WSSecurity security) throws MuleException {
        ProxyClientMessageProcessorBuilder cxfBuilder = new ProxyClientMessageProcessorBuilder();
        HashMap<String, Object> outConfigProperties = new HashMap<String, Object>();
        HashMap<String, Object> inConfigProperties = new HashMap<String, Object>();
        cxfBuilder.setMtomEnabled(this.mtomEnabled);
        cxfBuilder.setMuleContext(this.muleContext);
        cxfBuilder.setSoapVersion(this.soapVersion.getVersion());
        if (security != null && security.hasStrategies()) {
            for (SecurityStrategy strategy : security.getStrategies()) {
                strategy.apply(outConfigProperties, inConfigProperties);
            }
            if (cxfBuilder.getOutInterceptors() == null) {
                cxfBuilder.setOutInterceptors(new ArrayList());
            }
            if (cxfBuilder.getInInterceptors() == null) {
                cxfBuilder.setInInterceptors(new ArrayList());
            }
            if (!outConfigProperties.isEmpty()) {
                cxfBuilder.getOutInterceptors().add(new WSS4JOutInterceptor(outConfigProperties));
            }
            if (!inConfigProperties.isEmpty()) {
                cxfBuilder.getInInterceptors().add(new WSS4JInInterceptor(inConfigProperties));
            }
        }
        CxfOutboundMessageProcessor cxfOutboundMessageProcessor = cxfBuilder.build();
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new CheckFaultInterceptor());
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new NamespaceSaverStaxInterceptor());
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new NamespaceRestorerStaxInterceptor());
        if (this.soapAction != null) {
            cxfOutboundMessageProcessor.getClient().getOutInterceptors().add(new SoapActionInterceptor(this.soapAction));
        }
        cxfOutboundMessageProcessor.getClient().getOutInterceptors().add(new InputSoapHeadersInterceptor(this.muleContext));
        cxfOutboundMessageProcessor.getClient().getInInterceptors().add(new OutputSoapHeadersInterceptor(this.muleContext));
        return cxfOutboundMessageProcessor;
    }

    private void parseWsdl() throws InitialisationException {
        Definition wsdlDefinition = null;
        URL url = IOUtils.getResourceAsUrl((String)this.config.getWsdlLocation(), this.getClass());
        if (url == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Can't find wsdl at %s", (Object[])new Object[]{this.config.getWsdlLocation()}), (Initialisable)this);
        }
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            URLConnection urlConnection = url.openConnection();
            if (url.getUserInfo() != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])url.getUserInfo().getBytes()));
            }
            wsdlDefinition = wsdlReader.readWSDL(url.toString(), new InputSource(urlConnection.getInputStream()));
        }
        catch (IOException | WSDLException e) {
            throw new InitialisationException(e, (Initialisable)this);
        }
        Service service = wsdlDefinition.getService(new QName(wsdlDefinition.getTargetNamespace(), this.config.getService()));
        if (service == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Service %s not found in WSDL", (Object[])new Object[]{this.config.getService()}), (Initialisable)this);
        }
        Port port = service.getPort(this.config.getPort());
        if (port == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Port %s not found in WSDL", (Object[])new Object[]{this.config.getPort()}), (Initialisable)this);
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Port %s has no binding", (Object[])new Object[]{this.config.getPort()}), (Initialisable)this);
        }
        BindingOperation bindingOperation = binding.getBindingOperation(this.operation, null, null);
        if (bindingOperation == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Operation %s not found in WSDL", (Object[])new Object[]{this.operation}), (Initialisable)this);
        }
        this.soapVersion = WSDLUtils.getSoapVersion(binding);
        this.soapAction = this.getSoapAction(bindingOperation);
        RequestBodyGenerator requestBodyGenerator = new RequestBodyGenerator(wsdlDefinition);
        this.requestBody = requestBodyGenerator.generateRequestBody(bindingOperation);
    }

    private String getSoapAction(BindingOperation bindingOperation) {
        List extensions = bindingOperation.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAPOperation) {
                return ((SOAPOperation)extension).getSoapActionURI();
            }
            if (!(extension instanceof SOAP12Operation)) continue;
            return ((SOAP12Operation)extension).getSoapActionURI();
        }
        return null;
    }

    private void copyAttachmentsRequest(Event.Builder eventBuilder, InternalMessage message) throws MessagingException {
        InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)message);
        ArrayList<AttachmentImpl> attachments = new ArrayList<AttachmentImpl>();
        for (String outboundAttachmentName : message.getOutboundAttachmentNames()) {
            attachments.add(new AttachmentImpl(outboundAttachmentName, message.getOutboundAttachment(outboundAttachmentName)));
        }
        try {
            if (message.getPayload().getValue() instanceof MultiPartPayload) {
                for (Message part : ((MultiPartPayload)message.getPayload().getValue()).getParts()) {
                    String partName = ((PartAttributes)part.getAttributes()).getName();
                    attachments.add(new AttachmentImpl(partName, IOUtils.toDataHandler((String)partName, (Object)part.getPayload().getValue(), (MediaType)part.getPayload().getDataType().getMediaType())));
                }
                builder.nullPayload();
            }
        }
        catch (IOException e) {
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Exception processing attachments."), eventBuilder.build(), (Throwable)e, (Processor)this);
        }
        eventBuilder.addVariable("cxf_attachments", attachments).message(builder.outboundAttachments(Collections.emptyMap()).build());
    }

    private Event copyAttachmentsResponse(Event event) throws MessagingException {
        InternalMessage message = event.getMessage();
        if (event.getVariable("cxf_attachments").getValue() != null) {
            Collection attachments = (Collection)event.getVariable("cxf_attachments").getValue();
            InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)message);
            if (!attachments.isEmpty()) {
                ArrayList<InternalMessage> parts = new ArrayList<InternalMessage>();
                parts.add(InternalMessage.builder().payload(message.getPayload().getValue()).mediaType(message.getPayload().getDataType().getMediaType()).attributes((Attributes)DefaultMultiPartPayload.BODY_ATTRIBUTES).build());
                for (Attachment attachment : attachments) {
                    HashMap<String, LinkedList<String>> headers = new HashMap<String, LinkedList<String>>();
                    Iterator iterator = attachment.getHeaderNames();
                    while (iterator.hasNext()) {
                        String headerName = (String)iterator.next();
                        headers.put(headerName, new LinkedList<String>(Collections.singletonList(attachment.getHeader(headerName))));
                    }
                    try {
                        parts.add(InternalMessage.builder().payload((Object)attachment.getDataHandler().getInputStream()).mediaType(MediaType.parse((String)attachment.getDataHandler().getContentType())).attributes((Attributes)new PartAttributes(attachment.getId())).build());
                    }
                    catch (Exception e) {
                        throw new MessagingException(CoreMessages.createStaticMessage((String)"Could not set inbound attachment %s", (Object[])new Object[]{attachment.getId()}), event, (Throwable)e, (Processor)this);
                    }
                }
                builder.payload((Object)new DefaultMultiPartPayload(parts));
            }
            return Event.builder((Event)event).message(builder.build()).build();
        }
        return event;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public WSConsumerConfig getConfig() {
        return this.config;
    }

    public void setConfig(WSConsumerConfig config) {
        this.config = config;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void dispose() {
        if (this.messageProcessor instanceof Disposable) {
            ((Disposable)this.messageProcessor).dispose();
        }
    }
}

