/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import java.io.Serializable;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class OutputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    private final MuleContext muleContext;

    public OutputSoapHeadersInterceptor(MuleContext muleContext) {
        super("pre-protocol");
        this.muleContext = muleContext;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Event event = (Event)message.getExchange().get((Object)"mule.event");
        if (event == null) {
            return;
        }
        InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)event.getMessage());
        for (Header header : message.getHeaders()) {
            if (!(header instanceof SoapHeader)) continue;
            Transformer transformer = null;
            try {
                DataType sourceType = DataType.fromObject((Object)header.getObject());
                transformer = this.muleContext.getRegistry().lookupTransformer(sourceType, DataType.STRING);
                String key = "soap." + header.getName().getLocalPart();
                String value = (String)transformer.transform(header.getObject());
                builder.addInboundProperty(key, (Serializable)((Object)value));
            }
            catch (TransformerException e) {
                throw new Fault((Throwable)new MessageTransformerException(CoreMessages.createStaticMessage((String)"Cannot parse content of SOAP header %s in the response", (Object[])new Object[]{header.getName().getLocalPart()}), transformer, e.getCause()));
            }
        }
        Event built = Event.builder((Event)event).message(builder.build()).build();
        message.getExchange().put((Object)"mule.event", (Object)built);
    }
}

