/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.mule.runtime.module.ws.consumer.ScopeSaverXMLStreamReader;

public class NamespaceRestorerXMLStreamReader
extends ScopeSaverXMLStreamReader {
    private List<Namespace> namespaces;
    private List<String> nsBlacklist = new ArrayList<String>();

    public NamespaceRestorerXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    public final NamespaceRestorerXMLStreamReader blackList(String namespace) {
        this.nsBlacklist.add(namespace);
        return this;
    }

    public void restoreNamespaces() {
        if (this.getEventType() == 1) {
            this.namespaces = new ArrayList<Namespace>();
            HashSet<String> prefixes = new HashSet<String>();
            for (StartElement elem : this.scopes()) {
                Iterator<Namespace> iter = elem.getNamespaces();
                while (iter.hasNext()) {
                    Namespace ns = iter.next();
                    if (!prefixes.add(ns.getPrefix()) || this.nsBlacklist.contains(ns.getNamespaceURI())) continue;
                    this.namespaces.add(ns);
                }
            }
        }
    }

    @Override
    public int next() throws XMLStreamException {
        this.namespaces = null;
        return super.next();
    }

    public int getNamespaceCount() {
        if (this.overrideNamespaces()) {
            return this.namespaces.size();
        }
        return super.getNamespaceCount();
    }

    private boolean overrideNamespaces() {
        return this.namespaces != null;
    }

    public String getNamespacePrefix(int index) {
        if (this.overrideNamespaces()) {
            return this.namespaces.get(index).getPrefix();
        }
        return super.getNamespacePrefix(index);
    }

    public String getNamespaceURI(String prefix) {
        if (this.overrideNamespaces()) {
            for (Namespace ns : this.namespaces) {
                if (!ns.getPrefix().equals(prefix)) continue;
                return ns.getNamespaceURI();
            }
        }
        return super.getNamespaceURI(prefix);
    }

    public String getNamespaceURI(int index) {
        if (this.overrideNamespaces()) {
            return this.namespaces.get(index).getNamespaceURI();
        }
        return super.getNamespaceURI(index);
    }
}

