/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.w3c.dom.Document;

public class InputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    private final MuleContext muleContext;

    public InputSoapHeadersInterceptor(MuleContext muleContext) {
        super("pre-protocol");
        this.muleContext = muleContext;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Map invocationContext = (Map)message.get((Object)"org.apache.cxf.invocation.context");
        Map requestContext = (Map)invocationContext.get("RequestContext");
        for (String outboundProperty : requestContext.keySet()) {
            if (!outboundProperty.startsWith("soap.")) continue;
            Object value = requestContext.get(outboundProperty);
            Transformer transformer = null;
            try {
                transformer = this.muleContext.getRegistry().lookupTransformer(DataType.fromObject(value), DataType.fromType(Document.class));
            }
            catch (TransformerException e) {
                throw new Fault((Throwable)new MessageTransformerException(CoreMessages.createStaticMessage((String)"Cannot find transformer to convert outbound property %s to XML", (Object[])new Object[]{outboundProperty}), transformer, e.getCause()));
            }
            try {
                Document document = (Document)transformer.transform(value);
                QName qname = new QName(null, document.getDocumentElement().getTagName());
                message.getHeaders().add(new SoapHeader(qname, (Object)document.getDocumentElement()));
            }
            catch (TransformerException e) {
                throw new Fault((Throwable)new MessageTransformerException(CoreMessages.createStaticMessage((String)"Outbound property %s contains an invalid XML string", (Object[])new Object[]{outboundProperty}), transformer, e.getCause()));
            }
        }
    }
}

