/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.util.HashMap;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.client.OperationOptions;
import org.mule.api.config.ConfigurationException;
import org.mule.api.connector.ConnectorOperationLocator;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.internal.config.HttpConfiguration;
import org.mule.module.ws.consumer.MuleWSDLLocator;
import org.mule.module.ws.consumer.MuleWSDLLocatorConfig;
import org.mule.module.ws.consumer.RequestBodyGenerator;
import org.mule.module.ws.security.WSSecurity;
import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public class WSConsumerConfig
implements MuleContextAware {
    private MuleContext muleContext;
    private String name;
    private String wsdlLocation;
    private String service;
    private String port;
    private String serviceAddress;
    private boolean useConnectorToRetrieveWsdl;
    private Connector connector;
    private HttpRequesterConfig connectorConfig;
    private WSSecurity security;
    private volatile Definition wsdlDefinition;
    private volatile MuleWSDLLocator wsdlLocator;
    private Map<String, String> operationToBodyCache = new HashMap<String, String>();

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MessageProcessor createOutboundMessageProcessor() throws MuleException {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.serviceAddress), (String)"No serviceAddress provided in WS consumer config");
        if (this.connectorConfig != null && this.connector != null) {
            throw new ConfigurationException(CoreMessages.createStaticMessage((String)"Cannot set both connector-config and connector-ref attributes. Set either one of them, or none for default behavior."));
        }
        if (this.useHttpModule()) {
            return this.createHttpRequester();
        }
        return this.createOutboundEndpoint();
    }

    private boolean useHttpModule() {
        if (this.connectorConfig != null) {
            return true;
        }
        if (!this.isHttp()) {
            return false;
        }
        if (this.connector != null) {
            return false;
        }
        return !HttpConfiguration.useTransportForUris((MuleContext)this.muleContext);
    }

    private OutboundEndpoint createOutboundEndpoint() throws MuleException {
        EndpointBuilder builder = this.muleContext.getEndpointFactory().getEndpointBuilder(this.serviceAddress);
        if (this.connector != null) {
            String protocol = new MuleEndpointURI(this.serviceAddress, this.muleContext).getScheme();
            if (!this.connector.supportsProtocol(protocol)) {
                throw new IllegalStateException(String.format("Connector %s does not support protocol: %s", this.connector.getName(), protocol));
            }
            builder.setConnector(this.connector);
        }
        return this.muleContext.getEndpointFactory().getOutboundEndpoint(builder);
    }

    private MessageProcessor createHttpRequester() throws MuleException {
        return new MessageProcessor(){
            private HttpRequestOptions requestOptions;

            public MuleEvent process(MuleEvent event) throws MuleException {
                ConnectorOperationLocator connectorOperationLocator = (ConnectorOperationLocator)WSConsumerConfig.this.muleContext.getRegistry().get("_muleConnectorMessageProcessorLocator");
                MessageProcessor messageProcessor = connectorOperationLocator.locateConnectorOperation(WSConsumerConfig.this.serviceAddress, (OperationOptions)this.getRequestOptions(), MessageExchangePattern.REQUEST_RESPONSE);
                return messageProcessor.process(event);
            }

            private HttpRequestOptions getRequestOptions() {
                if (this.requestOptions == null) {
                    HttpRequestOptionsBuilder builder = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().disableParseResponse();
                    if (WSConsumerConfig.this.connectorConfig != null) {
                        builder.requestConfig(WSConsumerConfig.this.connectorConfig);
                    }
                    this.requestOptions = builder.build();
                }
                return this.requestOptions;
            }
        };
    }

    private boolean isHttp() {
        return this.serviceAddress.startsWith("http");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public HttpRequesterConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(HttpRequesterConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public WSSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WSSecurity security) {
        this.security = security;
    }

    public boolean isUseConnectorToRetrieveWsdl() {
        return this.useConnectorToRetrieveWsdl;
    }

    public void setUseConnectorToRetrieveWsdl(boolean useConnectorToRetrieveWsdl) {
        this.useConnectorToRetrieveWsdl = useConnectorToRetrieveWsdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWsdlDefinition() throws Exception {
        if (this.wsdlDefinition == null) {
            WSConsumerConfig wSConsumerConfig = this;
            synchronized (wSConsumerConfig) {
                if (this.wsdlDefinition == null) {
                    this.initializeWSDLLocator();
                    WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
                    this.wsdlDefinition = wsdlReader.readWSDL((WSDLLocator)this.wsdlLocator);
                }
            }
        }
        return this.wsdlDefinition;
    }

    protected void initializeWSDLLocator() throws WSDLException {
        try {
            MuleWSDLLocatorConfig locatorConfig = this.createWSDLLocator(this.connectorConfig, this.wsdlLocation);
            this.wsdlLocator = new MuleWSDLLocator(locatorConfig);
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", e.getMessage(), (Throwable)e);
        }
    }

    private MuleWSDLLocatorConfig createWSDLLocator(HttpRequesterConfig httpRequesterConfig, String url) throws Exception {
        MuleWSDLLocatorConfig locatorConfig = null;
        if (httpRequesterConfig == null && this.useConnectorToRetrieveWsdl) {
            throw new Exception("The useConnectorToRetrieveWsdl option requires connectorConfig to work");
        }
        locatorConfig = httpRequesterConfig == null ? new MuleWSDLLocatorConfig.Builder().setBaseURI(url).setContext(this.muleContext).build() : new MuleWSDLLocatorConfig.Builder().setBaseURI(url).setTlsContextFactory(httpRequesterConfig.getTlsContext()).setContext(this.muleContext).setUseConnectorToRetrieveWsdl(this.useConnectorToRetrieveWsdl).setProxyConfig(httpRequesterConfig.getProxyConfig()).build();
        return locatorConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleWSDLLocator getWsdlLocator() throws WSDLException {
        if (this.wsdlLocator == null) {
            WSConsumerConfig wSConsumerConfig = this;
            synchronized (wSConsumerConfig) {
                this.initializeWSDLLocator();
            }
        }
        return this.wsdlLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestBody(Definition wsdlDefinition, BindingOperation bindingOperation) throws WSDLException {
        WSConsumerConfig wSConsumerConfig = this;
        synchronized (wSConsumerConfig) {
            String body;
            String operationName = bindingOperation.getName();
            if (this.operationToBodyCache.containsKey(operationName)) {
                body = this.getRequestBodyFromCache(operationName);
            } else {
                body = this.createRequestBody(wsdlDefinition, bindingOperation);
                this.operationToBodyCache.put(operationName, body);
            }
            return body;
        }
    }

    String createRequestBody(Definition wsdlDefinition, BindingOperation bindingOperation) throws WSDLException {
        RequestBodyGenerator requestBodyGenerator = new RequestBodyGenerator(wsdlDefinition, this.getWsdlLocator());
        return requestBodyGenerator.generateRequestBody(bindingOperation);
    }

    String getRequestBodyFromCache(String operationName) {
        return this.operationToBodyCache.get(operationName);
    }
}

