/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.w3c.dom.Document;

public class InputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    private final MuleContext muleContext;

    public InputSoapHeadersInterceptor(MuleContext muleContext) {
        super("pre-protocol");
        this.muleContext = muleContext;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Map invocationContext = (Map)message.get((Object)"org.apache.cxf.invocation.context");
        Map requestContext = (Map)invocationContext.get("RequestContext");
        for (String outboundProperty : requestContext.keySet()) {
            MuleEvent event;
            if (!outboundProperty.startsWith("soap.")) continue;
            Object value = requestContext.get(outboundProperty);
            Transformer transformer = null;
            try {
                transformer = this.muleContext.getRegistry().lookupTransformer(DataTypeFactory.createFromObject(value), (DataType)new SimpleDataType(Document.class));
            }
            catch (TransformerException e) {
                event = (MuleEvent)message.getExchange().get((Object)"mule.event");
                throw new Fault((Throwable)new TransformerMessagingException(CoreMessages.createStaticMessage((String)"Cannot find transformer to convert outbound property %s to XML", (Object[])new Object[]{outboundProperty}), event, transformer, e.getCause()));
            }
            try {
                Document document = (Document)transformer.transform(value);
                QName qname = new QName(null, document.getDocumentElement().getTagName());
                message.getHeaders().add(new SoapHeader(qname, (Object)document.getDocumentElement()));
            }
            catch (TransformerException e) {
                event = (MuleEvent)message.getExchange().get((Object)"mule.event");
                throw new Fault((Throwable)new TransformerMessagingException(CoreMessages.createStaticMessage((String)"Outbound property %s contains an invalid XML string", (Object[])new Object[]{outboundProperty}), event, transformer, e.getCause()));
            }
        }
    }
}

