/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.staffing.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.staffing.adapters.StaffingModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.staffing.connectivity.StaffingModuleConnectionKey;
import org.mule.modules.workday.staffing.connectivity.StaffingModuleConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaffingModuleConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(StaffingModuleConnectionFactory.class);
    private StaffingModuleConnectionManager connectionManager;

    public StaffingModuleConnectionFactory(StaffingModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof StaffingModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.staffing.connectivity.StaffingModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        StaffingModuleConnectionIdentifierAdapter connector = new StaffingModuleConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((StaffingModuleConnectionKey)key).getStaffingUser(), ((StaffingModuleConnectionKey)key).getStaffingPassword(), ((StaffingModuleConnectionKey)key).getStaffingEndpoint(), ((StaffingModuleConnectionKey)key).getStaffingWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof StaffingModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.staffing.connectivity.StaffingModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof StaffingModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.staffing.adapters.StaffingModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((StaffingModuleConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((StaffingModuleConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((StaffingModuleConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof StaffingModuleConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.staffing.adapters.StaffingModuleConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((StaffingModuleConnectionIdentifierAdapter)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof StaffingModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof StaffingModuleConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((StaffingModuleConnectionIdentifierAdapter)obj).validateConnection()) {
            ((StaffingModuleConnectionIdentifierAdapter)obj).connect(((StaffingModuleConnectionKey)key).getStaffingUser(), ((StaffingModuleConnectionKey)key).getStaffingPassword(), ((StaffingModuleConnectionKey)key).getStaffingEndpoint(), ((StaffingModuleConnectionKey)key).getStaffingWsdlLocation());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

