
package org.mule.modules.workday.staffing.process;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.staffing.adapters.StaffingModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.staffing.connection.ConnectionManager;
import org.mule.modules.workday.staffing.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.staffing.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.staffing.connectivity.StaffingModuleConnectionKey;
import org.mule.modules.workday.staffing.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.staffing.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated(value = "Mule DevKit Version 3.4.3", date = "2014-12-15T04:36:28-03:00", comments = "Build 3.4.3.1620.30ea288")
public class StaffingModuleManagedConnectionProcessInterceptor<T >
    extends AbstractExpressionEvaluator
    implements ProcessInterceptor<T, StaffingModuleConnectionIdentifierAdapter>
{

    private static Logger logger = LoggerFactory.getLogger(StaffingModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<StaffingModuleConnectionKey, StaffingModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, StaffingModuleConnectionIdentifierAdapter> next;

    public StaffingModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, StaffingModuleConnectionIdentifierAdapter> next, ConnectionManager<StaffingModuleConnectionKey, StaffingModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, StaffingModuleConnectionIdentifierAdapter> processCallback, StaffingModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        StaffingModuleConnectionIdentifierAdapter connection = null;
        StaffingModuleConnectionKey key = null;
        if ((messageProcessor!= null)&&((messageProcessor instanceof AbstractConnectedProcessor)&&(((AbstractConnectedProcessor) messageProcessor).getStaffingUser()!= null))) {
            final String _transformedStaffingUser = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_staffingUserType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getStaffingUser()));
            if (_transformedStaffingUser == null) {
                throw new UnableToAcquireConnectionException("Parameter staffingUser in method connect can't be null because is not @Optional");
            }
            final String _transformedStaffingPassword = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_staffingPasswordType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getStaffingPassword()));
            if (_transformedStaffingPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter staffingPassword in method connect can't be null because is not @Optional");
            }
            final String _transformedStaffingEndpoint = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_staffingEndpointType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getStaffingEndpoint()));
            if (_transformedStaffingEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter staffingEndpoint in method connect can't be null because is not @Optional");
            }
            final String _transformedStaffingWsdlLocation = ((String) evaluateAndTransform(muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_staffingWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor) messageProcessor).getStaffingWsdlLocation()));
            key = new StaffingModuleConnectionKey(_transformedStaffingUser, _transformedStaffingPassword, _transformedStaffingEndpoint, _transformedStaffingWsdlLocation);
        } else {
            key = connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(("Attempting to acquire connection using "+ key.toString()));
            }
            connection = connectionManager.acquireConnection(key);
            if (connection == null) {
                throw new UnableToAcquireConnectionException();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((("Connection has been acquired with [id="+ connection.getConnectionIdentifier())+"]"));
                }
            }
            return next.execute(processCallback, connection, messageProcessor, event);
        } catch (Exception e) {
            if (processCallback.getManagedExceptions()!= null) {
                for (Class exceptionClass: ((List<Class> ) processCallback.getManagedExceptions())) {
                    if (exceptionClass.isInstance(e)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((((("An exception ( "+ exceptionClass.getName())+") has been thrown. Destroying the connection with [id=")+ connection.getConnectionIdentifier())+"]"));
                        }
                        try {
                            if (connection!= null) {
                                connectionManager.destroyConnection(key, connection);
                                connection = null;
                            }
                        } catch (Exception innerException) {
                            logger.error(innerException.getMessage(), innerException);
                        }
                    }
                }
            }
            throw e;
        } finally {
            try {
                if (connection!= null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((("Releasing the connection back into the pool [id="+ connection.getConnectionIdentifier())+"]"));
                    }
                    connectionManager.releaseConnection(key, connection);
                }
            } catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    public T execute(ProcessCallback<T, StaffingModuleConnectionIdentifierAdapter> processCallback, StaffingModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message)
        throws Exception
    {
        throw new UnsupportedOperationException();
    }

}
