/**
 * (c) 2003-2014 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */

package org.mule.modules.workday.staffing;

import org.mule.api.ConnectionException;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.ConnectivityTesting;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.RefOnly;
import org.mule.modules.workday.AbstractWorkdayModule;
import org.mule.modules.workday.api.exception.WorkdayCredentialsException;
import org.mule.modules.workday.api.exception.WorkdayException;

import com.workday.staffing.AddAdditionalJobEventResponseType;
import com.workday.staffing.AddAdditionalJobRequestType;
import com.workday.staffing.AddRetireeStatusRequestType;
import com.workday.staffing.AddRetireeStatusResponseType;
import com.workday.staffing.AssignOrganizationRequestType;
import com.workday.staffing.AssignOrganizationResponseType;
import com.workday.staffing.AssignOrganizationRolesRequestType;
import com.workday.staffing.AssignOrganizationRolesResponseType;
import com.workday.staffing.ChangeJobRequestType;
import com.workday.staffing.ChangeJobResponseType;
import com.workday.staffing.ClosePositionOrHeadcountRestrictionRequestType;
import com.workday.staffing.ClosePositionOrHeadcountRestrictionResponseType;
import com.workday.staffing.ContractContingentWorkerRequestType;
import com.workday.staffing.ContractContingentWorkerResponseType;
import com.workday.staffing.CreatePositionRequestType;
import com.workday.staffing.CreatePositionResponseType;
import com.workday.staffing.EditHiringRestrictionsRequestType;
import com.workday.staffing.EditHiringRestrictionsResponseType;
import com.workday.staffing.EditPositionEventResponseType;
import com.workday.staffing.EditPositionRequestType;
import com.workday.staffing.EditPositionRestrictionsRequestType;
import com.workday.staffing.EditPositonRestrictionResponseType;
import com.workday.staffing.EditServiceDatesRequestType;
import com.workday.staffing.EditServiceDatesResponseType;
import com.workday.staffing.EndAdditionalEmployeeJobEventResponseType;
import com.workday.staffing.EndAdditionalJobRequestType;
import com.workday.staffing.EndContingentWorkerContractRequestType;
import com.workday.staffing.EndContingentWorkerContractResponseType;
import com.workday.staffing.GetApplicantsRequestType;
import com.workday.staffing.GetApplicantsResponseType;
import com.workday.staffing.GetCitizenshipStatusesRequestType;
import com.workday.staffing.GetCitizenshipStatusesResponseType;
import com.workday.staffing.GetHeadcountsRequestType;
import com.workday.staffing.GetHeadcountsResponseType;
import com.workday.staffing.GetJobClassificationGroupsRequestType;
import com.workday.staffing.GetJobClassificationGroupsResponseType;
import com.workday.staffing.GetJobFamiliesRequestType;
import com.workday.staffing.GetJobFamiliesResponseType;
import com.workday.staffing.GetJobFamilyGroupsRequestType;
import com.workday.staffing.GetJobFamilyGroupsResponseType;
import com.workday.staffing.GetMaintainEmployeeContractsRequestType;
import com.workday.staffing.GetMaintainEmployeeContractsResponseType;
import com.workday.staffing.GetOrganizationsRequestType;
import com.workday.staffing.GetOrganizationsResponseType;
import com.workday.staffing.GetPositionsRequestType;
import com.workday.staffing.GetPositionsResponseType;
import com.workday.staffing.GetWorkerDocumentsRequestType;
import com.workday.staffing.GetWorkerDocumentsResponseType;
import com.workday.staffing.GetWorkersRequestType;
import com.workday.staffing.GetWorkersResponseType;
import com.workday.staffing.HireEmployeeEventResponseType;
import com.workday.staffing.HireEmployeeRequestType;
import com.workday.staffing.MaintainAcademicTenureDateRequestType;
import com.workday.staffing.MaintainAcademicTenureDateResponseType;
import com.workday.staffing.MaintainEmployeeContractsRequestType;
import com.workday.staffing.MaintainEmployeeContractsResponseType;
import com.workday.staffing.PutApplicantRequestType;
import com.workday.staffing.PutApplicantResponseType;
import com.workday.staffing.PutCitizenshipStatusRequestType;
import com.workday.staffing.PutCitizenshipStatusResponseType;
import com.workday.staffing.PutDependentRequestType;
import com.workday.staffing.PutDependentResponseType;
import com.workday.staffing.PutJobClassificationGroupRequestType;
import com.workday.staffing.PutJobClassificationGroupResponseType;
import com.workday.staffing.PutJobFamilyGroupRequestType;
import com.workday.staffing.PutJobFamilyGroupResponseType;
import com.workday.staffing.PutJobFamilyRequestType;
import com.workday.staffing.PutJobFamilyResponseType;
import com.workday.staffing.PutWorkerDocumentRequestType;
import com.workday.staffing.PutWorkerDocumentResponseType;
import com.workday.staffing.RemoveRetireeStatusRequestType;
import com.workday.staffing.RemoveRetireeStatusResponseType;
import com.workday.staffing.SetHiringRestrictionsRequestType;
import com.workday.staffing.SetHiringRestrictionsResponseType;
import com.workday.staffing.StaffingPort;
import com.workday.staffing.SwitchPrimaryJobEventResponseType;
import com.workday.staffing.SwitchPrimaryJobRequestType;
import com.workday.staffing.TerminateEmployeeEventResponseType;
import com.workday.staffing.TerminateEmployeeRequestType;

/**
 * The Staffing Module exposes operations over Workday Human Capital Management
 * Business Services data, including Employee, Contingent Worker and Organization
 * information. This Web Service can be used for integration with enterprise systems
 * including corporate directories, data analysis tools, email or other provisioning
 * sub-systems, or any other systems needing Worker and/or Organization data.
 *
 * @author MuleSoft, Inc.
 */
@Connector(name = "wd-staffing", schemaVersion = "2.0", friendlyName = "Workday Staffing", minMuleVersion = "3.4", connectivityTesting=ConnectivityTesting.DISABLED)
public class StaffingModule extends AbstractWorkdayModule
{

    /**
     * The client, mainly for mocking purposes. *
     */
    private StaffingPort client;

    /**
     * The Workday account's username
     */
    private String username;

    /**
     * Hires an applicant (new or existing) into an employee position, 
     * headcount, or job. Uses the Hire Employee business process. .
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:hire-employee}
     * @param employee request object
     * @return element containing the Event ID for the Hire Employee Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public HireEmployeeEventResponseType hireEmployee(
            @Optional @Default("#[payload]") @RefOnly HireEmployeeRequestType employee) throws WorkdayException
    {
        return client.hireEmployee(employee);
    }

    /**
     * Adds a new applicant (or updates an existing applicant) with the information supplied in the request.
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-applicant}
     * @param applicant Wrapper element for the Put Applicant Request Information.
     * @return Wrapper element for the Put Applicant Returned data.
     *@throws WorkdayException If an error during the operation occurs this exception is thrown
     * 
     */
    @Processor(friendlyName = "Put Applicant")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public PutApplicantResponseType putApplicantStaffing(
            @Optional @Default("#[payload]") @RefOnly PutApplicantRequestType applicant) throws WorkdayException
    {
        return client.putApplicant(applicant);
    }

    /**
     * Adds an additional job for an existing employee. Uses the Add Additional Job business process.
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:add-additional-job}
     * @param additionalJob wrapper for additionalJobRequest
     * @return Responds with the Event ID for the Add Additional Employee Job Event and the job reference.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public AddAdditionalJobEventResponseType addAdditionalJob(
            @Optional @Default("#[payload]") @RefOnly AddAdditionalJobRequestType additionalJob) throws WorkdayException
    {
        return client.addAdditionalJob(additionalJob);
    }
    
    /**
     * Changes the status of a previously terminated worker to retiree. Uses the Add Retiree Status business process.
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:add-retiree-status}
     * @param retireeStatus wrapper for AddRetireeStatusRequestType
     * @return element with information in Add Retiree Status event
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public AddRetireeStatusResponseType addRetireeStatus(
            @Optional @Default("#[payload]") @RefOnly AddRetireeStatusRequestType retireeStatus) throws WorkdayException
    {
        return client.addRetireeStatus(retireeStatus);
    }
    
    /**
     * Assigns company, cost center, region, fund, grant, business unit, program, and custom organizations 
     * configured for staffing usage to a staffing position. Uses the Change Organization Assignments for 
     * Worker business process.  
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:assign-organization}
     * @param organization wrapper for AssignOrganizationRequestType
     * @return Responds with the Event ID for the Assign Organization Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public AssignOrganizationResponseType assignOrganization(
            @Optional @Default("#[payload]") @RefOnly AssignOrganizationRequestType organization) throws WorkdayException
    {
        return client.assignOrganization(organization);
    }
    
    /**
     * Assigns organization roles to one or more workers. 
     * Uses the Assign Organization Roles for Worker business process.   
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:assign-organization-roles}
     * @param organizationRoles wrapper for AssignOrganizationRolesRequestType
     * @return element with the Event ID for the Assign Organization Roles business process event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public AssignOrganizationRolesResponseType assignOrganizationRoles(
            @Optional @Default("#[payload]") @RefOnly AssignOrganizationRolesRequestType organizationRoles) throws WorkdayException
    {
        return client.assignOrganizationRoles(organizationRoles);
    }
    
    /**
     * Perform a job change on an employee or contingent worker. Uses the Change Job business process. 
     * The types of changes include transfer, promotion, demotion, lateral moves and any other change of data on the job.     
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:change-job}
     * @param job job request object
     * @return element with the Event ID of the Change Job and any exceptions.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public ChangeJobResponseType changeJob(@Optional @Default("#[payload]") @RefOnly ChangeJobRequestType job) throws WorkdayException
    {
        return client.changeJob(job);
    }
    
    /**
     * Contracts an existing applicant into a contingent worker position, headcount, or job. 
     * Uses the Contract Contingent Worker business process     
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:contract-contingent-worker}
     * @param contingentWorker wrapper for ContractContingentWorkerRequestType
     * @return Responds with the event id of the contract contingent worker event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public ContractContingentWorkerResponseType contractContingentWorker(
            @Optional @Default("#[payload]") @RefOnly ContractContingentWorkerRequestType contingentWorker) throws WorkdayException
    {
        return client.contractContingentWorker(contingentWorker);
    }
    
    /**
     * Creates/opens a position for a supervisory organization using the position management staffing model. 
     * Uses the Create Position business process. There are several sub-operations within this operation. 
     * Existing positions cannot be re-loaded into the system. 
     * You must use the Edit Position Restrictions operation to change a created position.       
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:create-position}
     * @param position Wrapper for Create Open Position Web Service.
     * @return Responds with the event id for the Position Request Event and the 
     * Position Opening Reference (if the event was completed).
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor(friendlyName = "Create Position")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public CreatePositionResponseType createPositionStaffing(
            @Optional @Default("#[payload]") @RefOnly CreatePositionRequestType position) throws WorkdayException
    {
        return client.createPosition(position);
    }
    
    /**
     * Edits a filled position. Uses the Edit Position business process.       
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:edit-position}
     * @param position wrapper for EditPositionRequestType
     * @return Responds with the Event ID for the Edit Position Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public EditPositionEventResponseType editPosition(
            @Optional @Default("#[payload]") @RefOnly EditPositionRequestType position) throws WorkdayException
    {
        return client.editPosition(position);
    }
    
    /**
     * Edits an existing position restriction. Uses the Edit Position Restrictions business process.        
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:edit-position-restrictions}
     * @param positionRestrictions Wrapper element for Edit Position Restrictions Web Service.
     * @return element with the event ID of the Position Restrictions Edit Event, the Position Restriction being edited and the workflow state of the event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor(friendlyName = "Edit Position Restrictions")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public EditPositonRestrictionResponseType editPositionRestrictionsStaffing(
            @Optional @Default("#[payload]") @RefOnly EditPositionRestrictionsRequestType positionRestrictions) throws WorkdayException
    {
        return client.editPositionRestrictions(positionRestrictions);
    }
    
    /**
     * Sets a worker's service dates. Uses the Edit Service Dates business process        
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:edit-service-dates}
     * @param serviceDates wrapper for EditServiceDatesRequestType
     * @return Responds with the Event ID for the Service Dates Change Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public EditServiceDatesResponseType editServiceDates(
            @Optional @Default("#[payload]") @RefOnly EditServiceDatesRequestType serviceDates) throws WorkdayException
    {
        return client.editServiceDates(serviceDates);
    }
    
    /**
     * Ends an employee's additional job. Uses the End Additional Job business process        
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:end-additional-job}
     * @param additionalJob Wrapper for End Additional Job Web Service.
     * @return element with the Event ID for the End Additional Job Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public EndAdditionalEmployeeJobEventResponseType endAdditionalJob(
            @Optional @Default("#[payload]") @RefOnly EndAdditionalJobRequestType additionalJob) throws WorkdayException
    {
        return client.endAdditionalJob(additionalJob);
    }
    
    /**
     * Ends a contingent worker's contract. Uses the End Contingent Worker Contract Business Process        
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:end-contingent-worker-contract}
     * @param contingentWorkerContract Wrapper for End Contingent Worker Contract web service and its sub-processes.
     * @return element with the event id for the End Contract Event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public EndContingentWorkerContractResponseType endContingentWorkerContract(
            @Optional @Default("#[payload]") @RefOnly EndContingentWorkerContractRequestType contingentWorkerContract) throws WorkdayException
    {
        return client.endContingentWorkerContract(contingentWorkerContract);
    }
    
    /**
     * Returns information for applicants specified in the request. 
     * If the request does not specify an applicant, this operation returns information for all applicants..          
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-applicants}
     * @param applicantsRequest Wrapper element for Applicant Request.
     * @return Wrapper element for the Applicant Information returned as a result of a Get Applicant request.
     *  @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor(friendlyName = "Get Applicants")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public GetApplicantsResponseType getApplicantsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetApplicantsRequestType applicantsRequest) throws WorkdayException
    {
        return client.getApplicants(applicantsRequest);
    }
    
    /**
     * Returns citizenship status details for the requested status. If the request does not specify a citizenship status, 
     * the operations returns details for all citizenship statuses.         
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-citizenship-statuses}
     * @param citizenshipStatusesRequest Element containing the references of the Citizenship Statuses requested.
     * @return Response Element for Get Citizenship Statuses.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public GetCitizenshipStatusesResponseType getCitizenshipStatuses(
            @Optional @Default("#[payload]") @RefOnly GetCitizenshipStatusesRequestType citizenshipStatusesRequest) throws WorkdayException
    {
        return client.getCitizenshipStatuses(citizenshipStatusesRequest);
    }
    
    /**
     * Returns headcount information along with the identification of the workers filling headcount positions.        
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-headcounts}
     * @param headcountsRequest Request element to get Headcounts and their associated data.
     * @return Response element containing instances of headcounts and their associated data.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor(friendlyName = "Get Headcounts")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public GetHeadcountsResponseType getHeadcountsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetHeadcountsRequestType headcountsRequest) throws WorkdayException
    {
        return client.getHeadcounts(headcountsRequest);
    }
    
    /**
     * Returns information for position management positions. If a position is filled, identifies the worker filling the position.            
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-positions}
     * @param positionsRequest Request element to get position management positions and their associated data.
     * @return element containing instances of positions and their associated data.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor(friendlyName = "Get Positions")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public GetPositionsResponseType getPositionsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetPositionsRequestType positionsRequest) throws WorkdayException
    {
        return client.getPositions(positionsRequest);
    }
    
    /**
     * Returns worker document data.            
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-worker-documents}
     * @param workerDocumentsRequest Request element for Get Worker Documents.
     * @return Response element for Get Worker Documents.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public GetWorkerDocumentsResponseType getWorkerDocuments(
            @Optional @Default("#[payload]") @RefOnly GetWorkerDocumentsRequestType workerDocumentsRequest) throws WorkdayException
    {
        return client.getWorkerDocuments(workerDocumentsRequest);
    }
    
    /**
     * Adds or updates employee contracts. Uses the Maintain Employee Contracts business process.            
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:maintain-employee-contracts}
     * @param employeeContractsRequest wrapper element for MaintainEmployeeContractsRequestType
     * @return Employee Contract that was added or updated
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public MaintainEmployeeContractsResponseType maintainEmployeeContracts(
            @Optional @Default("#[payload]") @RefOnly MaintainEmployeeContractsRequestType employeeContractsRequest) throws WorkdayException
    {
        return client.maintainEmployeeContracts(employeeContractsRequest);
    }
    
    /**
     * Adds or updates citizenship status.             
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-citizenship-status}
     * @param citizenshipStatus Request element for the Put Citizenship Status operation
     * @return Response element for the Put Citizenship Status operation.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public PutCitizenshipStatusResponseType putCitizenshipStatus(
            @Optional @Default("#[payload]") @RefOnly PutCitizenshipStatusRequestType citizenshipStatus) throws WorkdayException
    {
        return client.putCitizenshipStatus(citizenshipStatus);
    }
    
    /**
     * Adds or updates a worker document. The operation adds documents not associated 
     * with events and those documents are not secured by the events.  .               
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-worker-document}
     * @param workerDocument Request element for Put Worker Document
     * @return Response element for Put Worker Document.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public PutWorkerDocumentResponseType putWorkerDocument(
            @Optional @Default("#[payload]") @RefOnly PutWorkerDocumentRequestType workerDocument) throws WorkdayException
    {
        return client.putWorkerDocument(workerDocument);
    }
    
    /**
     * Removes the retirement status from a retired employee. Uses the Remove Retiree Status business process.               
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:remove-retiree-status}
     * @param retireeStatus wrapper for RemoveRetireeStatusRequestType
     * @return element containing information on Remove Retiree Status event.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public RemoveRetireeStatusResponseType removeRetireeStatus(
            @Optional @Default("#[payload]") @RefOnly RemoveRetireeStatusRequestType retireeStatus) throws WorkdayException
    {
        return client.removeRetireeStatus(retireeStatus);
    }
    
    /**
     * Terminates an employee.               
     *
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:terminate-employee}
     * @param employee Wrapper for Terminate Employee Web Service and its sub-processes.
     * @return element with the Event ID for the Terminate Employee Event along with the worker reference.
     * @throws WorkdayException If an error during the operation occurs this exception is thrown 
     */
    @Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
    public TerminateEmployeeEventResponseType terminateEmployee(
            @Optional @Default("#[payload]") @RefOnly TerminateEmployeeRequestType employee) throws WorkdayException
    {
        return client.terminateEmployee(employee);
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public void setClient(Object client)
    {
        this.client = (StaffingPort) client;
    }

    public String getUsername() {
        return username;
    }

    /**
     * Connects to Workday
     *
     * @param staffingUser Workday user
     * @param staffingPassword Workday password
     * @param staffingEndpoint Workday endpoint
     * @param staffingWsdlLocation Workday WSDL location
     * @throws org.mule.api.ConnectionException
     */
    @Connect
    public void connect(@FriendlyName("user") @ConnectionKey String staffingUser,
                        @FriendlyName("password") String staffingPassword,
                        @FriendlyName("endpoint") String staffingEndpoint,
                        @FriendlyName("wsdl") @Optional @Default("https://community.workday.com/custom/developer/API/Staffing/v23.0/Staffing.wsdl") String staffingWsdlLocation)
            throws ConnectionException {
        if (client == null)
        {
            setUsername(staffingUser);
            CxfStaffingClient cxfStaffingClient = new CxfStaffingClient(staffingUser, staffingPassword, staffingEndpoint, staffingWsdlLocation);
            initClient(cxfStaffingClient, cxfStaffingClient.getServiceVersion());
        }
    }

    /**
     * Disconnects
     */
    @Disconnect
    public void disconnect() {
        setClient(null);
    }

    /**
     * Validate connection
     * @return true if the connector is connected
     */
    @ValidateConnection
    public boolean validateConnection() {
        return getClient() != null;
    }

    /**
     * Connection identifier
     * @return connection identifier
     */
    @ConnectionIdentifier
    public String getConnectionIdentifier() {
        return "User: " + getUsername();
    }

	public StaffingPort getClient() {
		return client;
	}

	public void setClient(StaffingPort client) {
		this.client = client;
	}

	/**
	 * Adds or updates a job classification group and/or job classifications. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-job-classification-group}
	 * @param putJobClassificationGroupRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Put Job Classification Group")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public PutJobClassificationGroupResponseType putJobClassificationGroupStaffing(
            @Optional @Default("#[payload]") @RefOnly PutJobClassificationGroupRequestType putJobClassificationGroupRequest)
			throws WorkdayException {
		return client.putJobClassificationGroup(putJobClassificationGroupRequest);
	}

	/**
	 * Adds or updates a job family. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-job-family}
	 * @param putJobFamilyRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Put Job Family")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public PutJobFamilyResponseType putJobFamilyStaffing(
            @Optional @Default("#[payload]") @RefOnly PutJobFamilyRequestType putJobFamilyRequest) throws WorkdayException {
		return client.putJobFamily(putJobFamilyRequest);
	}

	/**
	 * This operation will invoke the Business Process to Close a Position or Headcount Restriction. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:close-position-or-headcount-restriction}
	 * @param closePositionOrHeadcountRestrictionRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public ClosePositionOrHeadcountRestrictionResponseType closePositionOrHeadcountRestriction(
			@Optional @Default("#[payload]") @RefOnly ClosePositionOrHeadcountRestrictionRequestType closePositionOrHeadcountRestrictionRequest) throws WorkdayException {
		return client.closePositionOrHeadcountRestriction(closePositionOrHeadcountRestrictionRequest);
	}

	/**
	 * Returns information for specified workers. If the request does not specify a worker, then the operation returns information for all workers. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-workers}
     * @param getWorkersRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Get Workers")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public GetWorkersResponseType getWorkersStaffing(
            @Optional @Default("#[payload]") @RefOnly GetWorkersRequestType getWorkersRequest) throws WorkdayException {
		return client.getWorkers(getWorkersRequest);
	}

	/**
	 * Returns job classification group data. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-job-classification-groups}
	 * @param getJobClassificationGroupsRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Get Job Classification Groups")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public GetJobClassificationGroupsResponseType getJobClassificationGroupsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetJobClassificationGroupsRequestType getJobClassificationGroupsRequest)
			throws WorkdayException {
		return client.getJobClassificationGroups(getJobClassificationGroupsRequest);
	}

	/**
	 * Returns job family and job family group data. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-job-family-groups}
	 * @param getJobFamilyGroupsRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Get Job Family Groups")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public GetJobFamilyGroupsResponseType getJobFamilyGroupsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetJobFamilyGroupsRequestType getJobFamilyGroupsRequest) throws WorkdayException {
		return client.getJobFamilyGroups(getJobFamilyGroupsRequest);
	}

	/**
	 * Returns organization information for a type of organization. If the request does not specify an organization, the operation returns information for all organizations. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-organizations}
	 * @param getOrganizationsRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Get Organizations")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public GetOrganizationsResponseType getOrganizationsStaffing(
            @Optional @Default("#[payload]") @RefOnly GetOrganizationsRequestType getOrganizationsRequest) throws WorkdayException {
		return client.getOrganizations(getOrganizationsRequest);
	}

	/**
	 * Adds or updates a job family group. Also adds or removes a group's associated job families. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-job-family-group}
	 * @param putJobFamilyGroupRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Put Job Family Group")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public PutJobFamilyGroupResponseType putJobFamilyGroupStaffing(
            @Optional @Default("#[payload]") @RefOnly PutJobFamilyGroupRequestType putJobFamilyGroupRequest) throws WorkdayException {
		return client.putJobFamilyGroup(putJobFamilyGroupRequest);
	}

	/**
	 * Returns job family data. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-job-families}
	 * @param getJobFamiliesRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor(friendlyName = "Get Job Families")
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public GetJobFamiliesResponseType getJobFamiliesStaffing(
            @Optional @Default("#[payload]") @RefOnly GetJobFamiliesRequestType getJobFamiliesRequest) throws WorkdayException {
		return client.getJobFamilies(getJobFamiliesRequest);
	}

	/**
	 * This operation will invoke the business process to switch a workers primary job with one of their additional jobs. Uses the Switch Primary Job business process. 
     * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:switch-primary-job}
	 * @param switchPrimaryJobRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public SwitchPrimaryJobEventResponseType switchPrimaryJob(
            @Optional @Default("#[payload]") @RefOnly SwitchPrimaryJobRequestType switchPrimaryJobRequest) throws WorkdayException {
		return client.switchPrimaryJob(switchPrimaryJobRequest);
	}
	
	/**
	 * This operation will create the hiring restrictions for a job management supervisory organization.
	 *      
	 * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:set-hiring-restrictions}
	 * 
	 * @param setHiringRestrictionsRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public SetHiringRestrictionsResponseType setHiringRestrictions(@Optional @Default("#[payload]") @RefOnly SetHiringRestrictionsRequestType setHiringRestrictionsRequest)
			throws WorkdayException {
		return client.setHiringRestrictions(setHiringRestrictionsRequest);
	}
	
	/**
	 * This operation will create an Edit Hiring Restriction
	 * 
	 * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:edit-hiring-restrictions}
	 * 
	 * @param editHiringRestrictionsRequest The request object for the operation
	 * @return The response from the operation
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	public EditHiringRestrictionsResponseType editHiringRestrictions(@Optional @Default("#[payload]") @RefOnly EditHiringRestrictionsRequestType editHiringRestrictionsRequest)
			throws WorkdayException{
		return client.editHiringRestrictions(editHiringRestrictionsRequest);
	}
	
	/**
	 * DEPRECATED: Adds or updates a dependent 
	 *
	 * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:put-dependent}
	 *
	 * @param putDependentRequest Request object
	 * @return Wrapper element for the Put Dependent Returned data
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown 
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	@Deprecated
	public PutDependentResponseType putDependent(@Optional @Default("#[payload]") @RefOnly PutDependentRequestType putDependentRequest) throws WorkdayException
	{
		return client.putDependent(putDependentRequest);
	}

	/**
	 * DEPRECATED: Sets the academic tenure date for an employee. Replaced by Add/Update Academic Appointmen
	 *
	 * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:maintain-academic-tenure-date}
	 *
	 * @param maintainAcademicTenureDateRequest Request object
	 * @return Responds with the Event ID for the Maintain Academic Tenure Event
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown 
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	@Deprecated
	public MaintainAcademicTenureDateResponseType maintainAcademicTenureDate(@Optional @Default("#[payload]") @RefOnly MaintainAcademicTenureDateRequestType maintainAcademicTenureDateRequest) throws WorkdayException
	{
		return client.maintainAcademicTenureDate(maintainAcademicTenureDateRequest);
	}

	/**
	 * DEPRECATED: This web service should not be used. Instead use the Get Workers web service. That is the supported public interface for employee data (including their contracts
	 *
	 * {@sample.xml ../../../doc/staffing.xml.sample wd-staffing:get-maintain-employee-contracts}
	 *
	 * @param getMaintainEmployeeContractsRequest Request object
	 * @return Reponse element containing instances of employee contracts and their associated data
	 * @throws WorkdayException If an error during the operation occurs this exception is thrown 
	 */
	@Processor
	@InvalidateConnectionOn(exception = WorkdayCredentialsException.class)
	@Deprecated
	public GetMaintainEmployeeContractsResponseType getMaintainEmployeeContracts(@Optional @Default("#[payload]") @RefOnly GetMaintainEmployeeContractsRequestType getMaintainEmployeeContractsRequest) throws WorkdayException
	{
		return client.getMaintainEmployeeContracts(getMaintainEmployeeContractsRequest);
	}
}
