
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Use the response group to limit the response to the data you are interested in. If the request does not set any values for the response group, then the response by default returns the following elements: Reference, Personal Data, Employment Data, Compensation Data, Organization Data, and Role Data.
 * 
 * <p>Java class for Worker_Response_GroupType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Worker_Response_GroupType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Include_Reference" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Personal_Information" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Employment_Information" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Compensation" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Organizations" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Organization_Support_Role_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Location_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Cost_Centers" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Cost_Center_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Companies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Company_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Matrix_Organizations" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Pay_Groups" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Regions" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Region_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Supervisory_Organizations" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Teams" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Custom_Organizations" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Roles" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Management_Chain_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Multiple_Managers_in_Management_Chain_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Benefit_Enrollments" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Benefit_Eligibility" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Related_Persons" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Qualifications" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Employee_Review" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Goals" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Development_Items" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Skills" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Photo" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Worker_Documents" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Transaction_Log_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Succession_Profile" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Talent_Assessment" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Employee_Contract_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Collective_Agreement_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Probation_Period_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Feedback_Received" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_User_Account" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Career" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Account_Provisioning" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Background_Check_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Contingent_Worker_Tax_Authority_Form_Information" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Funds" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Fund_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Grants" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Grant_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Business_Units" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Business_Unit_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Programs" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Program_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Gifts" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Gift_Hierarchies" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Worker_Response_GroupType", propOrder = {
    "includeReference",
    "includePersonalInformation",
    "includeEmploymentInformation",
    "includeCompensation",
    "includeOrganizations",
    "excludeOrganizationSupportRoleData",
    "excludeLocationHierarchies",
    "excludeCostCenters",
    "excludeCostCenterHierarchies",
    "excludeCompanies",
    "excludeCompanyHierarchies",
    "excludeMatrixOrganizations",
    "excludePayGroups",
    "excludeRegions",
    "excludeRegionHierarchies",
    "excludeSupervisoryOrganizations",
    "excludeTeams",
    "excludeCustomOrganizations",
    "includeRoles",
    "includeManagementChainData",
    "includeMultipleManagersInManagementChainData",
    "includeBenefitEnrollments",
    "includeBenefitEligibility",
    "includeRelatedPersons",
    "includeQualifications",
    "includeEmployeeReview",
    "includeGoals",
    "includeDevelopmentItems",
    "includeSkills",
    "includePhoto",
    "includeWorkerDocuments",
    "includeTransactionLogData",
    "includeSuccessionProfile",
    "includeTalentAssessment",
    "includeEmployeeContractData",
    "includeCollectiveAgreementData",
    "includeProbationPeriodData",
    "includeFeedbackReceived",
    "includeUserAccount",
    "includeCareer",
    "includeAccountProvisioning",
    "includeBackgroundCheckData",
    "includeContingentWorkerTaxAuthorityFormInformation",
    "excludeFunds",
    "excludeFundHierarchies",
    "excludeGrants",
    "excludeGrantHierarchies",
    "excludeBusinessUnits",
    "excludeBusinessUnitHierarchies",
    "excludePrograms",
    "excludeProgramHierarchies",
    "excludeGifts",
    "excludeGiftHierarchies"
})
public class WorkerResponseGroupType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Include_Reference")
    protected Boolean includeReference;
    @XmlElement(name = "Include_Personal_Information")
    protected Boolean includePersonalInformation;
    @XmlElement(name = "Include_Employment_Information")
    protected Boolean includeEmploymentInformation;
    @XmlElement(name = "Include_Compensation")
    protected Boolean includeCompensation;
    @XmlElement(name = "Include_Organizations")
    protected Boolean includeOrganizations;
    @XmlElement(name = "Exclude_Organization_Support_Role_Data")
    protected Boolean excludeOrganizationSupportRoleData;
    @XmlElement(name = "Exclude_Location_Hierarchies")
    protected Boolean excludeLocationHierarchies;
    @XmlElement(name = "Exclude_Cost_Centers")
    protected Boolean excludeCostCenters;
    @XmlElement(name = "Exclude_Cost_Center_Hierarchies")
    protected Boolean excludeCostCenterHierarchies;
    @XmlElement(name = "Exclude_Companies")
    protected Boolean excludeCompanies;
    @XmlElement(name = "Exclude_Company_Hierarchies")
    protected Boolean excludeCompanyHierarchies;
    @XmlElement(name = "Exclude_Matrix_Organizations")
    protected Boolean excludeMatrixOrganizations;
    @XmlElement(name = "Exclude_Pay_Groups")
    protected Boolean excludePayGroups;
    @XmlElement(name = "Exclude_Regions")
    protected Boolean excludeRegions;
    @XmlElement(name = "Exclude_Region_Hierarchies")
    protected Boolean excludeRegionHierarchies;
    @XmlElement(name = "Exclude_Supervisory_Organizations")
    protected Boolean excludeSupervisoryOrganizations;
    @XmlElement(name = "Exclude_Teams")
    protected Boolean excludeTeams;
    @XmlElement(name = "Exclude_Custom_Organizations")
    protected Boolean excludeCustomOrganizations;
    @XmlElement(name = "Include_Roles")
    protected Boolean includeRoles;
    @XmlElement(name = "Include_Management_Chain_Data")
    protected Boolean includeManagementChainData;
    @XmlElement(name = "Include_Multiple_Managers_in_Management_Chain_Data")
    protected Boolean includeMultipleManagersInManagementChainData;
    @XmlElement(name = "Include_Benefit_Enrollments")
    protected Boolean includeBenefitEnrollments;
    @XmlElement(name = "Include_Benefit_Eligibility")
    protected Boolean includeBenefitEligibility;
    @XmlElement(name = "Include_Related_Persons")
    protected Boolean includeRelatedPersons;
    @XmlElement(name = "Include_Qualifications")
    protected Boolean includeQualifications;
    @XmlElement(name = "Include_Employee_Review")
    protected Boolean includeEmployeeReview;
    @XmlElement(name = "Include_Goals")
    protected Boolean includeGoals;
    @XmlElement(name = "Include_Development_Items")
    protected Boolean includeDevelopmentItems;
    @XmlElement(name = "Include_Skills")
    protected Boolean includeSkills;
    @XmlElement(name = "Include_Photo")
    protected Boolean includePhoto;
    @XmlElement(name = "Include_Worker_Documents")
    protected Boolean includeWorkerDocuments;
    @XmlElement(name = "Include_Transaction_Log_Data")
    protected Boolean includeTransactionLogData;
    @XmlElement(name = "Include_Succession_Profile")
    protected Boolean includeSuccessionProfile;
    @XmlElement(name = "Include_Talent_Assessment")
    protected Boolean includeTalentAssessment;
    @XmlElement(name = "Include_Employee_Contract_Data")
    protected Boolean includeEmployeeContractData;
    @XmlElement(name = "Include_Collective_Agreement_Data")
    protected Boolean includeCollectiveAgreementData;
    @XmlElement(name = "Include_Probation_Period_Data")
    protected Boolean includeProbationPeriodData;
    @XmlElement(name = "Include_Feedback_Received")
    protected Boolean includeFeedbackReceived;
    @XmlElement(name = "Include_User_Account")
    protected Boolean includeUserAccount;
    @XmlElement(name = "Include_Career")
    protected Boolean includeCareer;
    @XmlElement(name = "Include_Account_Provisioning")
    protected Boolean includeAccountProvisioning;
    @XmlElement(name = "Include_Background_Check_Data")
    protected Boolean includeBackgroundCheckData;
    @XmlElement(name = "Include_Contingent_Worker_Tax_Authority_Form_Information")
    protected Boolean includeContingentWorkerTaxAuthorityFormInformation;
    @XmlElement(name = "Exclude_Funds")
    protected Boolean excludeFunds;
    @XmlElement(name = "Exclude_Fund_Hierarchies")
    protected Boolean excludeFundHierarchies;
    @XmlElement(name = "Exclude_Grants")
    protected Boolean excludeGrants;
    @XmlElement(name = "Exclude_Grant_Hierarchies")
    protected Boolean excludeGrantHierarchies;
    @XmlElement(name = "Exclude_Business_Units")
    protected Boolean excludeBusinessUnits;
    @XmlElement(name = "Exclude_Business_Unit_Hierarchies")
    protected Boolean excludeBusinessUnitHierarchies;
    @XmlElement(name = "Exclude_Programs")
    protected Boolean excludePrograms;
    @XmlElement(name = "Exclude_Program_Hierarchies")
    protected Boolean excludeProgramHierarchies;
    @XmlElement(name = "Exclude_Gifts")
    protected Boolean excludeGifts;
    @XmlElement(name = "Exclude_Gift_Hierarchies")
    protected Boolean excludeGiftHierarchies;

    /**
     * Gets the value of the includeReference property.
     * This getter has been renamed from isIncludeReference() to getIncludeReference() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeReference() {
        return includeReference;
    }

    /**
     * Sets the value of the includeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeReference(Boolean value) {
        this.includeReference = value;
    }

    /**
     * Gets the value of the includePersonalInformation property.
     * This getter has been renamed from isIncludePersonalInformation() to getIncludePersonalInformation() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludePersonalInformation() {
        return includePersonalInformation;
    }

    /**
     * Sets the value of the includePersonalInformation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludePersonalInformation(Boolean value) {
        this.includePersonalInformation = value;
    }

    /**
     * Gets the value of the includeEmploymentInformation property.
     * This getter has been renamed from isIncludeEmploymentInformation() to getIncludeEmploymentInformation() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeEmploymentInformation() {
        return includeEmploymentInformation;
    }

    /**
     * Sets the value of the includeEmploymentInformation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeEmploymentInformation(Boolean value) {
        this.includeEmploymentInformation = value;
    }

    /**
     * Gets the value of the includeCompensation property.
     * This getter has been renamed from isIncludeCompensation() to getIncludeCompensation() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeCompensation() {
        return includeCompensation;
    }

    /**
     * Sets the value of the includeCompensation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeCompensation(Boolean value) {
        this.includeCompensation = value;
    }

    /**
     * Gets the value of the includeOrganizations property.
     * This getter has been renamed from isIncludeOrganizations() to getIncludeOrganizations() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeOrganizations() {
        return includeOrganizations;
    }

    /**
     * Sets the value of the includeOrganizations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeOrganizations(Boolean value) {
        this.includeOrganizations = value;
    }

    /**
     * Gets the value of the excludeOrganizationSupportRoleData property.
     * This getter has been renamed from isExcludeOrganizationSupportRoleData() to getExcludeOrganizationSupportRoleData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeOrganizationSupportRoleData() {
        return excludeOrganizationSupportRoleData;
    }

    /**
     * Sets the value of the excludeOrganizationSupportRoleData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeOrganizationSupportRoleData(Boolean value) {
        this.excludeOrganizationSupportRoleData = value;
    }

    /**
     * Gets the value of the excludeLocationHierarchies property.
     * This getter has been renamed from isExcludeLocationHierarchies() to getExcludeLocationHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeLocationHierarchies() {
        return excludeLocationHierarchies;
    }

    /**
     * Sets the value of the excludeLocationHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeLocationHierarchies(Boolean value) {
        this.excludeLocationHierarchies = value;
    }

    /**
     * Gets the value of the excludeCostCenters property.
     * This getter has been renamed from isExcludeCostCenters() to getExcludeCostCenters() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeCostCenters() {
        return excludeCostCenters;
    }

    /**
     * Sets the value of the excludeCostCenters property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeCostCenters(Boolean value) {
        this.excludeCostCenters = value;
    }

    /**
     * Gets the value of the excludeCostCenterHierarchies property.
     * This getter has been renamed from isExcludeCostCenterHierarchies() to getExcludeCostCenterHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeCostCenterHierarchies() {
        return excludeCostCenterHierarchies;
    }

    /**
     * Sets the value of the excludeCostCenterHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeCostCenterHierarchies(Boolean value) {
        this.excludeCostCenterHierarchies = value;
    }

    /**
     * Gets the value of the excludeCompanies property.
     * This getter has been renamed from isExcludeCompanies() to getExcludeCompanies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeCompanies() {
        return excludeCompanies;
    }

    /**
     * Sets the value of the excludeCompanies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeCompanies(Boolean value) {
        this.excludeCompanies = value;
    }

    /**
     * Gets the value of the excludeCompanyHierarchies property.
     * This getter has been renamed from isExcludeCompanyHierarchies() to getExcludeCompanyHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeCompanyHierarchies() {
        return excludeCompanyHierarchies;
    }

    /**
     * Sets the value of the excludeCompanyHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeCompanyHierarchies(Boolean value) {
        this.excludeCompanyHierarchies = value;
    }

    /**
     * Gets the value of the excludeMatrixOrganizations property.
     * This getter has been renamed from isExcludeMatrixOrganizations() to getExcludeMatrixOrganizations() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeMatrixOrganizations() {
        return excludeMatrixOrganizations;
    }

    /**
     * Sets the value of the excludeMatrixOrganizations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeMatrixOrganizations(Boolean value) {
        this.excludeMatrixOrganizations = value;
    }

    /**
     * Gets the value of the excludePayGroups property.
     * This getter has been renamed from isExcludePayGroups() to getExcludePayGroups() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludePayGroups() {
        return excludePayGroups;
    }

    /**
     * Sets the value of the excludePayGroups property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludePayGroups(Boolean value) {
        this.excludePayGroups = value;
    }

    /**
     * Gets the value of the excludeRegions property.
     * This getter has been renamed from isExcludeRegions() to getExcludeRegions() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeRegions() {
        return excludeRegions;
    }

    /**
     * Sets the value of the excludeRegions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeRegions(Boolean value) {
        this.excludeRegions = value;
    }

    /**
     * Gets the value of the excludeRegionHierarchies property.
     * This getter has been renamed from isExcludeRegionHierarchies() to getExcludeRegionHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeRegionHierarchies() {
        return excludeRegionHierarchies;
    }

    /**
     * Sets the value of the excludeRegionHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeRegionHierarchies(Boolean value) {
        this.excludeRegionHierarchies = value;
    }

    /**
     * Gets the value of the excludeSupervisoryOrganizations property.
     * This getter has been renamed from isExcludeSupervisoryOrganizations() to getExcludeSupervisoryOrganizations() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeSupervisoryOrganizations() {
        return excludeSupervisoryOrganizations;
    }

    /**
     * Sets the value of the excludeSupervisoryOrganizations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeSupervisoryOrganizations(Boolean value) {
        this.excludeSupervisoryOrganizations = value;
    }

    /**
     * Gets the value of the excludeTeams property.
     * This getter has been renamed from isExcludeTeams() to getExcludeTeams() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeTeams() {
        return excludeTeams;
    }

    /**
     * Sets the value of the excludeTeams property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeTeams(Boolean value) {
        this.excludeTeams = value;
    }

    /**
     * Gets the value of the excludeCustomOrganizations property.
     * This getter has been renamed from isExcludeCustomOrganizations() to getExcludeCustomOrganizations() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeCustomOrganizations() {
        return excludeCustomOrganizations;
    }

    /**
     * Sets the value of the excludeCustomOrganizations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeCustomOrganizations(Boolean value) {
        this.excludeCustomOrganizations = value;
    }

    /**
     * Gets the value of the includeRoles property.
     * This getter has been renamed from isIncludeRoles() to getIncludeRoles() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeRoles() {
        return includeRoles;
    }

    /**
     * Sets the value of the includeRoles property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeRoles(Boolean value) {
        this.includeRoles = value;
    }

    /**
     * Gets the value of the includeManagementChainData property.
     * This getter has been renamed from isIncludeManagementChainData() to getIncludeManagementChainData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeManagementChainData() {
        return includeManagementChainData;
    }

    /**
     * Sets the value of the includeManagementChainData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeManagementChainData(Boolean value) {
        this.includeManagementChainData = value;
    }

    /**
     * Gets the value of the includeMultipleManagersInManagementChainData property.
     * This getter has been renamed from isIncludeMultipleManagersInManagementChainData() to getIncludeMultipleManagersInManagementChainData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeMultipleManagersInManagementChainData() {
        return includeMultipleManagersInManagementChainData;
    }

    /**
     * Sets the value of the includeMultipleManagersInManagementChainData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeMultipleManagersInManagementChainData(Boolean value) {
        this.includeMultipleManagersInManagementChainData = value;
    }

    /**
     * Gets the value of the includeBenefitEnrollments property.
     * This getter has been renamed from isIncludeBenefitEnrollments() to getIncludeBenefitEnrollments() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeBenefitEnrollments() {
        return includeBenefitEnrollments;
    }

    /**
     * Sets the value of the includeBenefitEnrollments property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeBenefitEnrollments(Boolean value) {
        this.includeBenefitEnrollments = value;
    }

    /**
     * Gets the value of the includeBenefitEligibility property.
     * This getter has been renamed from isIncludeBenefitEligibility() to getIncludeBenefitEligibility() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeBenefitEligibility() {
        return includeBenefitEligibility;
    }

    /**
     * Sets the value of the includeBenefitEligibility property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeBenefitEligibility(Boolean value) {
        this.includeBenefitEligibility = value;
    }

    /**
     * Gets the value of the includeRelatedPersons property.
     * This getter has been renamed from isIncludeRelatedPersons() to getIncludeRelatedPersons() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeRelatedPersons() {
        return includeRelatedPersons;
    }

    /**
     * Sets the value of the includeRelatedPersons property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeRelatedPersons(Boolean value) {
        this.includeRelatedPersons = value;
    }

    /**
     * Gets the value of the includeQualifications property.
     * This getter has been renamed from isIncludeQualifications() to getIncludeQualifications() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeQualifications() {
        return includeQualifications;
    }

    /**
     * Sets the value of the includeQualifications property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeQualifications(Boolean value) {
        this.includeQualifications = value;
    }

    /**
     * Gets the value of the includeEmployeeReview property.
     * This getter has been renamed from isIncludeEmployeeReview() to getIncludeEmployeeReview() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeEmployeeReview() {
        return includeEmployeeReview;
    }

    /**
     * Sets the value of the includeEmployeeReview property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeEmployeeReview(Boolean value) {
        this.includeEmployeeReview = value;
    }

    /**
     * Gets the value of the includeGoals property.
     * This getter has been renamed from isIncludeGoals() to getIncludeGoals() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeGoals() {
        return includeGoals;
    }

    /**
     * Sets the value of the includeGoals property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeGoals(Boolean value) {
        this.includeGoals = value;
    }

    /**
     * Gets the value of the includeDevelopmentItems property.
     * This getter has been renamed from isIncludeDevelopmentItems() to getIncludeDevelopmentItems() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeDevelopmentItems() {
        return includeDevelopmentItems;
    }

    /**
     * Sets the value of the includeDevelopmentItems property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDevelopmentItems(Boolean value) {
        this.includeDevelopmentItems = value;
    }

    /**
     * Gets the value of the includeSkills property.
     * This getter has been renamed from isIncludeSkills() to getIncludeSkills() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeSkills() {
        return includeSkills;
    }

    /**
     * Sets the value of the includeSkills property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeSkills(Boolean value) {
        this.includeSkills = value;
    }

    /**
     * Gets the value of the includePhoto property.
     * This getter has been renamed from isIncludePhoto() to getIncludePhoto() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludePhoto() {
        return includePhoto;
    }

    /**
     * Sets the value of the includePhoto property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludePhoto(Boolean value) {
        this.includePhoto = value;
    }

    /**
     * Gets the value of the includeWorkerDocuments property.
     * This getter has been renamed from isIncludeWorkerDocuments() to getIncludeWorkerDocuments() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeWorkerDocuments() {
        return includeWorkerDocuments;
    }

    /**
     * Sets the value of the includeWorkerDocuments property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeWorkerDocuments(Boolean value) {
        this.includeWorkerDocuments = value;
    }

    /**
     * Gets the value of the includeTransactionLogData property.
     * This getter has been renamed from isIncludeTransactionLogData() to getIncludeTransactionLogData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeTransactionLogData() {
        return includeTransactionLogData;
    }

    /**
     * Sets the value of the includeTransactionLogData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeTransactionLogData(Boolean value) {
        this.includeTransactionLogData = value;
    }

    /**
     * Gets the value of the includeSuccessionProfile property.
     * This getter has been renamed from isIncludeSuccessionProfile() to getIncludeSuccessionProfile() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeSuccessionProfile() {
        return includeSuccessionProfile;
    }

    /**
     * Sets the value of the includeSuccessionProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeSuccessionProfile(Boolean value) {
        this.includeSuccessionProfile = value;
    }

    /**
     * Gets the value of the includeTalentAssessment property.
     * This getter has been renamed from isIncludeTalentAssessment() to getIncludeTalentAssessment() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeTalentAssessment() {
        return includeTalentAssessment;
    }

    /**
     * Sets the value of the includeTalentAssessment property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeTalentAssessment(Boolean value) {
        this.includeTalentAssessment = value;
    }

    /**
     * Gets the value of the includeEmployeeContractData property.
     * This getter has been renamed from isIncludeEmployeeContractData() to getIncludeEmployeeContractData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeEmployeeContractData() {
        return includeEmployeeContractData;
    }

    /**
     * Sets the value of the includeEmployeeContractData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeEmployeeContractData(Boolean value) {
        this.includeEmployeeContractData = value;
    }

    /**
     * Gets the value of the includeCollectiveAgreementData property.
     * This getter has been renamed from isIncludeCollectiveAgreementData() to getIncludeCollectiveAgreementData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeCollectiveAgreementData() {
        return includeCollectiveAgreementData;
    }

    /**
     * Sets the value of the includeCollectiveAgreementData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeCollectiveAgreementData(Boolean value) {
        this.includeCollectiveAgreementData = value;
    }

    /**
     * Gets the value of the includeProbationPeriodData property.
     * This getter has been renamed from isIncludeProbationPeriodData() to getIncludeProbationPeriodData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeProbationPeriodData() {
        return includeProbationPeriodData;
    }

    /**
     * Sets the value of the includeProbationPeriodData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeProbationPeriodData(Boolean value) {
        this.includeProbationPeriodData = value;
    }

    /**
     * Gets the value of the includeFeedbackReceived property.
     * This getter has been renamed from isIncludeFeedbackReceived() to getIncludeFeedbackReceived() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeFeedbackReceived() {
        return includeFeedbackReceived;
    }

    /**
     * Sets the value of the includeFeedbackReceived property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeFeedbackReceived(Boolean value) {
        this.includeFeedbackReceived = value;
    }

    /**
     * Gets the value of the includeUserAccount property.
     * This getter has been renamed from isIncludeUserAccount() to getIncludeUserAccount() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeUserAccount() {
        return includeUserAccount;
    }

    /**
     * Sets the value of the includeUserAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeUserAccount(Boolean value) {
        this.includeUserAccount = value;
    }

    /**
     * Gets the value of the includeCareer property.
     * This getter has been renamed from isIncludeCareer() to getIncludeCareer() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeCareer() {
        return includeCareer;
    }

    /**
     * Sets the value of the includeCareer property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeCareer(Boolean value) {
        this.includeCareer = value;
    }

    /**
     * Gets the value of the includeAccountProvisioning property.
     * This getter has been renamed from isIncludeAccountProvisioning() to getIncludeAccountProvisioning() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeAccountProvisioning() {
        return includeAccountProvisioning;
    }

    /**
     * Sets the value of the includeAccountProvisioning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeAccountProvisioning(Boolean value) {
        this.includeAccountProvisioning = value;
    }

    /**
     * Gets the value of the includeBackgroundCheckData property.
     * This getter has been renamed from isIncludeBackgroundCheckData() to getIncludeBackgroundCheckData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeBackgroundCheckData() {
        return includeBackgroundCheckData;
    }

    /**
     * Sets the value of the includeBackgroundCheckData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeBackgroundCheckData(Boolean value) {
        this.includeBackgroundCheckData = value;
    }

    /**
     * Gets the value of the includeContingentWorkerTaxAuthorityFormInformation property.
     * This getter has been renamed from isIncludeContingentWorkerTaxAuthorityFormInformation() to getIncludeContingentWorkerTaxAuthorityFormInformation() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeContingentWorkerTaxAuthorityFormInformation() {
        return includeContingentWorkerTaxAuthorityFormInformation;
    }

    /**
     * Sets the value of the includeContingentWorkerTaxAuthorityFormInformation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeContingentWorkerTaxAuthorityFormInformation(Boolean value) {
        this.includeContingentWorkerTaxAuthorityFormInformation = value;
    }

    /**
     * Gets the value of the excludeFunds property.
     * This getter has been renamed from isExcludeFunds() to getExcludeFunds() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFunds() {
        return excludeFunds;
    }

    /**
     * Sets the value of the excludeFunds property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFunds(Boolean value) {
        this.excludeFunds = value;
    }

    /**
     * Gets the value of the excludeFundHierarchies property.
     * This getter has been renamed from isExcludeFundHierarchies() to getExcludeFundHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFundHierarchies() {
        return excludeFundHierarchies;
    }

    /**
     * Sets the value of the excludeFundHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFundHierarchies(Boolean value) {
        this.excludeFundHierarchies = value;
    }

    /**
     * Gets the value of the excludeGrants property.
     * This getter has been renamed from isExcludeGrants() to getExcludeGrants() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeGrants() {
        return excludeGrants;
    }

    /**
     * Sets the value of the excludeGrants property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeGrants(Boolean value) {
        this.excludeGrants = value;
    }

    /**
     * Gets the value of the excludeGrantHierarchies property.
     * This getter has been renamed from isExcludeGrantHierarchies() to getExcludeGrantHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeGrantHierarchies() {
        return excludeGrantHierarchies;
    }

    /**
     * Sets the value of the excludeGrantHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeGrantHierarchies(Boolean value) {
        this.excludeGrantHierarchies = value;
    }

    /**
     * Gets the value of the excludeBusinessUnits property.
     * This getter has been renamed from isExcludeBusinessUnits() to getExcludeBusinessUnits() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeBusinessUnits() {
        return excludeBusinessUnits;
    }

    /**
     * Sets the value of the excludeBusinessUnits property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeBusinessUnits(Boolean value) {
        this.excludeBusinessUnits = value;
    }

    /**
     * Gets the value of the excludeBusinessUnitHierarchies property.
     * This getter has been renamed from isExcludeBusinessUnitHierarchies() to getExcludeBusinessUnitHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeBusinessUnitHierarchies() {
        return excludeBusinessUnitHierarchies;
    }

    /**
     * Sets the value of the excludeBusinessUnitHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeBusinessUnitHierarchies(Boolean value) {
        this.excludeBusinessUnitHierarchies = value;
    }

    /**
     * Gets the value of the excludePrograms property.
     * This getter has been renamed from isExcludePrograms() to getExcludePrograms() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludePrograms() {
        return excludePrograms;
    }

    /**
     * Sets the value of the excludePrograms property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludePrograms(Boolean value) {
        this.excludePrograms = value;
    }

    /**
     * Gets the value of the excludeProgramHierarchies property.
     * This getter has been renamed from isExcludeProgramHierarchies() to getExcludeProgramHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeProgramHierarchies() {
        return excludeProgramHierarchies;
    }

    /**
     * Sets the value of the excludeProgramHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeProgramHierarchies(Boolean value) {
        this.excludeProgramHierarchies = value;
    }

    /**
     * Gets the value of the excludeGifts property.
     * This getter has been renamed from isExcludeGifts() to getExcludeGifts() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeGifts() {
        return excludeGifts;
    }

    /**
     * Sets the value of the excludeGifts property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeGifts(Boolean value) {
        this.excludeGifts = value;
    }

    /**
     * Gets the value of the excludeGiftHierarchies property.
     * This getter has been renamed from isExcludeGiftHierarchies() to getExcludeGiftHierarchies() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeGiftHierarchies() {
        return excludeGiftHierarchies;
    }

    /**
     * Sets the value of the excludeGiftHierarchies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeGiftHierarchies(Boolean value) {
        this.excludeGiftHierarchies = value;
    }

}
