
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Data Element that contains the basic information to terminate an employee. All required information must be included. The Terminate Employee business process (for the employee) will be initiated from this information.
 * 
 * <p>Java class for Terminate_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Terminate_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Last_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Primary_Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType"/>
 *         &lt;element name="Secondary_Reason_Reference" type="{urn:com.workday/bsvc}Termination_SubcategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Local_Termination_Reason_Reference" type="{urn:com.workday/bsvc}Local_Termination_ReasonObjectType" minOccurs="0"/>
 *         &lt;element name="Pay_Through_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Resignation_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Notify_Employee_By_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Regrettable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Close_Position" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Job_Overlap_Allowed" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Last_Date_for_Which_Paid" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Expected_Date_of_Return" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Not_Returning" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Return_Unknown" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Terminate_Event_DataType", propOrder = {
    "lastDayOfWork",
    "primaryReasonReference",
    "secondaryReasonReference",
    "localTerminationReasonReference",
    "payThroughDate",
    "resignationDate",
    "notifyEmployeeByDate",
    "regrettable",
    "closePosition",
    "jobOverlapAllowed",
    "lastDateForWhichPaid",
    "expectedDateOfReturn",
    "notReturning",
    "returnUnknown",
    "workerDocumentData"
})
public class TerminateEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Last_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar lastDayOfWork;
    @XmlElement(name = "Primary_Reason_Reference", required = true)
    protected EventClassificationSubcategoryObjectType primaryReasonReference;
    @XmlElement(name = "Secondary_Reason_Reference")
    protected List<TerminationSubcategoryObjectType> secondaryReasonReference;
    @XmlElement(name = "Local_Termination_Reason_Reference")
    protected LocalTerminationReasonObjectType localTerminationReasonReference;
    @XmlElement(name = "Pay_Through_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar payThroughDate;
    @XmlElement(name = "Resignation_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar resignationDate;
    @XmlElement(name = "Notify_Employee_By_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar notifyEmployeeByDate;
    @XmlElement(name = "Regrettable")
    protected Boolean regrettable;
    @XmlElement(name = "Close_Position")
    protected Boolean closePosition;
    @XmlElement(name = "Job_Overlap_Allowed")
    protected Boolean jobOverlapAllowed;
    @XmlElement(name = "Last_Date_for_Which_Paid")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar lastDateForWhichPaid;
    @XmlElement(name = "Expected_Date_of_Return")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expectedDateOfReturn;
    @XmlElement(name = "Not_Returning")
    protected Boolean notReturning;
    @XmlElement(name = "Return_Unknown")
    protected Boolean returnUnknown;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;

    /**
     * Gets the value of the lastDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastDayOfWork() {
        return lastDayOfWork;
    }

    /**
     * Sets the value of the lastDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastDayOfWork(XMLGregorianCalendar value) {
        this.lastDayOfWork = value;
    }

    /**
     * Gets the value of the primaryReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getPrimaryReasonReference() {
        return primaryReasonReference;
    }

    /**
     * Sets the value of the primaryReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setPrimaryReasonReference(EventClassificationSubcategoryObjectType value) {
        this.primaryReasonReference = value;
    }

    /**
     * Gets the value of the secondaryReasonReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the secondaryReasonReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSecondaryReasonReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TerminationSubcategoryObjectType }
     * 
     * 
     */
    public List<TerminationSubcategoryObjectType> getSecondaryReasonReference() {
        if (secondaryReasonReference == null) {
            secondaryReasonReference = new ArrayList<TerminationSubcategoryObjectType>();
        }
        return this.secondaryReasonReference;
    }

    /**
     * Gets the value of the localTerminationReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTerminationReasonObjectType }
     *     
     */
    public LocalTerminationReasonObjectType getLocalTerminationReasonReference() {
        return localTerminationReasonReference;
    }

    /**
     * Sets the value of the localTerminationReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTerminationReasonObjectType }
     *     
     */
    public void setLocalTerminationReasonReference(LocalTerminationReasonObjectType value) {
        this.localTerminationReasonReference = value;
    }

    /**
     * Gets the value of the payThroughDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getPayThroughDate() {
        return payThroughDate;
    }

    /**
     * Sets the value of the payThroughDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setPayThroughDate(XMLGregorianCalendar value) {
        this.payThroughDate = value;
    }

    /**
     * Gets the value of the resignationDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getResignationDate() {
        return resignationDate;
    }

    /**
     * Sets the value of the resignationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setResignationDate(XMLGregorianCalendar value) {
        this.resignationDate = value;
    }

    /**
     * Gets the value of the notifyEmployeeByDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getNotifyEmployeeByDate() {
        return notifyEmployeeByDate;
    }

    /**
     * Sets the value of the notifyEmployeeByDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setNotifyEmployeeByDate(XMLGregorianCalendar value) {
        this.notifyEmployeeByDate = value;
    }

    /**
     * Gets the value of the regrettable property.
     * This getter has been renamed from isRegrettable() to getRegrettable() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRegrettable() {
        return regrettable;
    }

    /**
     * Sets the value of the regrettable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRegrettable(Boolean value) {
        this.regrettable = value;
    }

    /**
     * Gets the value of the closePosition property.
     * This getter has been renamed from isClosePosition() to getClosePosition() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getClosePosition() {
        return closePosition;
    }

    /**
     * Sets the value of the closePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setClosePosition(Boolean value) {
        this.closePosition = value;
    }

    /**
     * Gets the value of the jobOverlapAllowed property.
     * This getter has been renamed from isJobOverlapAllowed() to getJobOverlapAllowed() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getJobOverlapAllowed() {
        return jobOverlapAllowed;
    }

    /**
     * Sets the value of the jobOverlapAllowed property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setJobOverlapAllowed(Boolean value) {
        this.jobOverlapAllowed = value;
    }

    /**
     * Gets the value of the lastDateForWhichPaid property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastDateForWhichPaid() {
        return lastDateForWhichPaid;
    }

    /**
     * Sets the value of the lastDateForWhichPaid property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastDateForWhichPaid(XMLGregorianCalendar value) {
        this.lastDateForWhichPaid = value;
    }

    /**
     * Gets the value of the expectedDateOfReturn property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpectedDateOfReturn() {
        return expectedDateOfReturn;
    }

    /**
     * Sets the value of the expectedDateOfReturn property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpectedDateOfReturn(XMLGregorianCalendar value) {
        this.expectedDateOfReturn = value;
    }

    /**
     * Gets the value of the notReturning property.
     * This getter has been renamed from isNotReturning() to getNotReturning() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getNotReturning() {
        return notReturning;
    }

    /**
     * Sets the value of the notReturning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setNotReturning(Boolean value) {
        this.notReturning = value;
    }

    /**
     * Gets the value of the returnUnknown property.
     * This getter has been renamed from isReturnUnknown() to getReturnUnknown() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getReturnUnknown() {
        return returnUnknown;
    }

    /**
     * Sets the value of the returnUnknown property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReturnUnknown(Boolean value) {
        this.returnUnknown = value;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Sets the value of the secondaryReasonReference property.
     * 
     * @param secondaryReasonReference
     *     allowed object is
     *     {@link TerminationSubcategoryObjectType }
     *     
     */
    public void setSecondaryReasonReference(List<TerminationSubcategoryObjectType> secondaryReasonReference) {
        this.secondaryReasonReference = secondaryReasonReference;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
