package com.workday.staffing;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;

/**
 * The Staffing Web Service operations expose Workday Human Capital Management Business Services and data. These services pertain to staffing transactions for both employees and contingent workers, such as bringing employees and contingent workers on board.
 *
 * This class was generated by Apache CXF 2.5.1
 * 2014-12-15T16:26:02.735-03:00
 * Generated source version: 2.5.1
 * 
 */
@WebService(targetNamespace = "urn:com.workday/bsvc/Staffing", name = "StaffingPort")
@XmlSeeAlso({ObjectFactory.class})
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
public interface StaffingPort {

    /**
     * Adds or updates citizenship status.
     */
    @WebResult(name = "Put_Citizenship_Status_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Citizenship_Status")
    public PutCitizenshipStatusResponseType putCitizenshipStatus(
        @WebParam(partName = "body", name = "Put_Citizenship_Status_Request", targetNamespace = "urn:com.workday/bsvc")
        PutCitizenshipStatusRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Sets a worker's service dates. Uses the Edit Service Dates business process.
     */
    @WebResult(name = "Edit_Service_Dates_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Edit_Service_Dates")
    public EditServiceDatesResponseType editServiceDates(
        @WebParam(partName = "body", name = "Edit_Service_Dates_Request", targetNamespace = "urn:com.workday/bsvc")
        EditServiceDatesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Assigns company, cost center, region, fund, grant, business unit, program, and custom organizations configured for staffing usage to a staffing position. Uses the Change Organization Assignments for Worker business process.
     */
    @WebResult(name = "Assign_Organization_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Assign_Organization")
    public AssignOrganizationResponseType assignOrganization(
        @WebParam(partName = "body", name = "Assign_Organization_Request", targetNamespace = "urn:com.workday/bsvc")
        AssignOrganizationRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Perform a job change on an employee or contingent worker. Uses the Change Job business process. The types of changes include transfer, promotion, demotion, lateral moves and any other change of data on the job.
     */
    @WebResult(name = "Change_Job_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Change_Job")
    public ChangeJobResponseType changeJob(
        @WebParam(partName = "body", name = "Change_Job_Request", targetNamespace = "urn:com.workday/bsvc")
        ChangeJobRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Ends a contingent worker's contract. Uses the End Contingent Worker Contract Business Process.
     */
    @WebResult(name = "End_Contingent_Worker_Contract_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "End_Contingent_Worker_Contract")
    public EndContingentWorkerContractResponseType endContingentWorkerContract(
        @WebParam(partName = "body", name = "End_Contingent_Worker_Contract_Request", targetNamespace = "urn:com.workday/bsvc")
        EndContingentWorkerContractRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates a job classification group and/or job classifications.
     */
    @WebResult(name = "Put_Job_Classification_Group_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Job_Classification_Group")
    public PutJobClassificationGroupResponseType putJobClassificationGroup(
        @WebParam(partName = "body", name = "Put_Job_Classification_Group_Request", targetNamespace = "urn:com.workday/bsvc")
        PutJobClassificationGroupRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates a job family.
     */
    @WebResult(name = "Put_Job_Family_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Job_Family")
    public PutJobFamilyResponseType putJobFamily(
        @WebParam(partName = "body", name = "Put_Job_Family_Request", targetNamespace = "urn:com.workday/bsvc")
        PutJobFamilyRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will invoke the Business Process to Close a Position or Headcount Restriction.
     */
    @WebResult(name = "Close_Position_or_Headcount_Restriction_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Close_Position_or_Headcount_Restriction")
    public ClosePositionOrHeadcountRestrictionResponseType closePositionOrHeadcountRestriction(
        @WebParam(partName = "body", name = "Close_Position_or_Headcount_Restriction_Request", targetNamespace = "urn:com.workday/bsvc")
        ClosePositionOrHeadcountRestrictionRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates employee contracts. Uses the Maintain Employee Contracts business process.
     */
    @WebResult(name = "Maintain_Employee_Contracts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Maintain_Employee_Contracts")
    public MaintainEmployeeContractsResponseType maintainEmployeeContracts(
        @WebParam(partName = "body", name = "Maintain_Employee_Contracts_Request", targetNamespace = "urn:com.workday/bsvc")
        MaintainEmployeeContractsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Edits an existing position restriction. Uses the Edit Position Restrictions business process.
     */
    @WebResult(name = "Edit_Positon_Restriction_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Edit_Position_Restrictions")
    public EditPositonRestrictionResponseType editPositionRestrictions(
        @WebParam(partName = "body", name = "Edit_Position_Restrictions_Request", targetNamespace = "urn:com.workday/bsvc")
        EditPositionRestrictionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Changes the status of a previously terminated worker to retiree. Uses the Add Retiree Status business process.
     */
    @WebResult(name = "Add_Retiree_Status_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Add_Retiree_Status")
    public AddRetireeStatusResponseType addRetireeStatus(
        @WebParam(partName = "body", name = "Add_Retiree_Status_Request", targetNamespace = "urn:com.workday/bsvc")
        AddRetireeStatusRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns information for position management positions. If a position is filled, identifies the worker filling the position.
     */
    @WebResult(name = "Get_Positions_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Positions")
    public GetPositionsResponseType getPositions(
        @WebParam(partName = "body", name = "Get_Positions_Request", targetNamespace = "urn:com.workday/bsvc")
        GetPositionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns information for specified workers. If the request does not specify a worker, then the operation returns information for all workers.
     */
    @WebResult(name = "Get_Workers_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Workers")
    public GetWorkersResponseType getWorkers(
        @WebParam(partName = "body", name = "Get_Workers_Request", targetNamespace = "urn:com.workday/bsvc")
        GetWorkersRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will edit the hiring restrictions for a job management supervisory organization.
     */
    @WebResult(name = "Edit_Hiring_Restrictions_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Edit_Hiring_Restrictions")
    public EditHiringRestrictionsResponseType editHiringRestrictions(
        @WebParam(partName = "body", name = "Edit_Hiring_Restrictions_Request", targetNamespace = "urn:com.workday/bsvc")
        EditHiringRestrictionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Contracts an existing pre-hire into a contingent worker position, headcount, or job. Uses the Contract Contingent Worker business process. Note: pre-hire was previously called applicant. However, the web service operation and its elements are not yet renamed, so that existing integrations continue to work.
     */
    @WebResult(name = "Contract_Contingent_Worker_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Contract_Contingent_Worker")
    public ContractContingentWorkerResponseType contractContingentWorker(
        @WebParam(partName = "body", name = "Contract_Contingent_Worker_Request", targetNamespace = "urn:com.workday/bsvc")
        ContractContingentWorkerRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns headcount information along with the identification of the workers filling headcount positions.
     */
    @WebResult(name = "Get_Headcounts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Headcounts")
    public GetHeadcountsResponseType getHeadcounts(
        @WebParam(partName = "body", name = "Get_Headcounts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetHeadcountsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds a new pre-hire (or updates an existing pre-hire) with the information supplied in the request. Note: pre-hire was previously called applicant. However, the web service operation and its elements are not yet renamed, so that existing integrations continue to work.
     */
    @WebResult(name = "Put_Applicant_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Applicant")
    public PutApplicantResponseType putApplicant(
        @WebParam(partName = "body", name = "Put_Applicant_Request", targetNamespace = "urn:com.workday/bsvc")
        PutApplicantRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will create the hiring restrictions for a job management supervisory organization.
     */
    @WebResult(name = "Set_Hiring_Restrictions_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Set_Hiring_Restrictions")
    public SetHiringRestrictionsResponseType setHiringRestrictions(
        @WebParam(partName = "body", name = "Set_Hiring_Restrictions_Request", targetNamespace = "urn:com.workday/bsvc")
        SetHiringRestrictionsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates a worker document. The operation adds documents not associated with events and those documents are not secured by the events.
     */
    @WebResult(name = "Put_Worker_Document_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Worker_Document")
    public PutWorkerDocumentResponseType putWorkerDocument(
        @WebParam(partName = "body", name = "Put_Worker_Document_Request", targetNamespace = "urn:com.workday/bsvc")
        PutWorkerDocumentRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * DEPRECATED: Sets the academic tenure date for an employee. Replaced by Add/Update Academic Appointment.
     */
    @WebResult(name = "Maintain_Academic_Tenure_Date_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Maintain_Academic_Tenure_Date")
    public MaintainAcademicTenureDateResponseType maintainAcademicTenureDate(
        @WebParam(partName = "body", name = "Maintain_Academic_Tenure_Date_Request", targetNamespace = "urn:com.workday/bsvc")
        MaintainAcademicTenureDateRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Terminates an employee.
     */
    @WebResult(name = "Terminate_Employee_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Terminate_Employee")
    public TerminateEmployeeEventResponseType terminateEmployee(
        @WebParam(partName = "body", name = "Terminate_Employee_Request", targetNamespace = "urn:com.workday/bsvc")
        TerminateEmployeeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns job classification group data.
     */
    @WebResult(name = "Get_Job_Classification_Groups_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Job_Classification_Groups")
    public GetJobClassificationGroupsResponseType getJobClassificationGroups(
        @WebParam(partName = "body", name = "Get_Job_Classification_Groups_Request", targetNamespace = "urn:com.workday/bsvc")
        GetJobClassificationGroupsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Assigns organization roles to one or more workers.  Uses the Assign Organization Roles for Worker business process.
     */
    @WebResult(name = "Assign_Organization_Roles_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Assign_Organization_Roles")
    public AssignOrganizationRolesResponseType assignOrganizationRoles(
        @WebParam(partName = "body", name = "Assign_Organization_Roles_Request", targetNamespace = "urn:com.workday/bsvc")
        AssignOrganizationRolesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns information for pre-hires specified in the request. If the request does not specify a pre-hire, this operation returns information for all pre-hires. Note: pre-hire was previously called applicant. However, the web service operation and its elements are not yet renamed, so that existing integrations continue to work.
     */
    @WebResult(name = "Get_Applicants_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Applicants")
    public GetApplicantsResponseType getApplicants(
        @WebParam(partName = "body", name = "Get_Applicants_Request", targetNamespace = "urn:com.workday/bsvc")
        GetApplicantsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns job family and job family group data.
     */
    @WebResult(name = "Get_Job_Family_Groups_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Job_Family_Groups")
    public GetJobFamilyGroupsResponseType getJobFamilyGroups(
        @WebParam(partName = "body", name = "Get_Job_Family_Groups_Request", targetNamespace = "urn:com.workday/bsvc")
        GetJobFamilyGroupsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * DEPRECATED: 	Adds or updates a dependent
     */
    @WebResult(name = "Put_Dependent_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Dependent")
    public PutDependentResponseType putDependent(
        @WebParam(partName = "body", name = "Put_Dependent_Request", targetNamespace = "urn:com.workday/bsvc")
        PutDependentRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns organization information for a type of organization. If the request does not specify an organization, the operation returns information for all organizations.
     */
    @WebResult(name = "Get_Organizations_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Organizations")
    public GetOrganizationsResponseType getOrganizations(
        @WebParam(partName = "body", name = "Get_Organizations_Request", targetNamespace = "urn:com.workday/bsvc")
        GetOrganizationsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds or updates a job family group. Also adds or removes a group's associated job families.
     */
    @WebResult(name = "Put_Job_Family_Group_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Put_Job_Family_Group")
    public PutJobFamilyGroupResponseType putJobFamilyGroup(
        @WebParam(partName = "body", name = "Put_Job_Family_Group_Request", targetNamespace = "urn:com.workday/bsvc")
        PutJobFamilyGroupRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns worker document data.
     */
    @WebResult(name = "Get_Worker_Documents_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Worker_Documents")
    public GetWorkerDocumentsResponseType getWorkerDocuments(
        @WebParam(partName = "body", name = "Get_Worker_Documents_Request", targetNamespace = "urn:com.workday/bsvc")
        GetWorkerDocumentsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns job family data.
     */
    @WebResult(name = "Get_Job_Families_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Job_Families")
    public GetJobFamiliesResponseType getJobFamilies(
        @WebParam(partName = "body", name = "Get_Job_Families_Request", targetNamespace = "urn:com.workday/bsvc")
        GetJobFamiliesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Adds an additional job for an existing employee. Uses the Add Additional Job business process.
     */
    @WebResult(name = "Add_Additional_Job_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Add_Additional_Job")
    public AddAdditionalJobEventResponseType addAdditionalJob(
        @WebParam(partName = "body", name = "Add_Additional_Job_Request", targetNamespace = "urn:com.workday/bsvc")
        AddAdditionalJobRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Edits a filled position. Uses the Edit Position business process.
     */
    @WebResult(name = "Edit_Position_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Edit_Position")
    public EditPositionEventResponseType editPosition(
        @WebParam(partName = "body", name = "Edit_Position_Request", targetNamespace = "urn:com.workday/bsvc")
        EditPositionRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * DEPRECATED: This web service should not be used. Instead use the Get Workers web service. That is the supported public interface for employee data (including their contracts).
     */
    @WebResult(name = "Get_Maintain_Employee_Contracts_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Maintain_Employee_Contracts")
    public GetMaintainEmployeeContractsResponseType getMaintainEmployeeContracts(
        @WebParam(partName = "body", name = "Get_Maintain_Employee_Contracts_Request", targetNamespace = "urn:com.workday/bsvc")
        GetMaintainEmployeeContractsRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Creates/opens a position for a supervisory organization using the position management staffing model. Uses the Create Position business process. There are several sub-operations within this operation.
     * 
     * Existing positions cannot be re-loaded into the system. You must use the Edit Position Restrictions operation to change a created position.
     */
    @WebResult(name = "Create_Position_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Create_Position")
    public CreatePositionResponseType createPosition(
        @WebParam(partName = "body", name = "Create_Position_Request", targetNamespace = "urn:com.workday/bsvc")
        CreatePositionRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * This operation will invoke the business process to switch a workers primary job with one of their additional jobs. Uses the Switch Primary Job business process.
     */
    @WebResult(name = "Switch_Primary_Job_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Switch_Primary_Job")
    public SwitchPrimaryJobEventResponseType switchPrimaryJob(
        @WebParam(partName = "body", name = "Switch_Primary_Job_Request", targetNamespace = "urn:com.workday/bsvc")
        SwitchPrimaryJobRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Hires a pre-hire (new or existing) into an employee position, headcount, or job. Uses the Hire Employee business process. Note: pre-hire was previously called applicant. However, the web service operation and its elements are not yet renamed, so that existing integrations continue to work.
     */
    @WebResult(name = "Hire_Employee_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Hire_Employee")
    public HireEmployeeEventResponseType hireEmployee(
        @WebParam(partName = "body", name = "Hire_Employee_Request", targetNamespace = "urn:com.workday/bsvc")
        HireEmployeeRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Removes the retirement status from a retired employee. Uses the Remove Retiree Status business process.
     */
    @WebResult(name = "Remove_Retiree_Status_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Remove_Retiree_Status")
    public RemoveRetireeStatusResponseType removeRetireeStatus(
        @WebParam(partName = "body", name = "Remove_Retiree_Status_Request", targetNamespace = "urn:com.workday/bsvc")
        RemoveRetireeStatusRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Ends an employee's additional job. Uses the End Additional Job business process.
     */
    @WebResult(name = "End_Additional_Employee_Job_Event_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "End_Additional_Job")
    public EndAdditionalEmployeeJobEventResponseType endAdditionalJob(
        @WebParam(partName = "body", name = "End_Additional_Job_Request", targetNamespace = "urn:com.workday/bsvc")
        EndAdditionalJobRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;

    /**
     * Returns citizenship status details for the requested status. If the request does not specify a citizenship status, the operations returns details for all citizenship statuses.
     */
    @WebResult(name = "Get_Citizenship_Statuses_Response", targetNamespace = "urn:com.workday/bsvc", partName = "body")
    @WebMethod(operationName = "Get_Citizenship_Statuses")
    public GetCitizenshipStatusesResponseType getCitizenshipStatuses(
        @WebParam(partName = "body", name = "Get_Citizenship_Statuses_Request", targetNamespace = "urn:com.workday/bsvc")
        GetCitizenshipStatusesRequestType body
    ) throws ValidationFaultMsg, ProcessingFaultMsg;
}
