
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Enter COBRA information for a United States employee who is terminated or requesting a leave of absence.  Uses the Review COBRA Eligibility business process. The subprocess can be skipped, processed automatically or processed manually from the web service.
 * 
 * <p>Java class for Review_COBRA_Eligibility_Sub_Business_ProcessType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Review_COBRA_Eligibility_Sub_Business_ProcessType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Business_Sub_Process_Parameters" type="{urn:com.workday/bsvc}Business_Sub_Process_ParametersType" minOccurs="0"/>
 *         &lt;element name="Review_COBRA_Eligibility_Data" type="{urn:com.workday/bsvc}Review_COBRA_Eligibility_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Review_COBRA_Eligibility_Sub_Business_ProcessType", propOrder = {
    "businessSubProcessParameters",
    "reviewCOBRAEligibilityData"
})
public class ReviewCOBRAEligibilitySubBusinessProcessType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Business_Sub_Process_Parameters")
    protected BusinessSubProcessParametersType businessSubProcessParameters;
    @XmlElement(name = "Review_COBRA_Eligibility_Data")
    protected List<ReviewCOBRAEligibilityDataType> reviewCOBRAEligibilityData;

    /**
     * Gets the value of the businessSubProcessParameters property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public BusinessSubProcessParametersType getBusinessSubProcessParameters() {
        return businessSubProcessParameters;
    }

    /**
     * Sets the value of the businessSubProcessParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public void setBusinessSubProcessParameters(BusinessSubProcessParametersType value) {
        this.businessSubProcessParameters = value;
    }

    /**
     * Gets the value of the reviewCOBRAEligibilityData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the reviewCOBRAEligibilityData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReviewCOBRAEligibilityData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReviewCOBRAEligibilityDataType }
     * 
     * 
     */
    public List<ReviewCOBRAEligibilityDataType> getReviewCOBRAEligibilityData() {
        if (reviewCOBRAEligibilityData == null) {
            reviewCOBRAEligibilityData = new ArrayList<ReviewCOBRAEligibilityDataType>();
        }
        return this.reviewCOBRAEligibilityData;
    }

    /**
     * Sets the value of the reviewCOBRAEligibilityData property.
     * 
     * @param reviewCOBRAEligibilityData
     *     allowed object is
     *     {@link ReviewCOBRAEligibilityDataType }
     *     
     */
    public void setReviewCOBRAEligibilityData(List<ReviewCOBRAEligibilityDataType> reviewCOBRAEligibilityData) {
        this.reviewCOBRAEligibilityData = reviewCOBRAEligibilityData;
    }

}
