
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains COBRA Eligibility detail for a participant.  If this element is not populated then the participant is assumed to not be COBRA eligible.
 * 
 * <p>Java class for Review_COBRA_Eligibility_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Review_COBRA_Eligibility_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="COBRA_Eligible" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Reason_Reference" type="{urn:com.workday/bsvc}COBRA_Eligibility_ReasonObjectType" minOccurs="0"/>
 *         &lt;element name="COBRA_Eligible_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Qualifying_Event_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Coverage_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Participant_Reference" type="{urn:com.workday/bsvc}COBRA_ParticipantObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Benefit_Plan_Reference" type="{urn:com.workday/bsvc}Benefit_PlanObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Review_COBRA_Eligibility_DataType", propOrder = {
    "cobraEligible",
    "reasonReference",
    "cobraEligibleDate",
    "qualifyingEventDate",
    "coverageEndDate",
    "participantReference",
    "benefitPlanReference"
})
public class ReviewCOBRAEligibilityDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "COBRA_Eligible")
    protected Boolean cobraEligible;
    @XmlElement(name = "Reason_Reference")
    protected COBRAEligibilityReasonObjectType reasonReference;
    @XmlElement(name = "COBRA_Eligible_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar cobraEligibleDate;
    @XmlElement(name = "Qualifying_Event_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar qualifyingEventDate;
    @XmlElement(name = "Coverage_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar coverageEndDate;
    @XmlElement(name = "Participant_Reference")
    protected List<COBRAParticipantObjectType> participantReference;
    @XmlElement(name = "Benefit_Plan_Reference")
    protected BenefitPlanObjectType benefitPlanReference;

    /**
     * Gets the value of the cobraEligible property.
     * This getter has been renamed from isCOBRAEligible() to getCOBRAEligible() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCOBRAEligible() {
        return cobraEligible;
    }

    /**
     * Sets the value of the cobraEligible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCOBRAEligible(Boolean value) {
        this.cobraEligible = value;
    }

    /**
     * Gets the value of the reasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link COBRAEligibilityReasonObjectType }
     *     
     */
    public COBRAEligibilityReasonObjectType getReasonReference() {
        return reasonReference;
    }

    /**
     * Sets the value of the reasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link COBRAEligibilityReasonObjectType }
     *     
     */
    public void setReasonReference(COBRAEligibilityReasonObjectType value) {
        this.reasonReference = value;
    }

    /**
     * Gets the value of the cobraEligibleDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCOBRAEligibleDate() {
        return cobraEligibleDate;
    }

    /**
     * Sets the value of the cobraEligibleDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCOBRAEligibleDate(XMLGregorianCalendar value) {
        this.cobraEligibleDate = value;
    }

    /**
     * Gets the value of the qualifyingEventDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getQualifyingEventDate() {
        return qualifyingEventDate;
    }

    /**
     * Sets the value of the qualifyingEventDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setQualifyingEventDate(XMLGregorianCalendar value) {
        this.qualifyingEventDate = value;
    }

    /**
     * Gets the value of the coverageEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCoverageEndDate() {
        return coverageEndDate;
    }

    /**
     * Sets the value of the coverageEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCoverageEndDate(XMLGregorianCalendar value) {
        this.coverageEndDate = value;
    }

    /**
     * Gets the value of the participantReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the participantReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getParticipantReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link COBRAParticipantObjectType }
     * 
     * 
     */
    public List<COBRAParticipantObjectType> getParticipantReference() {
        if (participantReference == null) {
            participantReference = new ArrayList<COBRAParticipantObjectType>();
        }
        return this.participantReference;
    }

    /**
     * Gets the value of the benefitPlanReference property.
     * 
     * @return
     *     possible object is
     *     {@link BenefitPlanObjectType }
     *     
     */
    public BenefitPlanObjectType getBenefitPlanReference() {
        return benefitPlanReference;
    }

    /**
     * Sets the value of the benefitPlanReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link BenefitPlanObjectType }
     *     
     */
    public void setBenefitPlanReference(BenefitPlanObjectType value) {
        this.benefitPlanReference = value;
    }

    /**
     * Sets the value of the participantReference property.
     * 
     * @param participantReference
     *     allowed object is
     *     {@link COBRAParticipantObjectType }
     *     
     */
    public void setParticipantReference(List<COBRAParticipantObjectType> participantReference) {
        this.participantReference = participantReference;
    }

}
