
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Data element for the stock grant request
 * 
 * <p>Java class for Request_Stock_Grant_SubdataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Request_Stock_Grant_SubdataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Stock_Plan_Reference" type="{urn:com.workday/bsvc}Stock_PlanObjectType"/>
 *         &lt;element name="Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Individual_Stock_Grant_Data" type="{urn:com.workday/bsvc}Individual_Stock_Grant_DataType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Request_Stock_Grant_SubdataType", propOrder = {
    "stockPlanReference",
    "reasonReference",
    "individualStockGrantData"
})
public class RequestStockGrantSubdataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Stock_Plan_Reference", required = true)
    protected StockPlanObjectType stockPlanReference;
    @XmlElement(name = "Reason_Reference")
    protected EventClassificationSubcategoryObjectType reasonReference;
    @XmlElement(name = "Individual_Stock_Grant_Data", required = true)
    protected List<IndividualStockGrantDataType> individualStockGrantData;

    /**
     * Gets the value of the stockPlanReference property.
     * 
     * @return
     *     possible object is
     *     {@link StockPlanObjectType }
     *     
     */
    public StockPlanObjectType getStockPlanReference() {
        return stockPlanReference;
    }

    /**
     * Sets the value of the stockPlanReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StockPlanObjectType }
     *     
     */
    public void setStockPlanReference(StockPlanObjectType value) {
        this.stockPlanReference = value;
    }

    /**
     * Gets the value of the reasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getReasonReference() {
        return reasonReference;
    }

    /**
     * Sets the value of the reasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setReasonReference(EventClassificationSubcategoryObjectType value) {
        this.reasonReference = value;
    }

    /**
     * Gets the value of the individualStockGrantData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the individualStockGrantData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIndividualStockGrantData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IndividualStockGrantDataType }
     * 
     * 
     */
    public List<IndividualStockGrantDataType> getIndividualStockGrantData() {
        if (individualStockGrantData == null) {
            individualStockGrantData = new ArrayList<IndividualStockGrantDataType>();
        }
        return this.individualStockGrantData;
    }

    /**
     * Sets the value of the individualStockGrantData property.
     * 
     * @param individualStockGrantData
     *     allowed object is
     *     {@link IndividualStockGrantDataType }
     *     
     */
    public void setIndividualStockGrantData(List<IndividualStockGrantDataType> individualStockGrantData) {
        this.individualStockGrantData = individualStockGrantData;
    }

}
