
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Grant an employee a one-time payment such as a referral, spot bonus, or severance pay. Uses the Request One Time Payment business event through the web service.
 * Can be skipped, processed automatically or processed manually.
 * 
 * <p>Java class for Request_One_Time_Payment_Sub_Business_ProcessType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Request_One_Time_Payment_Sub_Business_ProcessType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Business_Sub_Process_Parameters" type="{urn:com.workday/bsvc}Business_Sub_Process_ParametersType" minOccurs="0"/>
 *         &lt;element name="Request_One_Time_Payment_Data" type="{urn:com.workday/bsvc}One-Time_Payment_DataType" minOccurs="0"/>
 *         &lt;element name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Request_One_Time_Payment_Sub_Business_ProcessType", propOrder = {
    "businessSubProcessParameters",
    "requestOneTimePaymentData",
    "effectiveDate"
})
public class RequestOneTimePaymentSubBusinessProcessType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Business_Sub_Process_Parameters")
    protected BusinessSubProcessParametersType businessSubProcessParameters;
    @XmlElement(name = "Request_One_Time_Payment_Data")
    protected OneTimePaymentDataType requestOneTimePaymentData;
    @XmlElement(name = "Effective_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;

    /**
     * Gets the value of the businessSubProcessParameters property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public BusinessSubProcessParametersType getBusinessSubProcessParameters() {
        return businessSubProcessParameters;
    }

    /**
     * Sets the value of the businessSubProcessParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public void setBusinessSubProcessParameters(BusinessSubProcessParametersType value) {
        this.businessSubProcessParameters = value;
    }

    /**
     * Gets the value of the requestOneTimePaymentData property.
     * 
     * @return
     *     possible object is
     *     {@link OneTimePaymentDataType }
     *     
     */
    public OneTimePaymentDataType getRequestOneTimePaymentData() {
        return requestOneTimePaymentData;
    }

    /**
     * Sets the value of the requestOneTimePaymentData property.
     * 
     * @param value
     *     allowed object is
     *     {@link OneTimePaymentDataType }
     *     
     */
    public void setRequestOneTimePaymentData(OneTimePaymentDataType value) {
        this.requestOneTimePaymentData = value;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

}
