
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for Recruiting Information.
 * 
 * <p>Java class for Recruiting_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Recruiting_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Applicant_Entered_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Applicant_Comments" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Ineligible_for_Hire" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Ineligible_for_Hire_Comments" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Applicant_Source_Reference" type="{urn:com.workday/bsvc}Applicant_SourceObjectType" minOccurs="0"/>
 *         &lt;element name="Referred_by_Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Positions_Considered_for_Reference" type="{urn:com.workday/bsvc}Position_GroupObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Recruiting_DataType", propOrder = {
    "applicantEnteredDate",
    "applicantComments",
    "ineligibleForHire",
    "ineligibleForHireComments",
    "applicantSourceReference",
    "referredByWorkerReference",
    "positionsConsideredForReference"
})
public class RecruitingDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Applicant_Entered_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar applicantEnteredDate;
    @XmlElement(name = "Applicant_Comments")
    protected String applicantComments;
    @XmlElement(name = "Ineligible_for_Hire")
    protected Boolean ineligibleForHire;
    @XmlElement(name = "Ineligible_for_Hire_Comments")
    protected String ineligibleForHireComments;
    @XmlElement(name = "Applicant_Source_Reference")
    protected ApplicantSourceObjectType applicantSourceReference;
    @XmlElement(name = "Referred_by_Worker_Reference")
    protected List<WorkerObjectType> referredByWorkerReference;
    @XmlElement(name = "Positions_Considered_for_Reference")
    protected List<PositionGroupObjectType> positionsConsideredForReference;

    /**
     * Gets the value of the applicantEnteredDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getApplicantEnteredDate() {
        return applicantEnteredDate;
    }

    /**
     * Sets the value of the applicantEnteredDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setApplicantEnteredDate(XMLGregorianCalendar value) {
        this.applicantEnteredDate = value;
    }

    /**
     * Gets the value of the applicantComments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getApplicantComments() {
        return applicantComments;
    }

    /**
     * Sets the value of the applicantComments property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setApplicantComments(String value) {
        this.applicantComments = value;
    }

    /**
     * Gets the value of the ineligibleForHire property.
     * This getter has been renamed from isIneligibleForHire() to getIneligibleForHire() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIneligibleForHire() {
        return ineligibleForHire;
    }

    /**
     * Sets the value of the ineligibleForHire property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIneligibleForHire(Boolean value) {
        this.ineligibleForHire = value;
    }

    /**
     * Gets the value of the ineligibleForHireComments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIneligibleForHireComments() {
        return ineligibleForHireComments;
    }

    /**
     * Sets the value of the ineligibleForHireComments property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIneligibleForHireComments(String value) {
        this.ineligibleForHireComments = value;
    }

    /**
     * Gets the value of the applicantSourceReference property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicantSourceObjectType }
     *     
     */
    public ApplicantSourceObjectType getApplicantSourceReference() {
        return applicantSourceReference;
    }

    /**
     * Sets the value of the applicantSourceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicantSourceObjectType }
     *     
     */
    public void setApplicantSourceReference(ApplicantSourceObjectType value) {
        this.applicantSourceReference = value;
    }

    /**
     * Gets the value of the referredByWorkerReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the referredByWorkerReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferredByWorkerReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerObjectType }
     * 
     * 
     */
    public List<WorkerObjectType> getReferredByWorkerReference() {
        if (referredByWorkerReference == null) {
            referredByWorkerReference = new ArrayList<WorkerObjectType>();
        }
        return this.referredByWorkerReference;
    }

    /**
     * Gets the value of the positionsConsideredForReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positionsConsideredForReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPositionsConsideredForReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PositionGroupObjectType }
     * 
     * 
     */
    public List<PositionGroupObjectType> getPositionsConsideredForReference() {
        if (positionsConsideredForReference == null) {
            positionsConsideredForReference = new ArrayList<PositionGroupObjectType>();
        }
        return this.positionsConsideredForReference;
    }

    /**
     * Sets the value of the referredByWorkerReference property.
     * 
     * @param referredByWorkerReference
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setReferredByWorkerReference(List<WorkerObjectType> referredByWorkerReference) {
        this.referredByWorkerReference = referredByWorkerReference;
    }

    /**
     * Sets the value of the positionsConsideredForReference property.
     * 
     * @param positionsConsideredForReference
     *     allowed object is
     *     {@link PositionGroupObjectType }
     *     
     */
    public void setPositionsConsideredForReference(List<PositionGroupObjectType> positionsConsideredForReference) {
        this.positionsConsideredForReference = positionsConsideredForReference;
    }

}
