
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * This element is used to group all data needed to create a purchase order if purchase orders are used.
 * 
 * <p>Java class for Purchase_Order_Contract_Details_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Purchase_Order_Contract_Details_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Company_for_Purchase_Order_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Requester_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *         &lt;element name="Spend_Category_Reference" type="{urn:com.workday/bsvc}Spend_CategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Contract_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Worktags_Reference" type="{urn:com.workday/bsvc}Audited_Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Purchase_Order_Contract_Details_DataType", propOrder = {
    "companyForPurchaseOrderReference",
    "requesterReference",
    "spendCategoryReference",
    "contractAmount",
    "worktagsReference"
})
public class PurchaseOrderContractDetailsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Company_for_Purchase_Order_Reference")
    protected CompanyObjectType companyForPurchaseOrderReference;
    @XmlElement(name = "Requester_Reference")
    protected WorkerObjectType requesterReference;
    @XmlElement(name = "Spend_Category_Reference")
    protected SpendCategoryObjectType spendCategoryReference;
    @XmlElement(name = "Contract_Amount")
    protected BigDecimal contractAmount;
    @XmlElement(name = "Worktags_Reference")
    protected List<AuditedAccountingWorktagObjectType> worktagsReference;

    /**
     * Gets the value of the companyForPurchaseOrderReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyForPurchaseOrderReference() {
        return companyForPurchaseOrderReference;
    }

    /**
     * Sets the value of the companyForPurchaseOrderReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyForPurchaseOrderReference(CompanyObjectType value) {
        this.companyForPurchaseOrderReference = value;
    }

    /**
     * Gets the value of the requesterReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getRequesterReference() {
        return requesterReference;
    }

    /**
     * Sets the value of the requesterReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setRequesterReference(WorkerObjectType value) {
        this.requesterReference = value;
    }

    /**
     * Gets the value of the spendCategoryReference property.
     * 
     * @return
     *     possible object is
     *     {@link SpendCategoryObjectType }
     *     
     */
    public SpendCategoryObjectType getSpendCategoryReference() {
        return spendCategoryReference;
    }

    /**
     * Sets the value of the spendCategoryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpendCategoryObjectType }
     *     
     */
    public void setSpendCategoryReference(SpendCategoryObjectType value) {
        this.spendCategoryReference = value;
    }

    /**
     * Gets the value of the contractAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    /**
     * Sets the value of the contractAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setContractAmount(BigDecimal value) {
        this.contractAmount = value;
    }

    /**
     * Gets the value of the worktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuditedAccountingWorktagObjectType }
     * 
     * 
     */
    public List<AuditedAccountingWorktagObjectType> getWorktagsReference() {
        if (worktagsReference == null) {
            worktagsReference = new ArrayList<AuditedAccountingWorktagObjectType>();
        }
        return this.worktagsReference;
    }

    /**
     * Sets the value of the worktagsReference property.
     * 
     * @param worktagsReference
     *     allowed object is
     *     {@link AuditedAccountingWorktagObjectType }
     *     
     */
    public void setWorktagsReference(List<AuditedAccountingWorktagObjectType> worktagsReference) {
        this.worktagsReference = worktagsReference;
    }

}
