
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The response group allows for the response data to be tailored to only included elements that the user is looking for.  If no response group is provided in the request the only the following elements will be returned:  Reference and Position Definition Data
 * 
 * <p>Java class for Position_Response_GroupType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Response_GroupType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Include_Reference" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Position_Definition_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Position_Restrictions_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Default_Compensation_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Default_Position_Organization_Assignment_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Worker_For_Filled_Positions_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Qualifications" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Job_Requisition_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Job_Requisition_Attachments" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Response_GroupType", propOrder = {
    "includeReference",
    "includePositionDefinitionData",
    "includePositionRestrictionsData",
    "includeDefaultCompensationData",
    "includeDefaultPositionOrganizationAssignmentData",
    "includeWorkerForFilledPositionsData",
    "includeQualifications",
    "includeJobRequisitionData",
    "includeJobRequisitionAttachments"
})
public class PositionResponseGroupType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Include_Reference")
    protected Boolean includeReference;
    @XmlElement(name = "Include_Position_Definition_Data")
    protected Boolean includePositionDefinitionData;
    @XmlElement(name = "Include_Position_Restrictions_Data")
    protected Boolean includePositionRestrictionsData;
    @XmlElement(name = "Include_Default_Compensation_Data")
    protected Boolean includeDefaultCompensationData;
    @XmlElement(name = "Include_Default_Position_Organization_Assignment_Data")
    protected Boolean includeDefaultPositionOrganizationAssignmentData;
    @XmlElement(name = "Include_Worker_For_Filled_Positions_Data")
    protected Boolean includeWorkerForFilledPositionsData;
    @XmlElement(name = "Include_Qualifications")
    protected Boolean includeQualifications;
    @XmlElement(name = "Include_Job_Requisition_Data")
    protected Boolean includeJobRequisitionData;
    @XmlElement(name = "Include_Job_Requisition_Attachments")
    protected Boolean includeJobRequisitionAttachments;

    /**
     * Gets the value of the includeReference property.
     * This getter has been renamed from isIncludeReference() to getIncludeReference() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeReference() {
        return includeReference;
    }

    /**
     * Sets the value of the includeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeReference(Boolean value) {
        this.includeReference = value;
    }

    /**
     * Gets the value of the includePositionDefinitionData property.
     * This getter has been renamed from isIncludePositionDefinitionData() to getIncludePositionDefinitionData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludePositionDefinitionData() {
        return includePositionDefinitionData;
    }

    /**
     * Sets the value of the includePositionDefinitionData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludePositionDefinitionData(Boolean value) {
        this.includePositionDefinitionData = value;
    }

    /**
     * Gets the value of the includePositionRestrictionsData property.
     * This getter has been renamed from isIncludePositionRestrictionsData() to getIncludePositionRestrictionsData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludePositionRestrictionsData() {
        return includePositionRestrictionsData;
    }

    /**
     * Sets the value of the includePositionRestrictionsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludePositionRestrictionsData(Boolean value) {
        this.includePositionRestrictionsData = value;
    }

    /**
     * Gets the value of the includeDefaultCompensationData property.
     * This getter has been renamed from isIncludeDefaultCompensationData() to getIncludeDefaultCompensationData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeDefaultCompensationData() {
        return includeDefaultCompensationData;
    }

    /**
     * Sets the value of the includeDefaultCompensationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDefaultCompensationData(Boolean value) {
        this.includeDefaultCompensationData = value;
    }

    /**
     * Gets the value of the includeDefaultPositionOrganizationAssignmentData property.
     * This getter has been renamed from isIncludeDefaultPositionOrganizationAssignmentData() to getIncludeDefaultPositionOrganizationAssignmentData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeDefaultPositionOrganizationAssignmentData() {
        return includeDefaultPositionOrganizationAssignmentData;
    }

    /**
     * Sets the value of the includeDefaultPositionOrganizationAssignmentData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDefaultPositionOrganizationAssignmentData(Boolean value) {
        this.includeDefaultPositionOrganizationAssignmentData = value;
    }

    /**
     * Gets the value of the includeWorkerForFilledPositionsData property.
     * This getter has been renamed from isIncludeWorkerForFilledPositionsData() to getIncludeWorkerForFilledPositionsData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeWorkerForFilledPositionsData() {
        return includeWorkerForFilledPositionsData;
    }

    /**
     * Sets the value of the includeWorkerForFilledPositionsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeWorkerForFilledPositionsData(Boolean value) {
        this.includeWorkerForFilledPositionsData = value;
    }

    /**
     * Gets the value of the includeQualifications property.
     * This getter has been renamed from isIncludeQualifications() to getIncludeQualifications() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeQualifications() {
        return includeQualifications;
    }

    /**
     * Sets the value of the includeQualifications property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeQualifications(Boolean value) {
        this.includeQualifications = value;
    }

    /**
     * Gets the value of the includeJobRequisitionData property.
     * This getter has been renamed from isIncludeJobRequisitionData() to getIncludeJobRequisitionData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeJobRequisitionData() {
        return includeJobRequisitionData;
    }

    /**
     * Sets the value of the includeJobRequisitionData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeJobRequisitionData(Boolean value) {
        this.includeJobRequisitionData = value;
    }

    /**
     * Gets the value of the includeJobRequisitionAttachments property.
     * This getter has been renamed from isIncludeJobRequisitionAttachments() to getIncludeJobRequisitionAttachments() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeJobRequisitionAttachments() {
        return includeJobRequisitionAttachments;
    }

    /**
     * Sets the value of the includeJobRequisitionAttachments property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeJobRequisitionAttachments(Boolean value) {
        this.includeJobRequisitionAttachments = value;
    }

}
