
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Utilize the Request Criteria element to search the transaction log for specific instance(s) of a Position.
 * 
 * <p>Java class for Position_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Transaction_Log_Criteria_Data" type="{urn:com.workday/bsvc}Transaction_Log_CriteriaType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Supervisory_Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Exclude_Filled_Positions" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Exclude_Non-Recruitable_Positions" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Event_Reference" type="{urn:com.workday/bsvc}EventObjectType" minOccurs="0"/>
 *         &lt;element name="Field_And_Parameter_Criteria_Data" type="{urn:com.workday/bsvc}Field_And_Parameter_Criteria_DataType" minOccurs="0"/>
 *         &lt;element name="Location_Reference" type="{urn:com.workday/bsvc}LocationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Additional_Locations_Reference" type="{urn:com.workday/bsvc}LocationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Request_CriteriaType", propOrder = {
    "transactionLogCriteriaData",
    "supervisoryOrganizationReference",
    "jobRequisitionReference",
    "excludeFilledPositions",
    "excludeNonRecruitablePositions",
    "eventReference",
    "fieldAndParameterCriteriaData",
    "locationReference",
    "additionalLocationsReference"
})
public class PositionRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Transaction_Log_Criteria_Data")
    protected List<TransactionLogCriteriaType> transactionLogCriteriaData;
    @XmlElement(name = "Supervisory_Organization_Reference")
    protected List<SupervisoryOrganizationObjectType> supervisoryOrganizationReference;
    @XmlElement(name = "Job_Requisition_Reference")
    protected List<JobRequisitionObjectType> jobRequisitionReference;
    @XmlElement(name = "Exclude_Filled_Positions")
    protected Boolean excludeFilledPositions;
    @XmlElement(name = "Exclude_Non-Recruitable_Positions")
    protected Boolean excludeNonRecruitablePositions;
    @XmlElement(name = "Event_Reference")
    protected EventObjectType eventReference;
    @XmlElement(name = "Field_And_Parameter_Criteria_Data")
    protected FieldAndParameterCriteriaDataType fieldAndParameterCriteriaData;
    @XmlElement(name = "Location_Reference")
    protected List<LocationObjectType> locationReference;
    @XmlElement(name = "Additional_Locations_Reference")
    protected List<LocationObjectType> additionalLocationsReference;

    /**
     * Gets the value of the transactionLogCriteriaData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transactionLogCriteriaData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTransactionLogCriteriaData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransactionLogCriteriaType }
     * 
     * 
     */
    public List<TransactionLogCriteriaType> getTransactionLogCriteriaData() {
        if (transactionLogCriteriaData == null) {
            transactionLogCriteriaData = new ArrayList<TransactionLogCriteriaType>();
        }
        return this.transactionLogCriteriaData;
    }

    /**
     * Gets the value of the supervisoryOrganizationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supervisoryOrganizationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupervisoryOrganizationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupervisoryOrganizationObjectType }
     * 
     * 
     */
    public List<SupervisoryOrganizationObjectType> getSupervisoryOrganizationReference() {
        if (supervisoryOrganizationReference == null) {
            supervisoryOrganizationReference = new ArrayList<SupervisoryOrganizationObjectType>();
        }
        return this.supervisoryOrganizationReference;
    }

    /**
     * Gets the value of the jobRequisitionReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the jobRequisitionReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJobRequisitionReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JobRequisitionObjectType }
     * 
     * 
     */
    public List<JobRequisitionObjectType> getJobRequisitionReference() {
        if (jobRequisitionReference == null) {
            jobRequisitionReference = new ArrayList<JobRequisitionObjectType>();
        }
        return this.jobRequisitionReference;
    }

    /**
     * Gets the value of the excludeFilledPositions property.
     * This getter has been renamed from isExcludeFilledPositions() to getExcludeFilledPositions() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFilledPositions() {
        return excludeFilledPositions;
    }

    /**
     * Sets the value of the excludeFilledPositions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFilledPositions(Boolean value) {
        this.excludeFilledPositions = value;
    }

    /**
     * Gets the value of the excludeNonRecruitablePositions property.
     * This getter has been renamed from isExcludeNonRecruitablePositions() to getExcludeNonRecruitablePositions() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeNonRecruitablePositions() {
        return excludeNonRecruitablePositions;
    }

    /**
     * Sets the value of the excludeNonRecruitablePositions property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeNonRecruitablePositions(Boolean value) {
        this.excludeNonRecruitablePositions = value;
    }

    /**
     * Gets the value of the eventReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventObjectType }
     *     
     */
    public EventObjectType getEventReference() {
        return eventReference;
    }

    /**
     * Sets the value of the eventReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventObjectType }
     *     
     */
    public void setEventReference(EventObjectType value) {
        this.eventReference = value;
    }

    /**
     * Gets the value of the fieldAndParameterCriteriaData property.
     * 
     * @return
     *     possible object is
     *     {@link FieldAndParameterCriteriaDataType }
     *     
     */
    public FieldAndParameterCriteriaDataType getFieldAndParameterCriteriaData() {
        return fieldAndParameterCriteriaData;
    }

    /**
     * Sets the value of the fieldAndParameterCriteriaData property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldAndParameterCriteriaDataType }
     *     
     */
    public void setFieldAndParameterCriteriaData(FieldAndParameterCriteriaDataType value) {
        this.fieldAndParameterCriteriaData = value;
    }

    /**
     * Gets the value of the locationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the locationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLocationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationObjectType }
     * 
     * 
     */
    public List<LocationObjectType> getLocationReference() {
        if (locationReference == null) {
            locationReference = new ArrayList<LocationObjectType>();
        }
        return this.locationReference;
    }

    /**
     * Gets the value of the additionalLocationsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalLocationsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalLocationsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationObjectType }
     * 
     * 
     */
    public List<LocationObjectType> getAdditionalLocationsReference() {
        if (additionalLocationsReference == null) {
            additionalLocationsReference = new ArrayList<LocationObjectType>();
        }
        return this.additionalLocationsReference;
    }

    /**
     * Sets the value of the transactionLogCriteriaData property.
     * 
     * @param transactionLogCriteriaData
     *     allowed object is
     *     {@link TransactionLogCriteriaType }
     *     
     */
    public void setTransactionLogCriteriaData(List<TransactionLogCriteriaType> transactionLogCriteriaData) {
        this.transactionLogCriteriaData = transactionLogCriteriaData;
    }

    /**
     * Sets the value of the supervisoryOrganizationReference property.
     * 
     * @param supervisoryOrganizationReference
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setSupervisoryOrganizationReference(List<SupervisoryOrganizationObjectType> supervisoryOrganizationReference) {
        this.supervisoryOrganizationReference = supervisoryOrganizationReference;
    }

    /**
     * Sets the value of the jobRequisitionReference property.
     * 
     * @param jobRequisitionReference
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setJobRequisitionReference(List<JobRequisitionObjectType> jobRequisitionReference) {
        this.jobRequisitionReference = jobRequisitionReference;
    }

    /**
     * Sets the value of the locationReference property.
     * 
     * @param locationReference
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setLocationReference(List<LocationObjectType> locationReference) {
        this.locationReference = locationReference;
    }

    /**
     * Sets the value of the additionalLocationsReference property.
     * 
     * @param additionalLocationsReference
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setAdditionalLocationsReference(List<LocationObjectType> additionalLocationsReference) {
        this.additionalLocationsReference = additionalLocationsReference;
    }

}
