
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper element for filled position data.
 * 
 * <p>Java class for Position_Details_Sub_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Details_Sub_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Job_Profile_Reference" type="{urn:com.workday/bsvc}Job_ProfileObjectType" minOccurs="0"/>
 *         &lt;element name="Position_Title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Business_Title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Location_Reference" type="{urn:com.workday/bsvc}LocationObjectType" minOccurs="0"/>
 *         &lt;element name="Work_Space_Reference" type="{urn:com.workday/bsvc}LocationObjectType" minOccurs="0"/>
 *         &lt;element name="Position_Time_Type_Reference" type="{urn:com.workday/bsvc}Position_Time_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Work_Shift_Reference" type="{urn:com.workday/bsvc}Work_ShiftObjectType" minOccurs="0"/>
 *         &lt;element name="Work_Hours_Profile_Reference" type="{urn:com.workday/bsvc}Work_Hours_ProfileObjectType" minOccurs="0"/>
 *         &lt;element name="Default_Hours" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="5"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Scheduled_Hours" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="5"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Pay_Rate_Type_Reference" type="{urn:com.workday/bsvc}Pay_Rate_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Job_Classification_Reference" type="{urn:com.workday/bsvc}Job_ClassificationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Company_Insider_Type_Reference" type="{urn:com.workday/bsvc}Company_Insider_TypeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Annual_Work_Period_Reference" type="{urn:com.workday/bsvc}Academic_Pay_PeriodObjectType" minOccurs="0"/>
 *         &lt;element name="Disbursement_Plan_Period_Reference" type="{urn:com.workday/bsvc}Academic_Pay_PeriodObjectType" minOccurs="0"/>
 *         &lt;element name="Workers__Compensation_Code_Override_Reference" type="{urn:com.workday/bsvc}Workers_Compensation_CodeObjectType" minOccurs="0"/>
 *         &lt;element name="Position_External_ID_Data" type="{urn:com.workday/bsvc}External_ID_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Details_Sub_DataType", propOrder = {
    "jobProfileReference",
    "positionTitle",
    "businessTitle",
    "locationReference",
    "workSpaceReference",
    "positionTimeTypeReference",
    "workShiftReference",
    "workHoursProfileReference",
    "defaultHours",
    "scheduledHours",
    "payRateTypeReference",
    "jobClassificationReference",
    "companyInsiderTypeReference",
    "annualWorkPeriodReference",
    "disbursementPlanPeriodReference",
    "workersCompensationCodeOverrideReference",
    "positionExternalIDData"
})
public class PositionDetailsSubDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Job_Profile_Reference")
    protected JobProfileObjectType jobProfileReference;
    @XmlElement(name = "Position_Title")
    protected String positionTitle;
    @XmlElement(name = "Business_Title")
    protected String businessTitle;
    @XmlElement(name = "Location_Reference")
    protected LocationObjectType locationReference;
    @XmlElement(name = "Work_Space_Reference")
    protected LocationObjectType workSpaceReference;
    @XmlElement(name = "Position_Time_Type_Reference")
    protected PositionTimeTypeObjectType positionTimeTypeReference;
    @XmlElement(name = "Work_Shift_Reference")
    protected WorkShiftObjectType workShiftReference;
    @XmlElement(name = "Work_Hours_Profile_Reference")
    protected WorkHoursProfileObjectType workHoursProfileReference;
    @XmlElement(name = "Default_Hours")
    protected BigDecimal defaultHours;
    @XmlElement(name = "Scheduled_Hours")
    protected BigDecimal scheduledHours;
    @XmlElement(name = "Pay_Rate_Type_Reference")
    protected PayRateTypeObjectType payRateTypeReference;
    @XmlElement(name = "Job_Classification_Reference")
    protected List<JobClassificationObjectType> jobClassificationReference;
    @XmlElement(name = "Company_Insider_Type_Reference")
    protected List<CompanyInsiderTypeObjectType> companyInsiderTypeReference;
    @XmlElement(name = "Annual_Work_Period_Reference")
    protected AcademicPayPeriodObjectType annualWorkPeriodReference;
    @XmlElement(name = "Disbursement_Plan_Period_Reference")
    protected AcademicPayPeriodObjectType disbursementPlanPeriodReference;
    @XmlElement(name = "Workers__Compensation_Code_Override_Reference")
    protected WorkersCompensationCodeObjectType workersCompensationCodeOverrideReference;
    @XmlElement(name = "Position_External_ID_Data")
    protected ExternalIDDataType positionExternalIDData;

    /**
     * Gets the value of the jobProfileReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobProfileObjectType }
     *     
     */
    public JobProfileObjectType getJobProfileReference() {
        return jobProfileReference;
    }

    /**
     * Sets the value of the jobProfileReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobProfileObjectType }
     *     
     */
    public void setJobProfileReference(JobProfileObjectType value) {
        this.jobProfileReference = value;
    }

    /**
     * Gets the value of the positionTitle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionTitle() {
        return positionTitle;
    }

    /**
     * Sets the value of the positionTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionTitle(String value) {
        this.positionTitle = value;
    }

    /**
     * Gets the value of the businessTitle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessTitle() {
        return businessTitle;
    }

    /**
     * Sets the value of the businessTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessTitle(String value) {
        this.businessTitle = value;
    }

    /**
     * Gets the value of the locationReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocationObjectType }
     *     
     */
    public LocationObjectType getLocationReference() {
        return locationReference;
    }

    /**
     * Sets the value of the locationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setLocationReference(LocationObjectType value) {
        this.locationReference = value;
    }

    /**
     * Gets the value of the workSpaceReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocationObjectType }
     *     
     */
    public LocationObjectType getWorkSpaceReference() {
        return workSpaceReference;
    }

    /**
     * Sets the value of the workSpaceReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setWorkSpaceReference(LocationObjectType value) {
        this.workSpaceReference = value;
    }

    /**
     * Gets the value of the positionTimeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionTimeTypeObjectType }
     *     
     */
    public PositionTimeTypeObjectType getPositionTimeTypeReference() {
        return positionTimeTypeReference;
    }

    /**
     * Sets the value of the positionTimeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionTimeTypeObjectType }
     *     
     */
    public void setPositionTimeTypeReference(PositionTimeTypeObjectType value) {
        this.positionTimeTypeReference = value;
    }

    /**
     * Gets the value of the workShiftReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkShiftObjectType }
     *     
     */
    public WorkShiftObjectType getWorkShiftReference() {
        return workShiftReference;
    }

    /**
     * Sets the value of the workShiftReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkShiftObjectType }
     *     
     */
    public void setWorkShiftReference(WorkShiftObjectType value) {
        this.workShiftReference = value;
    }

    /**
     * Gets the value of the workHoursProfileReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkHoursProfileObjectType }
     *     
     */
    public WorkHoursProfileObjectType getWorkHoursProfileReference() {
        return workHoursProfileReference;
    }

    /**
     * Sets the value of the workHoursProfileReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkHoursProfileObjectType }
     *     
     */
    public void setWorkHoursProfileReference(WorkHoursProfileObjectType value) {
        this.workHoursProfileReference = value;
    }

    /**
     * Gets the value of the defaultHours property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getDefaultHours() {
        return defaultHours;
    }

    /**
     * Sets the value of the defaultHours property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setDefaultHours(BigDecimal value) {
        this.defaultHours = value;
    }

    /**
     * Gets the value of the scheduledHours property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getScheduledHours() {
        return scheduledHours;
    }

    /**
     * Sets the value of the scheduledHours property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setScheduledHours(BigDecimal value) {
        this.scheduledHours = value;
    }

    /**
     * Gets the value of the payRateTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayRateTypeObjectType }
     *     
     */
    public PayRateTypeObjectType getPayRateTypeReference() {
        return payRateTypeReference;
    }

    /**
     * Sets the value of the payRateTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayRateTypeObjectType }
     *     
     */
    public void setPayRateTypeReference(PayRateTypeObjectType value) {
        this.payRateTypeReference = value;
    }

    /**
     * Gets the value of the jobClassificationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the jobClassificationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJobClassificationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JobClassificationObjectType }
     * 
     * 
     */
    public List<JobClassificationObjectType> getJobClassificationReference() {
        if (jobClassificationReference == null) {
            jobClassificationReference = new ArrayList<JobClassificationObjectType>();
        }
        return this.jobClassificationReference;
    }

    /**
     * Gets the value of the companyInsiderTypeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the companyInsiderTypeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCompanyInsiderTypeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompanyInsiderTypeObjectType }
     * 
     * 
     */
    public List<CompanyInsiderTypeObjectType> getCompanyInsiderTypeReference() {
        if (companyInsiderTypeReference == null) {
            companyInsiderTypeReference = new ArrayList<CompanyInsiderTypeObjectType>();
        }
        return this.companyInsiderTypeReference;
    }

    /**
     * Gets the value of the annualWorkPeriodReference property.
     * 
     * @return
     *     possible object is
     *     {@link AcademicPayPeriodObjectType }
     *     
     */
    public AcademicPayPeriodObjectType getAnnualWorkPeriodReference() {
        return annualWorkPeriodReference;
    }

    /**
     * Sets the value of the annualWorkPeriodReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AcademicPayPeriodObjectType }
     *     
     */
    public void setAnnualWorkPeriodReference(AcademicPayPeriodObjectType value) {
        this.annualWorkPeriodReference = value;
    }

    /**
     * Gets the value of the disbursementPlanPeriodReference property.
     * 
     * @return
     *     possible object is
     *     {@link AcademicPayPeriodObjectType }
     *     
     */
    public AcademicPayPeriodObjectType getDisbursementPlanPeriodReference() {
        return disbursementPlanPeriodReference;
    }

    /**
     * Sets the value of the disbursementPlanPeriodReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AcademicPayPeriodObjectType }
     *     
     */
    public void setDisbursementPlanPeriodReference(AcademicPayPeriodObjectType value) {
        this.disbursementPlanPeriodReference = value;
    }

    /**
     * Gets the value of the workersCompensationCodeOverrideReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkersCompensationCodeObjectType }
     *     
     */
    public WorkersCompensationCodeObjectType getWorkersCompensationCodeOverrideReference() {
        return workersCompensationCodeOverrideReference;
    }

    /**
     * Sets the value of the workersCompensationCodeOverrideReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkersCompensationCodeObjectType }
     *     
     */
    public void setWorkersCompensationCodeOverrideReference(WorkersCompensationCodeObjectType value) {
        this.workersCompensationCodeOverrideReference = value;
    }

    /**
     * Gets the value of the positionExternalIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIDDataType }
     *     
     */
    public ExternalIDDataType getPositionExternalIDData() {
        return positionExternalIDData;
    }

    /**
     * Sets the value of the positionExternalIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIDDataType }
     *     
     */
    public void setPositionExternalIDData(ExternalIDDataType value) {
        this.positionExternalIDData = value;
    }

    /**
     * Sets the value of the jobClassificationReference property.
     * 
     * @param jobClassificationReference
     *     allowed object is
     *     {@link JobClassificationObjectType }
     *     
     */
    public void setJobClassificationReference(List<JobClassificationObjectType> jobClassificationReference) {
        this.jobClassificationReference = jobClassificationReference;
    }

    /**
     * Sets the value of the companyInsiderTypeReference property.
     * 
     * @param companyInsiderTypeReference
     *     allowed object is
     *     {@link CompanyInsiderTypeObjectType }
     *     
     */
    public void setCompanyInsiderTypeReference(List<CompanyInsiderTypeObjectType> companyInsiderTypeReference) {
        this.companyInsiderTypeReference = companyInsiderTypeReference;
    }

}
