
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for general data pertaining to a position opening.
 * 
 * <p>Java class for Position_Details_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_Details_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Job_Posting_Title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Academic_Tenure_Eligible" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Job_Description_Summary" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Job_Description" type="{urn:com.workday/bsvc}RichText" minOccurs="0"/>
 *         &lt;element name="Position_Status_Reference" type="{urn:com.workday/bsvc}Worker_EventObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Available_For_Hire" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Available_for_Recruiting" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Hiring_Freeze" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Work_Shift_Required" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Available_for_Overlap" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Earliest_Overlap_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Critical_Job" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Difficulty_to_Fill_Reference" type="{urn:com.workday/bsvc}Difficulty_to_FillObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_Details_DataType", propOrder = {
    "positionID",
    "jobPostingTitle",
    "academicTenureEligible",
    "jobDescriptionSummary",
    "jobDescription",
    "positionStatusReference",
    "availableForHire",
    "availableForRecruiting",
    "hiringFreeze",
    "workShiftRequired",
    "availableForOverlap",
    "earliestOverlapDate",
    "criticalJob",
    "difficultyToFillReference"
})
public class PositionDetailsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_ID")
    protected String positionID;
    @XmlElement(name = "Job_Posting_Title")
    protected String jobPostingTitle;
    @XmlElement(name = "Academic_Tenure_Eligible")
    protected Boolean academicTenureEligible;
    @XmlElement(name = "Job_Description_Summary")
    protected String jobDescriptionSummary;
    @XmlElement(name = "Job_Description")
    protected String jobDescription;
    @XmlElement(name = "Position_Status_Reference")
    protected List<WorkerEventObjectType> positionStatusReference;
    @XmlElement(name = "Available_For_Hire")
    protected Boolean availableForHire;
    @XmlElement(name = "Available_for_Recruiting")
    protected Boolean availableForRecruiting;
    @XmlElement(name = "Hiring_Freeze")
    protected Boolean hiringFreeze;
    @XmlElement(name = "Work_Shift_Required")
    protected Boolean workShiftRequired;
    @XmlElement(name = "Available_for_Overlap")
    protected Boolean availableForOverlap;
    @XmlElement(name = "Earliest_Overlap_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar earliestOverlapDate;
    @XmlElement(name = "Critical_Job")
    protected Boolean criticalJob;
    @XmlElement(name = "Difficulty_to_Fill_Reference")
    protected DifficultyToFillObjectType difficultyToFillReference;

    /**
     * Gets the value of the positionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionID() {
        return positionID;
    }

    /**
     * Sets the value of the positionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionID(String value) {
        this.positionID = value;
    }

    /**
     * Gets the value of the jobPostingTitle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobPostingTitle() {
        return jobPostingTitle;
    }

    /**
     * Sets the value of the jobPostingTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobPostingTitle(String value) {
        this.jobPostingTitle = value;
    }

    /**
     * Gets the value of the academicTenureEligible property.
     * This getter has been renamed from isAcademicTenureEligible() to getAcademicTenureEligible() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAcademicTenureEligible() {
        return academicTenureEligible;
    }

    /**
     * Sets the value of the academicTenureEligible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAcademicTenureEligible(Boolean value) {
        this.academicTenureEligible = value;
    }

    /**
     * Gets the value of the jobDescriptionSummary property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobDescriptionSummary() {
        return jobDescriptionSummary;
    }

    /**
     * Sets the value of the jobDescriptionSummary property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobDescriptionSummary(String value) {
        this.jobDescriptionSummary = value;
    }

    /**
     * Gets the value of the jobDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobDescription() {
        return jobDescription;
    }

    /**
     * Sets the value of the jobDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobDescription(String value) {
        this.jobDescription = value;
    }

    /**
     * Gets the value of the positionStatusReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positionStatusReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPositionStatusReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerEventObjectType }
     * 
     * 
     */
    public List<WorkerEventObjectType> getPositionStatusReference() {
        if (positionStatusReference == null) {
            positionStatusReference = new ArrayList<WorkerEventObjectType>();
        }
        return this.positionStatusReference;
    }

    /**
     * Gets the value of the availableForHire property.
     * This getter has been renamed from isAvailableForHire() to getAvailableForHire() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAvailableForHire() {
        return availableForHire;
    }

    /**
     * Sets the value of the availableForHire property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAvailableForHire(Boolean value) {
        this.availableForHire = value;
    }

    /**
     * Gets the value of the availableForRecruiting property.
     * This getter has been renamed from isAvailableForRecruiting() to getAvailableForRecruiting() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAvailableForRecruiting() {
        return availableForRecruiting;
    }

    /**
     * Sets the value of the availableForRecruiting property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAvailableForRecruiting(Boolean value) {
        this.availableForRecruiting = value;
    }

    /**
     * Gets the value of the hiringFreeze property.
     * This getter has been renamed from isHiringFreeze() to getHiringFreeze() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getHiringFreeze() {
        return hiringFreeze;
    }

    /**
     * Sets the value of the hiringFreeze property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHiringFreeze(Boolean value) {
        this.hiringFreeze = value;
    }

    /**
     * Gets the value of the workShiftRequired property.
     * This getter has been renamed from isWorkShiftRequired() to getWorkShiftRequired() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getWorkShiftRequired() {
        return workShiftRequired;
    }

    /**
     * Sets the value of the workShiftRequired property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setWorkShiftRequired(Boolean value) {
        this.workShiftRequired = value;
    }

    /**
     * Gets the value of the availableForOverlap property.
     * This getter has been renamed from isAvailableForOverlap() to getAvailableForOverlap() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAvailableForOverlap() {
        return availableForOverlap;
    }

    /**
     * Sets the value of the availableForOverlap property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAvailableForOverlap(Boolean value) {
        this.availableForOverlap = value;
    }

    /**
     * Gets the value of the earliestOverlapDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEarliestOverlapDate() {
        return earliestOverlapDate;
    }

    /**
     * Sets the value of the earliestOverlapDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEarliestOverlapDate(XMLGregorianCalendar value) {
        this.earliestOverlapDate = value;
    }

    /**
     * Gets the value of the criticalJob property.
     * This getter has been renamed from isCriticalJob() to getCriticalJob() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCriticalJob() {
        return criticalJob;
    }

    /**
     * Sets the value of the criticalJob property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCriticalJob(Boolean value) {
        this.criticalJob = value;
    }

    /**
     * Gets the value of the difficultyToFillReference property.
     * 
     * @return
     *     possible object is
     *     {@link DifficultyToFillObjectType }
     *     
     */
    public DifficultyToFillObjectType getDifficultyToFillReference() {
        return difficultyToFillReference;
    }

    /**
     * Sets the value of the difficultyToFillReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link DifficultyToFillObjectType }
     *     
     */
    public void setDifficultyToFillReference(DifficultyToFillObjectType value) {
        this.difficultyToFillReference = value;
    }

    /**
     * Sets the value of the positionStatusReference property.
     * 
     * @param positionStatusReference
     *     allowed object is
     *     {@link WorkerEventObjectType }
     *     
     */
    public void setPositionStatusReference(List<WorkerEventObjectType> positionStatusReference) {
        this.positionStatusReference = positionStatusReference;
    }

}
