
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains the detailed information about a Position.
 * 
 * <p>Java class for Position_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Position_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Supervisory_Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType"/>
 *         &lt;element name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Position_Definition_Data" type="{urn:com.workday/bsvc}Position_Details_DataType" minOccurs="0"/>
 *         &lt;element name="Position_Restrictions_Data" type="{urn:com.workday/bsvc}Position_Group_Restriction_Summary_DataType" minOccurs="0"/>
 *         &lt;element name="Default_Compensation_Data" type="{urn:com.workday/bsvc}Compensation_Default_DataType" minOccurs="0"/>
 *         &lt;element name="Default_Position_Organization_Assignments_Data" type="{urn:com.workday/bsvc}Default_Position_Organization_Assignments_DataType" minOccurs="0"/>
 *         &lt;element name="Worker_For_Filled_Position" type="{urn:com.workday/bsvc}Worker_For_Filled_PositionType" minOccurs="0"/>
 *         &lt;element name="Qualification_Data" type="{urn:com.workday/bsvc}Qualifications_from_Position_Restrictions_DataType" minOccurs="0"/>
 *         &lt;element name="Integration_Field_Override_Data" type="{urn:com.workday/bsvc}Document_Field_Result_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Job_Requisition_Data" type="{urn:com.workday/bsvc}Job_Requisition_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Position_DataType", propOrder = {
    "supervisoryOrganizationReference",
    "effectiveDate",
    "positionDefinitionData",
    "positionRestrictionsData",
    "defaultCompensationData",
    "defaultPositionOrganizationAssignmentsData",
    "workerForFilledPosition",
    "qualificationData",
    "integrationFieldOverrideData",
    "jobRequisitionData"
})
public class PositionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Supervisory_Organization_Reference", required = true)
    protected SupervisoryOrganizationObjectType supervisoryOrganizationReference;
    @XmlElement(name = "Effective_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;
    @XmlElement(name = "Position_Definition_Data")
    protected PositionDetailsDataType positionDefinitionData;
    @XmlElement(name = "Position_Restrictions_Data")
    protected PositionGroupRestrictionSummaryDataType positionRestrictionsData;
    @XmlElement(name = "Default_Compensation_Data")
    protected CompensationDefaultDataType defaultCompensationData;
    @XmlElement(name = "Default_Position_Organization_Assignments_Data")
    protected DefaultPositionOrganizationAssignmentsDataType defaultPositionOrganizationAssignmentsData;
    @XmlElement(name = "Worker_For_Filled_Position")
    protected WorkerForFilledPositionType workerForFilledPosition;
    @XmlElement(name = "Qualification_Data")
    protected QualificationsFromPositionRestrictionsDataType qualificationData;
    @XmlElement(name = "Integration_Field_Override_Data")
    protected List<DocumentFieldResultDataType> integrationFieldOverrideData;
    @XmlElement(name = "Job_Requisition_Data")
    protected JobRequisitionDataType jobRequisitionData;

    /**
     * Gets the value of the supervisoryOrganizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getSupervisoryOrganizationReference() {
        return supervisoryOrganizationReference;
    }

    /**
     * Sets the value of the supervisoryOrganizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setSupervisoryOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.supervisoryOrganizationReference = value;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

    /**
     * Gets the value of the positionDefinitionData property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsDataType }
     *     
     */
    public PositionDetailsDataType getPositionDefinitionData() {
        return positionDefinitionData;
    }

    /**
     * Sets the value of the positionDefinitionData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsDataType }
     *     
     */
    public void setPositionDefinitionData(PositionDetailsDataType value) {
        this.positionDefinitionData = value;
    }

    /**
     * Gets the value of the positionRestrictionsData property.
     * 
     * @return
     *     possible object is
     *     {@link PositionGroupRestrictionSummaryDataType }
     *     
     */
    public PositionGroupRestrictionSummaryDataType getPositionRestrictionsData() {
        return positionRestrictionsData;
    }

    /**
     * Sets the value of the positionRestrictionsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionGroupRestrictionSummaryDataType }
     *     
     */
    public void setPositionRestrictionsData(PositionGroupRestrictionSummaryDataType value) {
        this.positionRestrictionsData = value;
    }

    /**
     * Gets the value of the defaultCompensationData property.
     * 
     * @return
     *     possible object is
     *     {@link CompensationDefaultDataType }
     *     
     */
    public CompensationDefaultDataType getDefaultCompensationData() {
        return defaultCompensationData;
    }

    /**
     * Sets the value of the defaultCompensationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompensationDefaultDataType }
     *     
     */
    public void setDefaultCompensationData(CompensationDefaultDataType value) {
        this.defaultCompensationData = value;
    }

    /**
     * Gets the value of the defaultPositionOrganizationAssignmentsData property.
     * 
     * @return
     *     possible object is
     *     {@link DefaultPositionOrganizationAssignmentsDataType }
     *     
     */
    public DefaultPositionOrganizationAssignmentsDataType getDefaultPositionOrganizationAssignmentsData() {
        return defaultPositionOrganizationAssignmentsData;
    }

    /**
     * Sets the value of the defaultPositionOrganizationAssignmentsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link DefaultPositionOrganizationAssignmentsDataType }
     *     
     */
    public void setDefaultPositionOrganizationAssignmentsData(DefaultPositionOrganizationAssignmentsDataType value) {
        this.defaultPositionOrganizationAssignmentsData = value;
    }

    /**
     * Gets the value of the workerForFilledPosition property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerForFilledPositionType }
     *     
     */
    public WorkerForFilledPositionType getWorkerForFilledPosition() {
        return workerForFilledPosition;
    }

    /**
     * Sets the value of the workerForFilledPosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerForFilledPositionType }
     *     
     */
    public void setWorkerForFilledPosition(WorkerForFilledPositionType value) {
        this.workerForFilledPosition = value;
    }

    /**
     * Gets the value of the qualificationData property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationsFromPositionRestrictionsDataType }
     *     
     */
    public QualificationsFromPositionRestrictionsDataType getQualificationData() {
        return qualificationData;
    }

    /**
     * Sets the value of the qualificationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationsFromPositionRestrictionsDataType }
     *     
     */
    public void setQualificationData(QualificationsFromPositionRestrictionsDataType value) {
        this.qualificationData = value;
    }

    /**
     * Gets the value of the integrationFieldOverrideData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the integrationFieldOverrideData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIntegrationFieldOverrideData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentFieldResultDataType }
     * 
     * 
     */
    public List<DocumentFieldResultDataType> getIntegrationFieldOverrideData() {
        if (integrationFieldOverrideData == null) {
            integrationFieldOverrideData = new ArrayList<DocumentFieldResultDataType>();
        }
        return this.integrationFieldOverrideData;
    }

    /**
     * Gets the value of the jobRequisitionData property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionDataType }
     *     
     */
    public JobRequisitionDataType getJobRequisitionData() {
        return jobRequisitionData;
    }

    /**
     * Sets the value of the jobRequisitionData property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionDataType }
     *     
     */
    public void setJobRequisitionData(JobRequisitionDataType value) {
        this.jobRequisitionData = value;
    }

    /**
     * Sets the value of the integrationFieldOverrideData property.
     * 
     * @param integrationFieldOverrideData
     *     allowed object is
     *     {@link DocumentFieldResultDataType }
     *     
     */
    public void setIntegrationFieldOverrideData(List<DocumentFieldResultDataType> integrationFieldOverrideData) {
        this.integrationFieldOverrideData = integrationFieldOverrideData;
    }

}
