
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Contains the worker's skills and experience.
 * 
 * Security Note: This element is secured to the following domains:  Self Service: Skills and Experience; Worker: Skills and Experience
 * 
 * <p>Java class for Person_Qualification_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Person_Qualification_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Accomplishment" type="{urn:com.workday/bsvc}AccomplishmentType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="External_Job_History" type="{urn:com.workday/bsvc}Job_HistoryType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Competency" type="{urn:com.workday/bsvc}Competency_Achievement_Data__v10_Type" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Certification" type="{urn:com.workday/bsvc}Certification_AchievementType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Training" type="{urn:com.workday/bsvc}TrainingType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Award" type="{urn:com.workday/bsvc}AwardType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Organization_Membership" type="{urn:com.workday/bsvc}MembershipType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Education" type="{urn:com.workday/bsvc}EducationType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Work_Experience" type="{urn:com.workday/bsvc}Work_Experience_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Language" type="{urn:com.workday/bsvc}Language_Achievement_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Internal_Project_Experience" type="{urn:com.workday/bsvc}Internal_Project_ExperienceType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Person_Qualification_DataType", propOrder = {
    "accomplishment",
    "externalJobHistory",
    "competency",
    "certification",
    "training",
    "award",
    "organizationMembership",
    "education",
    "workExperience",
    "language",
    "internalProjectExperience"
})
public class PersonQualificationDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Accomplishment")
    protected List<AccomplishmentType> accomplishment;
    @XmlElement(name = "External_Job_History")
    protected List<JobHistoryType> externalJobHistory;
    @XmlElement(name = "Competency")
    protected List<CompetencyAchievementDataV10Type> competency;
    @XmlElement(name = "Certification")
    protected List<CertificationAchievementType> certification;
    @XmlElement(name = "Training")
    protected List<TrainingType> training;
    @XmlElement(name = "Award")
    protected List<AwardType> award;
    @XmlElement(name = "Organization_Membership")
    protected List<MembershipType> organizationMembership;
    @XmlElement(name = "Education")
    protected List<EducationType> education;
    @XmlElement(name = "Work_Experience")
    protected List<WorkExperienceDataType> workExperience;
    @XmlElement(name = "Language")
    protected List<LanguageAchievementDataType> language;
    @XmlElement(name = "Internal_Project_Experience")
    protected List<InternalProjectExperienceType> internalProjectExperience;

    /**
     * Gets the value of the accomplishment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accomplishment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccomplishment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccomplishmentType }
     * 
     * 
     */
    public List<AccomplishmentType> getAccomplishment() {
        if (accomplishment == null) {
            accomplishment = new ArrayList<AccomplishmentType>();
        }
        return this.accomplishment;
    }

    /**
     * Gets the value of the externalJobHistory property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the externalJobHistory property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExternalJobHistory().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JobHistoryType }
     * 
     * 
     */
    public List<JobHistoryType> getExternalJobHistory() {
        if (externalJobHistory == null) {
            externalJobHistory = new ArrayList<JobHistoryType>();
        }
        return this.externalJobHistory;
    }

    /**
     * Gets the value of the competency property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the competency property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCompetency().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompetencyAchievementDataV10Type }
     * 
     * 
     */
    public List<CompetencyAchievementDataV10Type> getCompetency() {
        if (competency == null) {
            competency = new ArrayList<CompetencyAchievementDataV10Type>();
        }
        return this.competency;
    }

    /**
     * Gets the value of the certification property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the certification property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCertification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CertificationAchievementType }
     * 
     * 
     */
    public List<CertificationAchievementType> getCertification() {
        if (certification == null) {
            certification = new ArrayList<CertificationAchievementType>();
        }
        return this.certification;
    }

    /**
     * Gets the value of the training property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the training property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTraining().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TrainingType }
     * 
     * 
     */
    public List<TrainingType> getTraining() {
        if (training == null) {
            training = new ArrayList<TrainingType>();
        }
        return this.training;
    }

    /**
     * Gets the value of the award property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the award property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAward().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AwardType }
     * 
     * 
     */
    public List<AwardType> getAward() {
        if (award == null) {
            award = new ArrayList<AwardType>();
        }
        return this.award;
    }

    /**
     * Gets the value of the organizationMembership property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationMembership property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationMembership().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MembershipType }
     * 
     * 
     */
    public List<MembershipType> getOrganizationMembership() {
        if (organizationMembership == null) {
            organizationMembership = new ArrayList<MembershipType>();
        }
        return this.organizationMembership;
    }

    /**
     * Gets the value of the education property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the education property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEducation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EducationType }
     * 
     * 
     */
    public List<EducationType> getEducation() {
        if (education == null) {
            education = new ArrayList<EducationType>();
        }
        return this.education;
    }

    /**
     * Gets the value of the workExperience property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workExperience property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkExperience().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkExperienceDataType }
     * 
     * 
     */
    public List<WorkExperienceDataType> getWorkExperience() {
        if (workExperience == null) {
            workExperience = new ArrayList<WorkExperienceDataType>();
        }
        return this.workExperience;
    }

    /**
     * Gets the value of the language property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the language property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLanguage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageAchievementDataType }
     * 
     * 
     */
    public List<LanguageAchievementDataType> getLanguage() {
        if (language == null) {
            language = new ArrayList<LanguageAchievementDataType>();
        }
        return this.language;
    }

    /**
     * Gets the value of the internalProjectExperience property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the internalProjectExperience property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInternalProjectExperience().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InternalProjectExperienceType }
     * 
     * 
     */
    public List<InternalProjectExperienceType> getInternalProjectExperience() {
        if (internalProjectExperience == null) {
            internalProjectExperience = new ArrayList<InternalProjectExperienceType>();
        }
        return this.internalProjectExperience;
    }

    /**
     * Sets the value of the accomplishment property.
     * 
     * @param accomplishment
     *     allowed object is
     *     {@link AccomplishmentType }
     *     
     */
    public void setAccomplishment(List<AccomplishmentType> accomplishment) {
        this.accomplishment = accomplishment;
    }

    /**
     * Sets the value of the externalJobHistory property.
     * 
     * @param externalJobHistory
     *     allowed object is
     *     {@link JobHistoryType }
     *     
     */
    public void setExternalJobHistory(List<JobHistoryType> externalJobHistory) {
        this.externalJobHistory = externalJobHistory;
    }

    /**
     * Sets the value of the competency property.
     * 
     * @param competency
     *     allowed object is
     *     {@link CompetencyAchievementDataV10Type }
     *     
     */
    public void setCompetency(List<CompetencyAchievementDataV10Type> competency) {
        this.competency = competency;
    }

    /**
     * Sets the value of the certification property.
     * 
     * @param certification
     *     allowed object is
     *     {@link CertificationAchievementType }
     *     
     */
    public void setCertification(List<CertificationAchievementType> certification) {
        this.certification = certification;
    }

    /**
     * Sets the value of the training property.
     * 
     * @param training
     *     allowed object is
     *     {@link TrainingType }
     *     
     */
    public void setTraining(List<TrainingType> training) {
        this.training = training;
    }

    /**
     * Sets the value of the award property.
     * 
     * @param award
     *     allowed object is
     *     {@link AwardType }
     *     
     */
    public void setAward(List<AwardType> award) {
        this.award = award;
    }

    /**
     * Sets the value of the organizationMembership property.
     * 
     * @param organizationMembership
     *     allowed object is
     *     {@link MembershipType }
     *     
     */
    public void setOrganizationMembership(List<MembershipType> organizationMembership) {
        this.organizationMembership = organizationMembership;
    }

    /**
     * Sets the value of the education property.
     * 
     * @param education
     *     allowed object is
     *     {@link EducationType }
     *     
     */
    public void setEducation(List<EducationType> education) {
        this.education = education;
    }

    /**
     * Sets the value of the workExperience property.
     * 
     * @param workExperience
     *     allowed object is
     *     {@link WorkExperienceDataType }
     *     
     */
    public void setWorkExperience(List<WorkExperienceDataType> workExperience) {
        this.workExperience = workExperience;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param language
     *     allowed object is
     *     {@link LanguageAchievementDataType }
     *     
     */
    public void setLanguage(List<LanguageAchievementDataType> language) {
        this.language = language;
    }

    /**
     * Sets the value of the internalProjectExperience property.
     * 
     * @param internalProjectExperience
     *     allowed object is
     *     {@link InternalProjectExperienceType }
     *     
     */
    public void setInternalProjectExperience(List<InternalProjectExperienceType> internalProjectExperience) {
        this.internalProjectExperience = internalProjectExperience;
    }

}
