
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper element for a Organization Role Assignment
 * 
 * <p>Java class for Organization_Role_Assignment_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Organization_Role_Assignment_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Role_Assigner_Reference" type="{urn:com.workday/bsvc}Role_AssignerObjectType"/>
 *         &lt;element name="Organization_Role_Reference" type="{urn:com.workday/bsvc}Assignable_RoleObjectType"/>
 *         &lt;element name="Role_Assignee_Reference" type="{urn:com.workday/bsvc}RoleeObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Organization_Role_Assignment_DataType", propOrder = {
    "roleAssignerReference",
    "organizationRoleReference",
    "roleAssigneeReference"
})
public class OrganizationRoleAssignmentDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Role_Assigner_Reference", required = true)
    protected RoleAssignerObjectType roleAssignerReference;
    @XmlElement(name = "Organization_Role_Reference", required = true)
    protected AssignableRoleObjectType organizationRoleReference;
    @XmlElement(name = "Role_Assignee_Reference")
    protected List<RoleeObjectType> roleAssigneeReference;

    /**
     * Gets the value of the roleAssignerReference property.
     * 
     * @return
     *     possible object is
     *     {@link RoleAssignerObjectType }
     *     
     */
    public RoleAssignerObjectType getRoleAssignerReference() {
        return roleAssignerReference;
    }

    /**
     * Sets the value of the roleAssignerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoleAssignerObjectType }
     *     
     */
    public void setRoleAssignerReference(RoleAssignerObjectType value) {
        this.roleAssignerReference = value;
    }

    /**
     * Gets the value of the organizationRoleReference property.
     * 
     * @return
     *     possible object is
     *     {@link AssignableRoleObjectType }
     *     
     */
    public AssignableRoleObjectType getOrganizationRoleReference() {
        return organizationRoleReference;
    }

    /**
     * Sets the value of the organizationRoleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignableRoleObjectType }
     *     
     */
    public void setOrganizationRoleReference(AssignableRoleObjectType value) {
        this.organizationRoleReference = value;
    }

    /**
     * Gets the value of the roleAssigneeReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the roleAssigneeReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRoleAssigneeReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RoleeObjectType }
     * 
     * 
     */
    public List<RoleeObjectType> getRoleAssigneeReference() {
        if (roleAssigneeReference == null) {
            roleAssigneeReference = new ArrayList<RoleeObjectType>();
        }
        return this.roleAssigneeReference;
    }

    /**
     * Sets the value of the roleAssigneeReference property.
     * 
     * @param roleAssigneeReference
     *     allowed object is
     *     {@link RoleeObjectType }
     *     
     */
    public void setRoleAssigneeReference(List<RoleeObjectType> roleAssigneeReference) {
        this.roleAssigneeReference = roleAssigneeReference;
    }

}
