
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Data Element that contains the one-time payment information.
 * 
 * <p>Java class for One-Time_Payment_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="One-Time_Payment_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="One_Time_Payment_Plan_Reference" type="{urn:com.workday/bsvc}One-Time_Payment_PlanObjectType"/>
 *         &lt;choice>
 *           &lt;element name="Amount" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="26"/>
 *                 &lt;fractionDigits value="6"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *           &lt;element name="Percent" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="18"/>
 *                 &lt;fractionDigits value="6"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *         &lt;/choice>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Comment" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Do_Not_Pay" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Worktags_Data" type="{urn:com.workday/bsvc}Payroll_One_Time_Payment_Worktag_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "One-Time_Payment_DataType", propOrder = {
    "oneTimePaymentPlanReference",
    "amount",
    "percent",
    "currencyReference",
    "comment",
    "doNotPay",
    "worktagsData"
})
public class OneTimePaymentDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "One_Time_Payment_Plan_Reference", required = true)
    protected OneTimePaymentPlanObjectType oneTimePaymentPlanReference;
    @XmlElement(name = "Amount")
    protected BigDecimal amount;
    @XmlElement(name = "Percent")
    protected BigDecimal percent;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Comment")
    protected String comment;
    @XmlElement(name = "Do_Not_Pay")
    protected Boolean doNotPay;
    @XmlElement(name = "Worktags_Data")
    protected PayrollOneTimePaymentWorktagDataType worktagsData;

    /**
     * Gets the value of the oneTimePaymentPlanReference property.
     * 
     * @return
     *     possible object is
     *     {@link OneTimePaymentPlanObjectType }
     *     
     */
    public OneTimePaymentPlanObjectType getOneTimePaymentPlanReference() {
        return oneTimePaymentPlanReference;
    }

    /**
     * Sets the value of the oneTimePaymentPlanReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OneTimePaymentPlanObjectType }
     *     
     */
    public void setOneTimePaymentPlanReference(OneTimePaymentPlanObjectType value) {
        this.oneTimePaymentPlanReference = value;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    /**
     * Gets the value of the percent property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPercent() {
        return percent;
    }

    /**
     * Sets the value of the percent property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPercent(BigDecimal value) {
        this.percent = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the comment property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComment() {
        return comment;
    }

    /**
     * Sets the value of the comment property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setComment(String value) {
        this.comment = value;
    }

    /**
     * Gets the value of the doNotPay property.
     * This getter has been renamed from isDoNotPay() to getDoNotPay() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getDoNotPay() {
        return doNotPay;
    }

    /**
     * Sets the value of the doNotPay property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDoNotPay(Boolean value) {
        this.doNotPay = value;
    }

    /**
     * Gets the value of the worktagsData property.
     * 
     * @return
     *     possible object is
     *     {@link PayrollOneTimePaymentWorktagDataType }
     *     
     */
    public PayrollOneTimePaymentWorktagDataType getWorktagsData() {
        return worktagsData;
    }

    /**
     * Sets the value of the worktagsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayrollOneTimePaymentWorktagDataType }
     *     
     */
    public void setWorktagsData(PayrollOneTimePaymentWorktagDataType value) {
        this.worktagsData = value;
    }

}
