
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper Element for a Job Requisition
 * 
 * <p>Java class for Job_Requisition_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Job_Requisition_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" minOccurs="0"/>
 *         &lt;element name="Job_Requisition_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Job_Requisition_Status_Reference" type="{urn:com.workday/bsvc}Job_Requisition_StatusObjectType" minOccurs="0"/>
 *         &lt;element name="Job_Posting_Title" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Recruiting_Instruction_Data" type="{urn:com.workday/bsvc}Recruiting_Instruction_DataType" minOccurs="0"/>
 *         &lt;element name="Academic_Tenure_Eligible" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Number_of_Openings" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="7"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="0"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Job_Description_Summary" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Justification" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Job_Requisition_Attachments" type="{urn:com.workday/bsvc}Job_Requisition_AttachmentsType" minOccurs="0"/>
 *         &lt;element name="Recruiting_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Target_Hire_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Target_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Job_Profile_Reference" type="{urn:com.workday/bsvc}Job_ProfileObjectType" minOccurs="0"/>
 *         &lt;element name="Worker_Type_Reference" type="{urn:com.workday/bsvc}Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Position_Worker_Type_Reference" type="{urn:com.workday/bsvc}Position_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Primary_Location_Reference" type="{urn:com.workday/bsvc}LocationObjectType" minOccurs="0"/>
 *         &lt;element name="Additional_Locations_Reference" type="{urn:com.workday/bsvc}LocationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Position_Time_Type_Reference" type="{urn:com.workday/bsvc}Position_Time_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Scheduled_Weekly_Hours" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="5"/>
 *               &lt;fractionDigits value="2"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Work_Shift_Reference" type="{urn:com.workday/bsvc}Work_ShiftObjectType" minOccurs="0"/>
 *         &lt;element name="Qualification_Data" type="{urn:com.workday/bsvc}Qualification_Data_for_Position_Restriction_or_Job_ProfileType" minOccurs="0"/>
 *         &lt;element name="Replacement_for_Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Job_Requisition_DataType", propOrder = {
    "jobRequisitionReference",
    "jobRequisitionID",
    "jobRequisitionStatusReference",
    "jobPostingTitle",
    "recruitingInstructionData",
    "academicTenureEligible",
    "numberOfOpenings",
    "jobDescriptionSummary",
    "justification",
    "jobRequisitionAttachments",
    "recruitingStartDate",
    "targetHireDate",
    "targetEndDate",
    "jobProfileReference",
    "workerTypeReference",
    "positionWorkerTypeReference",
    "primaryLocationReference",
    "additionalLocationsReference",
    "positionTimeTypeReference",
    "scheduledWeeklyHours",
    "workShiftReference",
    "qualificationData",
    "replacementForWorkerReference"
})
public class JobRequisitionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Job_Requisition_Reference")
    protected JobRequisitionObjectType jobRequisitionReference;
    @XmlElement(name = "Job_Requisition_ID")
    protected String jobRequisitionID;
    @XmlElement(name = "Job_Requisition_Status_Reference")
    protected JobRequisitionStatusObjectType jobRequisitionStatusReference;
    @XmlElement(name = "Job_Posting_Title")
    protected String jobPostingTitle;
    @XmlElement(name = "Recruiting_Instruction_Data")
    protected RecruitingInstructionDataType recruitingInstructionData;
    @XmlElement(name = "Academic_Tenure_Eligible")
    protected Boolean academicTenureEligible;
    @XmlElement(name = "Number_of_Openings")
    protected BigDecimal numberOfOpenings;
    @XmlElement(name = "Job_Description_Summary")
    protected String jobDescriptionSummary;
    @XmlElement(name = "Justification")
    protected String justification;
    @XmlElement(name = "Job_Requisition_Attachments")
    protected JobRequisitionAttachmentsType jobRequisitionAttachments;
    @XmlElement(name = "Recruiting_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar recruitingStartDate;
    @XmlElement(name = "Target_Hire_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar targetHireDate;
    @XmlElement(name = "Target_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar targetEndDate;
    @XmlElement(name = "Job_Profile_Reference")
    protected JobProfileObjectType jobProfileReference;
    @XmlElement(name = "Worker_Type_Reference")
    protected WorkerTypeObjectType workerTypeReference;
    @XmlElement(name = "Position_Worker_Type_Reference")
    protected PositionWorkerTypeObjectType positionWorkerTypeReference;
    @XmlElement(name = "Primary_Location_Reference")
    protected LocationObjectType primaryLocationReference;
    @XmlElement(name = "Additional_Locations_Reference")
    protected List<LocationObjectType> additionalLocationsReference;
    @XmlElement(name = "Position_Time_Type_Reference")
    protected PositionTimeTypeObjectType positionTimeTypeReference;
    @XmlElement(name = "Scheduled_Weekly_Hours")
    protected BigDecimal scheduledWeeklyHours;
    @XmlElement(name = "Work_Shift_Reference")
    protected WorkShiftObjectType workShiftReference;
    @XmlElement(name = "Qualification_Data")
    protected QualificationDataForPositionRestrictionOrJobProfileType qualificationData;
    @XmlElement(name = "Replacement_for_Worker_Reference")
    protected WorkerObjectType replacementForWorkerReference;

    /**
     * Gets the value of the jobRequisitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public JobRequisitionObjectType getJobRequisitionReference() {
        return jobRequisitionReference;
    }

    /**
     * Sets the value of the jobRequisitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setJobRequisitionReference(JobRequisitionObjectType value) {
        this.jobRequisitionReference = value;
    }

    /**
     * Gets the value of the jobRequisitionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobRequisitionID() {
        return jobRequisitionID;
    }

    /**
     * Sets the value of the jobRequisitionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobRequisitionID(String value) {
        this.jobRequisitionID = value;
    }

    /**
     * Gets the value of the jobRequisitionStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionStatusObjectType }
     *     
     */
    public JobRequisitionStatusObjectType getJobRequisitionStatusReference() {
        return jobRequisitionStatusReference;
    }

    /**
     * Sets the value of the jobRequisitionStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionStatusObjectType }
     *     
     */
    public void setJobRequisitionStatusReference(JobRequisitionStatusObjectType value) {
        this.jobRequisitionStatusReference = value;
    }

    /**
     * Gets the value of the jobPostingTitle property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobPostingTitle() {
        return jobPostingTitle;
    }

    /**
     * Sets the value of the jobPostingTitle property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobPostingTitle(String value) {
        this.jobPostingTitle = value;
    }

    /**
     * Gets the value of the recruitingInstructionData property.
     * 
     * @return
     *     possible object is
     *     {@link RecruitingInstructionDataType }
     *     
     */
    public RecruitingInstructionDataType getRecruitingInstructionData() {
        return recruitingInstructionData;
    }

    /**
     * Sets the value of the recruitingInstructionData property.
     * 
     * @param value
     *     allowed object is
     *     {@link RecruitingInstructionDataType }
     *     
     */
    public void setRecruitingInstructionData(RecruitingInstructionDataType value) {
        this.recruitingInstructionData = value;
    }

    /**
     * Gets the value of the academicTenureEligible property.
     * This getter has been renamed from isAcademicTenureEligible() to getAcademicTenureEligible() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getAcademicTenureEligible() {
        return academicTenureEligible;
    }

    /**
     * Sets the value of the academicTenureEligible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAcademicTenureEligible(Boolean value) {
        this.academicTenureEligible = value;
    }

    /**
     * Gets the value of the numberOfOpenings property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getNumberOfOpenings() {
        return numberOfOpenings;
    }

    /**
     * Sets the value of the numberOfOpenings property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setNumberOfOpenings(BigDecimal value) {
        this.numberOfOpenings = value;
    }

    /**
     * Gets the value of the jobDescriptionSummary property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobDescriptionSummary() {
        return jobDescriptionSummary;
    }

    /**
     * Sets the value of the jobDescriptionSummary property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobDescriptionSummary(String value) {
        this.jobDescriptionSummary = value;
    }

    /**
     * Gets the value of the justification property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJustification() {
        return justification;
    }

    /**
     * Sets the value of the justification property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJustification(String value) {
        this.justification = value;
    }

    /**
     * Gets the value of the jobRequisitionAttachments property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionAttachmentsType }
     *     
     */
    public JobRequisitionAttachmentsType getJobRequisitionAttachments() {
        return jobRequisitionAttachments;
    }

    /**
     * Sets the value of the jobRequisitionAttachments property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionAttachmentsType }
     *     
     */
    public void setJobRequisitionAttachments(JobRequisitionAttachmentsType value) {
        this.jobRequisitionAttachments = value;
    }

    /**
     * Gets the value of the recruitingStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getRecruitingStartDate() {
        return recruitingStartDate;
    }

    /**
     * Sets the value of the recruitingStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setRecruitingStartDate(XMLGregorianCalendar value) {
        this.recruitingStartDate = value;
    }

    /**
     * Gets the value of the targetHireDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTargetHireDate() {
        return targetHireDate;
    }

    /**
     * Sets the value of the targetHireDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTargetHireDate(XMLGregorianCalendar value) {
        this.targetHireDate = value;
    }

    /**
     * Gets the value of the targetEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTargetEndDate() {
        return targetEndDate;
    }

    /**
     * Sets the value of the targetEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTargetEndDate(XMLGregorianCalendar value) {
        this.targetEndDate = value;
    }

    /**
     * Gets the value of the jobProfileReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobProfileObjectType }
     *     
     */
    public JobProfileObjectType getJobProfileReference() {
        return jobProfileReference;
    }

    /**
     * Sets the value of the jobProfileReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobProfileObjectType }
     *     
     */
    public void setJobProfileReference(JobProfileObjectType value) {
        this.jobProfileReference = value;
    }

    /**
     * Gets the value of the workerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerTypeObjectType }
     *     
     */
    public WorkerTypeObjectType getWorkerTypeReference() {
        return workerTypeReference;
    }

    /**
     * Sets the value of the workerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerTypeObjectType }
     *     
     */
    public void setWorkerTypeReference(WorkerTypeObjectType value) {
        this.workerTypeReference = value;
    }

    /**
     * Gets the value of the positionWorkerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public PositionWorkerTypeObjectType getPositionWorkerTypeReference() {
        return positionWorkerTypeReference;
    }

    /**
     * Sets the value of the positionWorkerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public void setPositionWorkerTypeReference(PositionWorkerTypeObjectType value) {
        this.positionWorkerTypeReference = value;
    }

    /**
     * Gets the value of the primaryLocationReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocationObjectType }
     *     
     */
    public LocationObjectType getPrimaryLocationReference() {
        return primaryLocationReference;
    }

    /**
     * Sets the value of the primaryLocationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setPrimaryLocationReference(LocationObjectType value) {
        this.primaryLocationReference = value;
    }

    /**
     * Gets the value of the additionalLocationsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalLocationsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalLocationsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LocationObjectType }
     * 
     * 
     */
    public List<LocationObjectType> getAdditionalLocationsReference() {
        if (additionalLocationsReference == null) {
            additionalLocationsReference = new ArrayList<LocationObjectType>();
        }
        return this.additionalLocationsReference;
    }

    /**
     * Gets the value of the positionTimeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionTimeTypeObjectType }
     *     
     */
    public PositionTimeTypeObjectType getPositionTimeTypeReference() {
        return positionTimeTypeReference;
    }

    /**
     * Sets the value of the positionTimeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionTimeTypeObjectType }
     *     
     */
    public void setPositionTimeTypeReference(PositionTimeTypeObjectType value) {
        this.positionTimeTypeReference = value;
    }

    /**
     * Gets the value of the scheduledWeeklyHours property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getScheduledWeeklyHours() {
        return scheduledWeeklyHours;
    }

    /**
     * Sets the value of the scheduledWeeklyHours property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setScheduledWeeklyHours(BigDecimal value) {
        this.scheduledWeeklyHours = value;
    }

    /**
     * Gets the value of the workShiftReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkShiftObjectType }
     *     
     */
    public WorkShiftObjectType getWorkShiftReference() {
        return workShiftReference;
    }

    /**
     * Sets the value of the workShiftReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkShiftObjectType }
     *     
     */
    public void setWorkShiftReference(WorkShiftObjectType value) {
        this.workShiftReference = value;
    }

    /**
     * Gets the value of the qualificationData property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationDataForPositionRestrictionOrJobProfileType }
     *     
     */
    public QualificationDataForPositionRestrictionOrJobProfileType getQualificationData() {
        return qualificationData;
    }

    /**
     * Sets the value of the qualificationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationDataForPositionRestrictionOrJobProfileType }
     *     
     */
    public void setQualificationData(QualificationDataForPositionRestrictionOrJobProfileType value) {
        this.qualificationData = value;
    }

    /**
     * Gets the value of the replacementForWorkerReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getReplacementForWorkerReference() {
        return replacementForWorkerReference;
    }

    /**
     * Sets the value of the replacementForWorkerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setReplacementForWorkerReference(WorkerObjectType value) {
        this.replacementForWorkerReference = value;
    }

    /**
     * Sets the value of the additionalLocationsReference property.
     * 
     * @param additionalLocationsReference
     *     allowed object is
     *     {@link LocationObjectType }
     *     
     */
    public void setAdditionalLocationsReference(List<LocationObjectType> additionalLocationsReference) {
        this.additionalLocationsReference = additionalLocationsReference;
    }

}
