
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Data element for the Request Stock Grant business process.
 * 
 * <p>Java class for Individual_Stock_Grant_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Individual_Stock_Grant_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Shares_Granted" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="15"/>
 *                 &lt;minInclusive value="0"/>
 *                 &lt;fractionDigits value="0"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *           &lt;element name="Grant_Percent" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="10"/>
 *                 &lt;minInclusive value="0"/>
 *                 &lt;fractionDigits value="6"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *           &lt;element name="Grant_Amount" minOccurs="0">
 *             &lt;simpleType>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *                 &lt;totalDigits value="26"/>
 *                 &lt;minInclusive value="0"/>
 *                 &lt;fractionDigits value="6"/>
 *               &lt;/restriction>
 *             &lt;/simpleType>
 *           &lt;/element>
 *         &lt;/choice>
 *         &lt;element name="Grant_Type_Reference" type="{urn:com.workday/bsvc}Stock_Grant_TypeObjectType"/>
 *         &lt;element name="Grant_Amount_Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Option_Pricing_Factor" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="5"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="4"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Comments" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Vesting_Schedule_Reference" type="{urn:com.workday/bsvc}Stock_Vesting_ScheduleObjectType" minOccurs="0"/>
 *         &lt;element name="Grant_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Grant_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Vest_From_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Expiration_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Grant_Price" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="16"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Board_Approved" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Individual_Stock_Grant_DataType", propOrder = {
    "sharesGranted",
    "grantPercent",
    "grantAmount",
    "grantTypeReference",
    "grantAmountCurrencyReference",
    "optionPricingFactor",
    "comments",
    "vestingScheduleReference",
    "grantID",
    "grantDate",
    "vestFromDate",
    "expirationDate",
    "grantPrice",
    "currencyReference",
    "boardApproved"
})
public class IndividualStockGrantDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Shares_Granted")
    protected BigDecimal sharesGranted;
    @XmlElement(name = "Grant_Percent")
    protected BigDecimal grantPercent;
    @XmlElement(name = "Grant_Amount")
    protected BigDecimal grantAmount;
    @XmlElement(name = "Grant_Type_Reference", required = true)
    protected StockGrantTypeObjectType grantTypeReference;
    @XmlElement(name = "Grant_Amount_Currency_Reference")
    protected CurrencyObjectType grantAmountCurrencyReference;
    @XmlElement(name = "Option_Pricing_Factor")
    protected BigDecimal optionPricingFactor;
    @XmlElement(name = "Comments")
    protected String comments;
    @XmlElement(name = "Vesting_Schedule_Reference")
    protected StockVestingScheduleObjectType vestingScheduleReference;
    @XmlElement(name = "Grant_ID")
    protected String grantID;
    @XmlElement(name = "Grant_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar grantDate;
    @XmlElement(name = "Vest_From_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar vestFromDate;
    @XmlElement(name = "Expiration_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expirationDate;
    @XmlElement(name = "Grant_Price")
    protected BigDecimal grantPrice;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Board_Approved")
    protected Boolean boardApproved;

    /**
     * Gets the value of the sharesGranted property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getSharesGranted() {
        return sharesGranted;
    }

    /**
     * Sets the value of the sharesGranted property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setSharesGranted(BigDecimal value) {
        this.sharesGranted = value;
    }

    /**
     * Gets the value of the grantPercent property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGrantPercent() {
        return grantPercent;
    }

    /**
     * Sets the value of the grantPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGrantPercent(BigDecimal value) {
        this.grantPercent = value;
    }

    /**
     * Gets the value of the grantAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGrantAmount() {
        return grantAmount;
    }

    /**
     * Sets the value of the grantAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGrantAmount(BigDecimal value) {
        this.grantAmount = value;
    }

    /**
     * Gets the value of the grantTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link StockGrantTypeObjectType }
     *     
     */
    public StockGrantTypeObjectType getGrantTypeReference() {
        return grantTypeReference;
    }

    /**
     * Sets the value of the grantTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StockGrantTypeObjectType }
     *     
     */
    public void setGrantTypeReference(StockGrantTypeObjectType value) {
        this.grantTypeReference = value;
    }

    /**
     * Gets the value of the grantAmountCurrencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getGrantAmountCurrencyReference() {
        return grantAmountCurrencyReference;
    }

    /**
     * Sets the value of the grantAmountCurrencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setGrantAmountCurrencyReference(CurrencyObjectType value) {
        this.grantAmountCurrencyReference = value;
    }

    /**
     * Gets the value of the optionPricingFactor property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getOptionPricingFactor() {
        return optionPricingFactor;
    }

    /**
     * Sets the value of the optionPricingFactor property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setOptionPricingFactor(BigDecimal value) {
        this.optionPricingFactor = value;
    }

    /**
     * Gets the value of the comments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComments() {
        return comments;
    }

    /**
     * Sets the value of the comments property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setComments(String value) {
        this.comments = value;
    }

    /**
     * Gets the value of the vestingScheduleReference property.
     * 
     * @return
     *     possible object is
     *     {@link StockVestingScheduleObjectType }
     *     
     */
    public StockVestingScheduleObjectType getVestingScheduleReference() {
        return vestingScheduleReference;
    }

    /**
     * Sets the value of the vestingScheduleReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StockVestingScheduleObjectType }
     *     
     */
    public void setVestingScheduleReference(StockVestingScheduleObjectType value) {
        this.vestingScheduleReference = value;
    }

    /**
     * Gets the value of the grantID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGrantID() {
        return grantID;
    }

    /**
     * Sets the value of the grantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGrantID(String value) {
        this.grantID = value;
    }

    /**
     * Gets the value of the grantDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getGrantDate() {
        return grantDate;
    }

    /**
     * Sets the value of the grantDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setGrantDate(XMLGregorianCalendar value) {
        this.grantDate = value;
    }

    /**
     * Gets the value of the vestFromDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getVestFromDate() {
        return vestFromDate;
    }

    /**
     * Sets the value of the vestFromDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setVestFromDate(XMLGregorianCalendar value) {
        this.vestFromDate = value;
    }

    /**
     * Gets the value of the expirationDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpirationDate() {
        return expirationDate;
    }

    /**
     * Sets the value of the expirationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpirationDate(XMLGregorianCalendar value) {
        this.expirationDate = value;
    }

    /**
     * Gets the value of the grantPrice property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getGrantPrice() {
        return grantPrice;
    }

    /**
     * Sets the value of the grantPrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setGrantPrice(BigDecimal value) {
        this.grantPrice = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the boardApproved property.
     * This getter has been renamed from isBoardApproved() to getBoardApproved() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getBoardApproved() {
        return boardApproved;
    }

    /**
     * Sets the value of the boardApproved property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setBoardApproved(Boolean value) {
        this.boardApproved = value;
    }

}
