
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the details for an Employee Hire.
 * 
 * <p>Java class for Hire_Employee_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Hire_Employee_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Employee_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Hire_Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Employee_Type_Reference" type="{urn:com.workday/bsvc}Position_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="First_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Time_of_Hire" type="{http://www.w3.org/2001/XMLSchema}time" minOccurs="0"/>
 *         &lt;element name="Continuous_Service_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Probation_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Probation_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Employment_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Benefits_Service_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Company_Service_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Conversion_Position_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Position_Details" type="{urn:com.workday/bsvc}Position_Details_Sub_DataType"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Employee_External_ID_Data" type="{urn:com.workday/bsvc}External_ID_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Hire_Employee_Event_DataType", propOrder = {
    "employeeID",
    "positionID",
    "hireReasonReference",
    "employeeTypeReference",
    "firstDayOfWork",
    "timeOfHire",
    "continuousServiceDate",
    "probationStartDate",
    "probationEndDate",
    "employmentEndDate",
    "benefitsServiceDate",
    "companyServiceDate",
    "conversionPositionStartDate",
    "positionDetails",
    "workerDocumentData",
    "employeeExternalIDData"
})
public class HireEmployeeEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Employee_ID")
    protected String employeeID;
    @XmlElement(name = "Position_ID")
    protected String positionID;
    @XmlElement(name = "Hire_Reason_Reference")
    protected EventClassificationSubcategoryObjectType hireReasonReference;
    @XmlElement(name = "Employee_Type_Reference")
    protected PositionWorkerTypeObjectType employeeTypeReference;
    @XmlElement(name = "First_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstDayOfWork;
    @XmlElement(name = "Time_of_Hire")
    @XmlSchemaType(name = "time")
    protected XMLGregorianCalendar timeOfHire;
    @XmlElement(name = "Continuous_Service_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar continuousServiceDate;
    @XmlElement(name = "Probation_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar probationStartDate;
    @XmlElement(name = "Probation_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar probationEndDate;
    @XmlElement(name = "Employment_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar employmentEndDate;
    @XmlElement(name = "Benefits_Service_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar benefitsServiceDate;
    @XmlElement(name = "Company_Service_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar companyServiceDate;
    @XmlElement(name = "Conversion_Position_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar conversionPositionStartDate;
    @XmlElement(name = "Position_Details", required = true)
    protected PositionDetailsSubDataType positionDetails;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;
    @XmlElement(name = "Employee_External_ID_Data")
    protected ExternalIDDataType employeeExternalIDData;

    /**
     * Gets the value of the employeeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEmployeeID() {
        return employeeID;
    }

    /**
     * Sets the value of the employeeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEmployeeID(String value) {
        this.employeeID = value;
    }

    /**
     * Gets the value of the positionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionID() {
        return positionID;
    }

    /**
     * Sets the value of the positionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionID(String value) {
        this.positionID = value;
    }

    /**
     * Gets the value of the hireReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getHireReasonReference() {
        return hireReasonReference;
    }

    /**
     * Sets the value of the hireReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setHireReasonReference(EventClassificationSubcategoryObjectType value) {
        this.hireReasonReference = value;
    }

    /**
     * Gets the value of the employeeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public PositionWorkerTypeObjectType getEmployeeTypeReference() {
        return employeeTypeReference;
    }

    /**
     * Sets the value of the employeeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionWorkerTypeObjectType }
     *     
     */
    public void setEmployeeTypeReference(PositionWorkerTypeObjectType value) {
        this.employeeTypeReference = value;
    }

    /**
     * Gets the value of the firstDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstDayOfWork() {
        return firstDayOfWork;
    }

    /**
     * Sets the value of the firstDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstDayOfWork(XMLGregorianCalendar value) {
        this.firstDayOfWork = value;
    }

    /**
     * Gets the value of the timeOfHire property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTimeOfHire() {
        return timeOfHire;
    }

    /**
     * Sets the value of the timeOfHire property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTimeOfHire(XMLGregorianCalendar value) {
        this.timeOfHire = value;
    }

    /**
     * Gets the value of the continuousServiceDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContinuousServiceDate() {
        return continuousServiceDate;
    }

    /**
     * Sets the value of the continuousServiceDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContinuousServiceDate(XMLGregorianCalendar value) {
        this.continuousServiceDate = value;
    }

    /**
     * Gets the value of the probationStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getProbationStartDate() {
        return probationStartDate;
    }

    /**
     * Sets the value of the probationStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setProbationStartDate(XMLGregorianCalendar value) {
        this.probationStartDate = value;
    }

    /**
     * Gets the value of the probationEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getProbationEndDate() {
        return probationEndDate;
    }

    /**
     * Sets the value of the probationEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setProbationEndDate(XMLGregorianCalendar value) {
        this.probationEndDate = value;
    }

    /**
     * Gets the value of the employmentEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEmploymentEndDate() {
        return employmentEndDate;
    }

    /**
     * Sets the value of the employmentEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEmploymentEndDate(XMLGregorianCalendar value) {
        this.employmentEndDate = value;
    }

    /**
     * Gets the value of the benefitsServiceDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getBenefitsServiceDate() {
        return benefitsServiceDate;
    }

    /**
     * Sets the value of the benefitsServiceDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setBenefitsServiceDate(XMLGregorianCalendar value) {
        this.benefitsServiceDate = value;
    }

    /**
     * Gets the value of the companyServiceDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCompanyServiceDate() {
        return companyServiceDate;
    }

    /**
     * Sets the value of the companyServiceDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCompanyServiceDate(XMLGregorianCalendar value) {
        this.companyServiceDate = value;
    }

    /**
     * Gets the value of the conversionPositionStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getConversionPositionStartDate() {
        return conversionPositionStartDate;
    }

    /**
     * Sets the value of the conversionPositionStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setConversionPositionStartDate(XMLGregorianCalendar value) {
        this.conversionPositionStartDate = value;
    }

    /**
     * Gets the value of the positionDetails property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public PositionDetailsSubDataType getPositionDetails() {
        return positionDetails;
    }

    /**
     * Sets the value of the positionDetails property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public void setPositionDetails(PositionDetailsSubDataType value) {
        this.positionDetails = value;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Gets the value of the employeeExternalIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIDDataType }
     *     
     */
    public ExternalIDDataType getEmployeeExternalIDData() {
        return employeeExternalIDData;
    }

    /**
     * Sets the value of the employeeExternalIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIDDataType }
     *     
     */
    public void setEmployeeExternalIDData(ExternalIDDataType value) {
        this.employeeExternalIDData = value;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
