
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper Element for the Hire Employee business process web service and its sub business processes.
 * 
 * <p>Java class for Hire_Employee_Business_Process_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Hire_Employee_Business_Process_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Applicant_Reference" type="{urn:com.workday/bsvc}ApplicantObjectType"/>
 *           &lt;element name="Former_Worker_Reference" type="{urn:com.workday/bsvc}Former_WorkerObjectType"/>
 *           &lt;element name="Applicant_Data" type="{urn:com.workday/bsvc}Create_Applicant_DataType"/>
 *         &lt;/choice>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Headcount_Reference" type="{urn:com.workday/bsvc}Headcount_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Hire_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Hire_Employee_Event_Data" type="{urn:com.workday/bsvc}Hire_Employee_Event_DataType"/>
 *         &lt;element name="Propose_Compensation_for_Hire_Sub_Process" type="{urn:com.workday/bsvc}Propose_Compensation_For_Employment_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Update_ID_Information_Sub_Process" type="{urn:com.workday/bsvc}Update_ID_Information_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Government_IDs_Sub_Process" type="{urn:com.workday/bsvc}Edit_Government_IDs_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Passports_and_Visas_Sub_Process" type="{urn:com.workday/bsvc}Edit_Passports_and_Visas_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_License_Sub_Process" type="{urn:com.workday/bsvc}Edit_Licenses_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Custom_IDs_Sub_Process" type="{urn:com.workday/bsvc}Edit_Custom_IDs_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Assign_Organization_Sub_Process" type="{urn:com.workday/bsvc}Edit_Assign_Position_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Pay_Group_Sub_Process" type="{urn:com.workday/bsvc}Assign_Pay_Group_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Review_Payroll_Interface_Sub_Process" type="{urn:com.workday/bsvc}Review_Payroll_Interface_Data_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_One_Time_Payment_Sub_Process" type="{urn:com.workday/bsvc}Request_One_Time_Payment_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_Stock_Grant_Sub_Process" type="{urn:com.workday/bsvc}Request_Stock_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Create_Workday_Account_Sub_Process" type="{urn:com.workday/bsvc}Create_Workday_Account_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Matrix_Organization_Sub_Process" type="{urn:com.workday/bsvc}Assign_Matrix_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Change_Personal_Information_Sub_Process" type="{urn:com.workday/bsvc}Change_Personal_Information_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Create_Provisioning_Event_Sub_Process" type="{urn:com.workday/bsvc}Create_Provisioning_Event_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Create_Benefit_Life_Event_Sub_Process" type="{urn:com.workday/bsvc}Create_Benefit_Life_Event_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Maintain_Employee_Contracts_Sub_Business_Process" type="{urn:com.workday/bsvc}Maintain_Employee_Contracts_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Service_Dates_Sub_Process" type="{urn:com.workday/bsvc}Edit_Service_Dates_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Remove_Retiree_Status_Sub_Process" type="{urn:com.workday/bsvc}Remove_Retiree_Status_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_Budget_Approval_Sub_Business_Process" type="{urn:com.workday/bsvc}Request_Budget_Approval_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Check_Position_Budget_Sub_Process" type="{urn:com.workday/bsvc}Check_Position_Budget_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Costing_Allocation_Sub_Process" type="{urn:com.workday/bsvc}Assign_Costing_Allocation_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Background_Check_Sub_Process" type="{urn:com.workday/bsvc}Edit_Background_Check_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Add_Academic_Appointment_Sub_Process" type="{urn:com.workday/bsvc}Add_Academic_Appointment_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Employee_Collective_Agreement_Sub_Process" type="{urn:com.workday/bsvc}Assign_Employee_Collective_Agreement_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Manage_Employee_Probation_Period_Sub_Business_Process" type="{urn:com.workday/bsvc}Manage_Probation_Period_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Emergency_Contacts_Sub_Process" type="{urn:com.workday/bsvc}Change_Emergency_Contacts_Sub_Business_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Hire_Employee_Business_Process_DataType", propOrder = {
    "applicantReference",
    "formerWorkerReference",
    "applicantData",
    "organizationReference",
    "positionReference",
    "headcountReference",
    "jobRequisitionReference",
    "hireDate",
    "hireEmployeeEventData",
    "proposeCompensationForHireSubProcess",
    "updateIDInformationSubProcess",
    "editGovernmentIDsSubProcess",
    "editPassportsAndVisasSubProcess",
    "editLicenseSubProcess",
    "editCustomIDsSubProcess",
    "editAssignOrganizationSubProcess",
    "assignPayGroupSubProcess",
    "reviewPayrollInterfaceSubProcess",
    "requestOneTimePaymentSubProcess",
    "requestStockGrantSubProcess",
    "createWorkdayAccountSubProcess",
    "assignMatrixOrganizationSubProcess",
    "changePersonalInformationSubProcess",
    "createProvisioningEventSubProcess",
    "createBenefitLifeEventSubProcess",
    "maintainEmployeeContractsSubBusinessProcess",
    "editServiceDatesSubProcess",
    "removeRetireeStatusSubProcess",
    "requestBudgetApprovalSubBusinessProcess",
    "checkPositionBudgetSubProcess",
    "assignCostingAllocationSubProcess",
    "editBackgroundCheckSubProcess",
    "addAcademicAppointmentSubProcess",
    "assignEmployeeCollectiveAgreementSubProcess",
    "manageEmployeeProbationPeriodSubBusinessProcess",
    "emergencyContactsSubProcess"
})
public class HireEmployeeBusinessProcessDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Applicant_Reference")
    protected ApplicantObjectType applicantReference;
    @XmlElement(name = "Former_Worker_Reference")
    protected FormerWorkerObjectType formerWorkerReference;
    @XmlElement(name = "Applicant_Data")
    protected CreateApplicantDataType applicantData;
    @XmlElement(name = "Organization_Reference")
    protected SupervisoryOrganizationObjectType organizationReference;
    @XmlElement(name = "Position_Reference")
    protected PositionRestrictionsObjectType positionReference;
    @XmlElement(name = "Headcount_Reference")
    protected HeadcountRestrictionsObjectType headcountReference;
    @XmlElement(name = "Job_Requisition_Reference")
    protected JobRequisitionObjectType jobRequisitionReference;
    @XmlElement(name = "Hire_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar hireDate;
    @XmlElement(name = "Hire_Employee_Event_Data", required = true)
    protected HireEmployeeEventDataType hireEmployeeEventData;
    @XmlElement(name = "Propose_Compensation_for_Hire_Sub_Process")
    protected ProposeCompensationForEmploymentSubBusinessProcessType proposeCompensationForHireSubProcess;
    @XmlElement(name = "Update_ID_Information_Sub_Process")
    protected UpdateIDInformationSubBusinessProcessType updateIDInformationSubProcess;
    @XmlElement(name = "Edit_Government_IDs_Sub_Process")
    protected EditGovernmentIDsSubBusinessProcessType editGovernmentIDsSubProcess;
    @XmlElement(name = "Edit_Passports_and_Visas_Sub_Process")
    protected EditPassportsAndVisasSubBusinessProcessType editPassportsAndVisasSubProcess;
    @XmlElement(name = "Edit_License_Sub_Process")
    protected EditLicensesSubBusinessProcessType editLicenseSubProcess;
    @XmlElement(name = "Edit_Custom_IDs_Sub_Process")
    protected EditCustomIDsSubBusinessProcessType editCustomIDsSubProcess;
    @XmlElement(name = "Edit_Assign_Organization_Sub_Process")
    protected EditAssignPositionOrganizationSubBusinessProcessType editAssignOrganizationSubProcess;
    @XmlElement(name = "Assign_Pay_Group_Sub_Process")
    protected AssignPayGroupSubBusinessProcessType assignPayGroupSubProcess;
    @XmlElement(name = "Review_Payroll_Interface_Sub_Process")
    protected ReviewPayrollInterfaceDataSubBusinessProcessType reviewPayrollInterfaceSubProcess;
    @XmlElement(name = "Request_One_Time_Payment_Sub_Process")
    protected RequestOneTimePaymentSubBusinessProcessType requestOneTimePaymentSubProcess;
    @XmlElement(name = "Request_Stock_Grant_Sub_Process")
    protected RequestStockSubBusinessProcessType requestStockGrantSubProcess;
    @XmlElement(name = "Create_Workday_Account_Sub_Process")
    protected CreateWorkdayAccountSubBusinessProcessType createWorkdayAccountSubProcess;
    @XmlElement(name = "Assign_Matrix_Organization_Sub_Process")
    protected AssignMatrixOrganizationSubBusinessProcessType assignMatrixOrganizationSubProcess;
    @XmlElement(name = "Change_Personal_Information_Sub_Process")
    protected ChangePersonalInformationSubBusinessProcessType changePersonalInformationSubProcess;
    @XmlElement(name = "Create_Provisioning_Event_Sub_Process")
    protected CreateProvisioningEventSubBusinessProcessType createProvisioningEventSubProcess;
    @XmlElement(name = "Create_Benefit_Life_Event_Sub_Process")
    protected CreateBenefitLifeEventSubBusinessProcessType createBenefitLifeEventSubProcess;
    @XmlElement(name = "Maintain_Employee_Contracts_Sub_Business_Process")
    protected MaintainEmployeeContractsSubBusinessProcessType maintainEmployeeContractsSubBusinessProcess;
    @XmlElement(name = "Edit_Service_Dates_Sub_Process")
    protected EditServiceDatesSubBusinessProcessType editServiceDatesSubProcess;
    @XmlElement(name = "Remove_Retiree_Status_Sub_Process")
    protected RemoveRetireeStatusSubBusinessProcessType removeRetireeStatusSubProcess;
    @XmlElement(name = "Request_Budget_Approval_Sub_Business_Process")
    protected RequestBudgetApprovalSubBusinessProcessType requestBudgetApprovalSubBusinessProcess;
    @XmlElement(name = "Check_Position_Budget_Sub_Process")
    protected CheckPositionBudgetSubBusinessProcessType checkPositionBudgetSubProcess;
    @XmlElement(name = "Assign_Costing_Allocation_Sub_Process")
    protected AssignCostingAllocationSubBusinessProcessType assignCostingAllocationSubProcess;
    @XmlElement(name = "Edit_Background_Check_Sub_Process")
    protected EditBackgroundCheckSubBusinessProcessType editBackgroundCheckSubProcess;
    @XmlElement(name = "Add_Academic_Appointment_Sub_Process")
    protected AddAcademicAppointmentSubBusinessProcessType addAcademicAppointmentSubProcess;
    @XmlElement(name = "Assign_Employee_Collective_Agreement_Sub_Process")
    protected AssignEmployeeCollectiveAgreementSubBusinessProcessType assignEmployeeCollectiveAgreementSubProcess;
    @XmlElement(name = "Manage_Employee_Probation_Period_Sub_Business_Process")
    protected ManageProbationPeriodSubBusinessProcessType manageEmployeeProbationPeriodSubBusinessProcess;
    @XmlElement(name = "Emergency_Contacts_Sub_Process")
    protected ChangeEmergencyContactsSubBusinessProcessType emergencyContactsSubProcess;

    /**
     * Gets the value of the applicantReference property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicantObjectType }
     *     
     */
    public ApplicantObjectType getApplicantReference() {
        return applicantReference;
    }

    /**
     * Sets the value of the applicantReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicantObjectType }
     *     
     */
    public void setApplicantReference(ApplicantObjectType value) {
        this.applicantReference = value;
    }

    /**
     * Gets the value of the formerWorkerReference property.
     * 
     * @return
     *     possible object is
     *     {@link FormerWorkerObjectType }
     *     
     */
    public FormerWorkerObjectType getFormerWorkerReference() {
        return formerWorkerReference;
    }

    /**
     * Sets the value of the formerWorkerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormerWorkerObjectType }
     *     
     */
    public void setFormerWorkerReference(FormerWorkerObjectType value) {
        this.formerWorkerReference = value;
    }

    /**
     * Gets the value of the applicantData property.
     * 
     * @return
     *     possible object is
     *     {@link CreateApplicantDataType }
     *     
     */
    public CreateApplicantDataType getApplicantData() {
        return applicantData;
    }

    /**
     * Sets the value of the applicantData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateApplicantDataType }
     *     
     */
    public void setApplicantData(CreateApplicantDataType value) {
        this.applicantData = value;
    }

    /**
     * Gets the value of the organizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getOrganizationReference() {
        return organizationReference;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.organizationReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(PositionRestrictionsObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the headcountReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public HeadcountRestrictionsObjectType getHeadcountReference() {
        return headcountReference;
    }

    /**
     * Sets the value of the headcountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public void setHeadcountReference(HeadcountRestrictionsObjectType value) {
        this.headcountReference = value;
    }

    /**
     * Gets the value of the jobRequisitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public JobRequisitionObjectType getJobRequisitionReference() {
        return jobRequisitionReference;
    }

    /**
     * Sets the value of the jobRequisitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setJobRequisitionReference(JobRequisitionObjectType value) {
        this.jobRequisitionReference = value;
    }

    /**
     * Gets the value of the hireDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getHireDate() {
        return hireDate;
    }

    /**
     * Sets the value of the hireDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setHireDate(XMLGregorianCalendar value) {
        this.hireDate = value;
    }

    /**
     * Gets the value of the hireEmployeeEventData property.
     * 
     * @return
     *     possible object is
     *     {@link HireEmployeeEventDataType }
     *     
     */
    public HireEmployeeEventDataType getHireEmployeeEventData() {
        return hireEmployeeEventData;
    }

    /**
     * Sets the value of the hireEmployeeEventData property.
     * 
     * @param value
     *     allowed object is
     *     {@link HireEmployeeEventDataType }
     *     
     */
    public void setHireEmployeeEventData(HireEmployeeEventDataType value) {
        this.hireEmployeeEventData = value;
    }

    /**
     * Gets the value of the proposeCompensationForHireSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ProposeCompensationForEmploymentSubBusinessProcessType }
     *     
     */
    public ProposeCompensationForEmploymentSubBusinessProcessType getProposeCompensationForHireSubProcess() {
        return proposeCompensationForHireSubProcess;
    }

    /**
     * Sets the value of the proposeCompensationForHireSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposeCompensationForEmploymentSubBusinessProcessType }
     *     
     */
    public void setProposeCompensationForHireSubProcess(ProposeCompensationForEmploymentSubBusinessProcessType value) {
        this.proposeCompensationForHireSubProcess = value;
    }

    /**
     * Gets the value of the updateIDInformationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link UpdateIDInformationSubBusinessProcessType }
     *     
     */
    public UpdateIDInformationSubBusinessProcessType getUpdateIDInformationSubProcess() {
        return updateIDInformationSubProcess;
    }

    /**
     * Sets the value of the updateIDInformationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link UpdateIDInformationSubBusinessProcessType }
     *     
     */
    public void setUpdateIDInformationSubProcess(UpdateIDInformationSubBusinessProcessType value) {
        this.updateIDInformationSubProcess = value;
    }

    /**
     * Gets the value of the editGovernmentIDsSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditGovernmentIDsSubBusinessProcessType }
     *     
     */
    public EditGovernmentIDsSubBusinessProcessType getEditGovernmentIDsSubProcess() {
        return editGovernmentIDsSubProcess;
    }

    /**
     * Sets the value of the editGovernmentIDsSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditGovernmentIDsSubBusinessProcessType }
     *     
     */
    public void setEditGovernmentIDsSubProcess(EditGovernmentIDsSubBusinessProcessType value) {
        this.editGovernmentIDsSubProcess = value;
    }

    /**
     * Gets the value of the editPassportsAndVisasSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditPassportsAndVisasSubBusinessProcessType }
     *     
     */
    public EditPassportsAndVisasSubBusinessProcessType getEditPassportsAndVisasSubProcess() {
        return editPassportsAndVisasSubProcess;
    }

    /**
     * Sets the value of the editPassportsAndVisasSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditPassportsAndVisasSubBusinessProcessType }
     *     
     */
    public void setEditPassportsAndVisasSubProcess(EditPassportsAndVisasSubBusinessProcessType value) {
        this.editPassportsAndVisasSubProcess = value;
    }

    /**
     * Gets the value of the editLicenseSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditLicensesSubBusinessProcessType }
     *     
     */
    public EditLicensesSubBusinessProcessType getEditLicenseSubProcess() {
        return editLicenseSubProcess;
    }

    /**
     * Sets the value of the editLicenseSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditLicensesSubBusinessProcessType }
     *     
     */
    public void setEditLicenseSubProcess(EditLicensesSubBusinessProcessType value) {
        this.editLicenseSubProcess = value;
    }

    /**
     * Gets the value of the editCustomIDsSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditCustomIDsSubBusinessProcessType }
     *     
     */
    public EditCustomIDsSubBusinessProcessType getEditCustomIDsSubProcess() {
        return editCustomIDsSubProcess;
    }

    /**
     * Sets the value of the editCustomIDsSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditCustomIDsSubBusinessProcessType }
     *     
     */
    public void setEditCustomIDsSubProcess(EditCustomIDsSubBusinessProcessType value) {
        this.editCustomIDsSubProcess = value;
    }

    /**
     * Gets the value of the editAssignOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public EditAssignPositionOrganizationSubBusinessProcessType getEditAssignOrganizationSubProcess() {
        return editAssignOrganizationSubProcess;
    }

    /**
     * Sets the value of the editAssignOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public void setEditAssignOrganizationSubProcess(EditAssignPositionOrganizationSubBusinessProcessType value) {
        this.editAssignOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the assignPayGroupSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public AssignPayGroupSubBusinessProcessType getAssignPayGroupSubProcess() {
        return assignPayGroupSubProcess;
    }

    /**
     * Sets the value of the assignPayGroupSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public void setAssignPayGroupSubProcess(AssignPayGroupSubBusinessProcessType value) {
        this.assignPayGroupSubProcess = value;
    }

    /**
     * Gets the value of the reviewPayrollInterfaceSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ReviewPayrollInterfaceDataSubBusinessProcessType }
     *     
     */
    public ReviewPayrollInterfaceDataSubBusinessProcessType getReviewPayrollInterfaceSubProcess() {
        return reviewPayrollInterfaceSubProcess;
    }

    /**
     * Sets the value of the reviewPayrollInterfaceSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReviewPayrollInterfaceDataSubBusinessProcessType }
     *     
     */
    public void setReviewPayrollInterfaceSubProcess(ReviewPayrollInterfaceDataSubBusinessProcessType value) {
        this.reviewPayrollInterfaceSubProcess = value;
    }

    /**
     * Gets the value of the requestOneTimePaymentSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestOneTimePaymentSubBusinessProcessType }
     *     
     */
    public RequestOneTimePaymentSubBusinessProcessType getRequestOneTimePaymentSubProcess() {
        return requestOneTimePaymentSubProcess;
    }

    /**
     * Sets the value of the requestOneTimePaymentSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestOneTimePaymentSubBusinessProcessType }
     *     
     */
    public void setRequestOneTimePaymentSubProcess(RequestOneTimePaymentSubBusinessProcessType value) {
        this.requestOneTimePaymentSubProcess = value;
    }

    /**
     * Gets the value of the requestStockGrantSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestStockSubBusinessProcessType }
     *     
     */
    public RequestStockSubBusinessProcessType getRequestStockGrantSubProcess() {
        return requestStockGrantSubProcess;
    }

    /**
     * Sets the value of the requestStockGrantSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestStockSubBusinessProcessType }
     *     
     */
    public void setRequestStockGrantSubProcess(RequestStockSubBusinessProcessType value) {
        this.requestStockGrantSubProcess = value;
    }

    /**
     * Gets the value of the createWorkdayAccountSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CreateWorkdayAccountSubBusinessProcessType }
     *     
     */
    public CreateWorkdayAccountSubBusinessProcessType getCreateWorkdayAccountSubProcess() {
        return createWorkdayAccountSubProcess;
    }

    /**
     * Sets the value of the createWorkdayAccountSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateWorkdayAccountSubBusinessProcessType }
     *     
     */
    public void setCreateWorkdayAccountSubProcess(CreateWorkdayAccountSubBusinessProcessType value) {
        this.createWorkdayAccountSubProcess = value;
    }

    /**
     * Gets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public AssignMatrixOrganizationSubBusinessProcessType getAssignMatrixOrganizationSubProcess() {
        return assignMatrixOrganizationSubProcess;
    }

    /**
     * Sets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public void setAssignMatrixOrganizationSubProcess(AssignMatrixOrganizationSubBusinessProcessType value) {
        this.assignMatrixOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the changePersonalInformationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public ChangePersonalInformationSubBusinessProcessType getChangePersonalInformationSubProcess() {
        return changePersonalInformationSubProcess;
    }

    /**
     * Sets the value of the changePersonalInformationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public void setChangePersonalInformationSubProcess(ChangePersonalInformationSubBusinessProcessType value) {
        this.changePersonalInformationSubProcess = value;
    }

    /**
     * Gets the value of the createProvisioningEventSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CreateProvisioningEventSubBusinessProcessType }
     *     
     */
    public CreateProvisioningEventSubBusinessProcessType getCreateProvisioningEventSubProcess() {
        return createProvisioningEventSubProcess;
    }

    /**
     * Sets the value of the createProvisioningEventSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateProvisioningEventSubBusinessProcessType }
     *     
     */
    public void setCreateProvisioningEventSubProcess(CreateProvisioningEventSubBusinessProcessType value) {
        this.createProvisioningEventSubProcess = value;
    }

    /**
     * Gets the value of the createBenefitLifeEventSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CreateBenefitLifeEventSubBusinessProcessType }
     *     
     */
    public CreateBenefitLifeEventSubBusinessProcessType getCreateBenefitLifeEventSubProcess() {
        return createBenefitLifeEventSubProcess;
    }

    /**
     * Sets the value of the createBenefitLifeEventSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateBenefitLifeEventSubBusinessProcessType }
     *     
     */
    public void setCreateBenefitLifeEventSubProcess(CreateBenefitLifeEventSubBusinessProcessType value) {
        this.createBenefitLifeEventSubProcess = value;
    }

    /**
     * Gets the value of the maintainEmployeeContractsSubBusinessProcess property.
     * 
     * @return
     *     possible object is
     *     {@link MaintainEmployeeContractsSubBusinessProcessType }
     *     
     */
    public MaintainEmployeeContractsSubBusinessProcessType getMaintainEmployeeContractsSubBusinessProcess() {
        return maintainEmployeeContractsSubBusinessProcess;
    }

    /**
     * Sets the value of the maintainEmployeeContractsSubBusinessProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaintainEmployeeContractsSubBusinessProcessType }
     *     
     */
    public void setMaintainEmployeeContractsSubBusinessProcess(MaintainEmployeeContractsSubBusinessProcessType value) {
        this.maintainEmployeeContractsSubBusinessProcess = value;
    }

    /**
     * Gets the value of the editServiceDatesSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public EditServiceDatesSubBusinessProcessType getEditServiceDatesSubProcess() {
        return editServiceDatesSubProcess;
    }

    /**
     * Sets the value of the editServiceDatesSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public void setEditServiceDatesSubProcess(EditServiceDatesSubBusinessProcessType value) {
        this.editServiceDatesSubProcess = value;
    }

    /**
     * Gets the value of the removeRetireeStatusSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public RemoveRetireeStatusSubBusinessProcessType getRemoveRetireeStatusSubProcess() {
        return removeRetireeStatusSubProcess;
    }

    /**
     * Sets the value of the removeRetireeStatusSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public void setRemoveRetireeStatusSubProcess(RemoveRetireeStatusSubBusinessProcessType value) {
        this.removeRetireeStatusSubProcess = value;
    }

    /**
     * Gets the value of the requestBudgetApprovalSubBusinessProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public RequestBudgetApprovalSubBusinessProcessType getRequestBudgetApprovalSubBusinessProcess() {
        return requestBudgetApprovalSubBusinessProcess;
    }

    /**
     * Sets the value of the requestBudgetApprovalSubBusinessProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public void setRequestBudgetApprovalSubBusinessProcess(RequestBudgetApprovalSubBusinessProcessType value) {
        this.requestBudgetApprovalSubBusinessProcess = value;
    }

    /**
     * Gets the value of the checkPositionBudgetSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public CheckPositionBudgetSubBusinessProcessType getCheckPositionBudgetSubProcess() {
        return checkPositionBudgetSubProcess;
    }

    /**
     * Sets the value of the checkPositionBudgetSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public void setCheckPositionBudgetSubProcess(CheckPositionBudgetSubBusinessProcessType value) {
        this.checkPositionBudgetSubProcess = value;
    }

    /**
     * Gets the value of the assignCostingAllocationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public AssignCostingAllocationSubBusinessProcessType getAssignCostingAllocationSubProcess() {
        return assignCostingAllocationSubProcess;
    }

    /**
     * Sets the value of the assignCostingAllocationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public void setAssignCostingAllocationSubProcess(AssignCostingAllocationSubBusinessProcessType value) {
        this.assignCostingAllocationSubProcess = value;
    }

    /**
     * Gets the value of the editBackgroundCheckSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditBackgroundCheckSubBusinessProcessType }
     *     
     */
    public EditBackgroundCheckSubBusinessProcessType getEditBackgroundCheckSubProcess() {
        return editBackgroundCheckSubProcess;
    }

    /**
     * Sets the value of the editBackgroundCheckSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditBackgroundCheckSubBusinessProcessType }
     *     
     */
    public void setEditBackgroundCheckSubProcess(EditBackgroundCheckSubBusinessProcessType value) {
        this.editBackgroundCheckSubProcess = value;
    }

    /**
     * Gets the value of the addAcademicAppointmentSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AddAcademicAppointmentSubBusinessProcessType }
     *     
     */
    public AddAcademicAppointmentSubBusinessProcessType getAddAcademicAppointmentSubProcess() {
        return addAcademicAppointmentSubProcess;
    }

    /**
     * Sets the value of the addAcademicAppointmentSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddAcademicAppointmentSubBusinessProcessType }
     *     
     */
    public void setAddAcademicAppointmentSubProcess(AddAcademicAppointmentSubBusinessProcessType value) {
        this.addAcademicAppointmentSubProcess = value;
    }

    /**
     * Gets the value of the assignEmployeeCollectiveAgreementSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignEmployeeCollectiveAgreementSubBusinessProcessType }
     *     
     */
    public AssignEmployeeCollectiveAgreementSubBusinessProcessType getAssignEmployeeCollectiveAgreementSubProcess() {
        return assignEmployeeCollectiveAgreementSubProcess;
    }

    /**
     * Sets the value of the assignEmployeeCollectiveAgreementSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignEmployeeCollectiveAgreementSubBusinessProcessType }
     *     
     */
    public void setAssignEmployeeCollectiveAgreementSubProcess(AssignEmployeeCollectiveAgreementSubBusinessProcessType value) {
        this.assignEmployeeCollectiveAgreementSubProcess = value;
    }

    /**
     * Gets the value of the manageEmployeeProbationPeriodSubBusinessProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ManageProbationPeriodSubBusinessProcessType }
     *     
     */
    public ManageProbationPeriodSubBusinessProcessType getManageEmployeeProbationPeriodSubBusinessProcess() {
        return manageEmployeeProbationPeriodSubBusinessProcess;
    }

    /**
     * Sets the value of the manageEmployeeProbationPeriodSubBusinessProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ManageProbationPeriodSubBusinessProcessType }
     *     
     */
    public void setManageEmployeeProbationPeriodSubBusinessProcess(ManageProbationPeriodSubBusinessProcessType value) {
        this.manageEmployeeProbationPeriodSubBusinessProcess = value;
    }

    /**
     * Gets the value of the emergencyContactsSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ChangeEmergencyContactsSubBusinessProcessType }
     *     
     */
    public ChangeEmergencyContactsSubBusinessProcessType getEmergencyContactsSubProcess() {
        return emergencyContactsSubProcess;
    }

    /**
     * Sets the value of the emergencyContactsSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChangeEmergencyContactsSubBusinessProcessType }
     *     
     */
    public void setEmergencyContactsSubProcess(ChangeEmergencyContactsSubBusinessProcessType value) {
        this.emergencyContactsSubProcess = value;
    }

}
