
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The response group allows for the response data to be tailored to only included elements that the user is looking for.  If no response group is provided in the request the only the following elements will be returned:  Headcount Reference, Supervisory Org Reference and Headcount Details Data
 * 
 * <p>Java class for Headcount_Response_GroupType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Headcount_Response_GroupType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Include_Reference" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Headcount_Details_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Hiring_Restrictions_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Default_Compensation_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Default_Organization_Assignment_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Include_Worker_For_Filled_Positions_Data" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Headcount_Response_GroupType", propOrder = {
    "includeReference",
    "includeHeadcountDetailsData",
    "includeHiringRestrictionsData",
    "includeDefaultCompensationData",
    "includeDefaultOrganizationAssignmentData",
    "includeWorkerForFilledPositionsData"
})
public class HeadcountResponseGroupType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Include_Reference")
    protected Boolean includeReference;
    @XmlElement(name = "Include_Headcount_Details_Data")
    protected Boolean includeHeadcountDetailsData;
    @XmlElement(name = "Include_Hiring_Restrictions_Data")
    protected Boolean includeHiringRestrictionsData;
    @XmlElement(name = "Include_Default_Compensation_Data")
    protected Boolean includeDefaultCompensationData;
    @XmlElement(name = "Include_Default_Organization_Assignment_Data")
    protected Boolean includeDefaultOrganizationAssignmentData;
    @XmlElement(name = "Include_Worker_For_Filled_Positions_Data")
    protected Boolean includeWorkerForFilledPositionsData;

    /**
     * Gets the value of the includeReference property.
     * This getter has been renamed from isIncludeReference() to getIncludeReference() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeReference() {
        return includeReference;
    }

    /**
     * Sets the value of the includeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeReference(Boolean value) {
        this.includeReference = value;
    }

    /**
     * Gets the value of the includeHeadcountDetailsData property.
     * This getter has been renamed from isIncludeHeadcountDetailsData() to getIncludeHeadcountDetailsData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeHeadcountDetailsData() {
        return includeHeadcountDetailsData;
    }

    /**
     * Sets the value of the includeHeadcountDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeHeadcountDetailsData(Boolean value) {
        this.includeHeadcountDetailsData = value;
    }

    /**
     * Gets the value of the includeHiringRestrictionsData property.
     * This getter has been renamed from isIncludeHiringRestrictionsData() to getIncludeHiringRestrictionsData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeHiringRestrictionsData() {
        return includeHiringRestrictionsData;
    }

    /**
     * Sets the value of the includeHiringRestrictionsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeHiringRestrictionsData(Boolean value) {
        this.includeHiringRestrictionsData = value;
    }

    /**
     * Gets the value of the includeDefaultCompensationData property.
     * This getter has been renamed from isIncludeDefaultCompensationData() to getIncludeDefaultCompensationData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeDefaultCompensationData() {
        return includeDefaultCompensationData;
    }

    /**
     * Sets the value of the includeDefaultCompensationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDefaultCompensationData(Boolean value) {
        this.includeDefaultCompensationData = value;
    }

    /**
     * Gets the value of the includeDefaultOrganizationAssignmentData property.
     * This getter has been renamed from isIncludeDefaultOrganizationAssignmentData() to getIncludeDefaultOrganizationAssignmentData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeDefaultOrganizationAssignmentData() {
        return includeDefaultOrganizationAssignmentData;
    }

    /**
     * Sets the value of the includeDefaultOrganizationAssignmentData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeDefaultOrganizationAssignmentData(Boolean value) {
        this.includeDefaultOrganizationAssignmentData = value;
    }

    /**
     * Gets the value of the includeWorkerForFilledPositionsData property.
     * This getter has been renamed from isIncludeWorkerForFilledPositionsData() to getIncludeWorkerForFilledPositionsData() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getIncludeWorkerForFilledPositionsData() {
        return includeWorkerForFilledPositionsData;
    }

    /**
     * Sets the value of the includeWorkerForFilledPositionsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeWorkerForFilledPositionsData(Boolean value) {
        this.includeWorkerForFilledPositionsData = value;
    }

}
