
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Utilize the Request Criteria element to search the transaction log for specific instance(s) of a Headcount
 * 
 * <p>Java class for Headcount_Request_CriteriaType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Headcount_Request_CriteriaType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Transaction_Log_Criteria_Data" type="{urn:com.workday/bsvc}Transaction_Log_CriteriaType" maxOccurs="unbounded" minOccurs="0"/>
 *           &lt;element name="Supervisory_Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Headcount_Request_CriteriaType", propOrder = {
    "transactionLogCriteriaData",
    "supervisoryOrganizationReference"
})
public class HeadcountRequestCriteriaType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Transaction_Log_Criteria_Data")
    protected List<TransactionLogCriteriaType> transactionLogCriteriaData;
    @XmlElement(name = "Supervisory_Organization_Reference")
    protected SupervisoryOrganizationObjectType supervisoryOrganizationReference;

    /**
     * Gets the value of the transactionLogCriteriaData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transactionLogCriteriaData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTransactionLogCriteriaData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransactionLogCriteriaType }
     * 
     * 
     */
    public List<TransactionLogCriteriaType> getTransactionLogCriteriaData() {
        if (transactionLogCriteriaData == null) {
            transactionLogCriteriaData = new ArrayList<TransactionLogCriteriaType>();
        }
        return this.transactionLogCriteriaData;
    }

    /**
     * Gets the value of the supervisoryOrganizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getSupervisoryOrganizationReference() {
        return supervisoryOrganizationReference;
    }

    /**
     * Sets the value of the supervisoryOrganizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setSupervisoryOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.supervisoryOrganizationReference = value;
    }

    /**
     * Sets the value of the transactionLogCriteriaData property.
     * 
     * @param transactionLogCriteriaData
     *     allowed object is
     *     {@link TransactionLogCriteriaType }
     *     
     */
    public void setTransactionLogCriteriaData(List<TransactionLogCriteriaType> transactionLogCriteriaData) {
        this.transactionLogCriteriaData = transactionLogCriteriaData;
    }

}
