
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Container for the Personal Information data.
 * 
 * <p>Java class for Generic_Personal_Information_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Generic_Personal_Information_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Gender_Reference" type="{urn:com.workday/bsvc}GenderObjectType" minOccurs="0"/>
 *         &lt;element name="Date_of_Birth" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Date_of_Death" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Birth_Country_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Birth_Region_Reference" type="{urn:com.workday/bsvc}Country_RegionObjectType" minOccurs="0"/>
 *         &lt;element name="City_of_Birth" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Marital_Status_Reference" type="{urn:com.workday/bsvc}Marital_StatusObjectType" minOccurs="0"/>
 *         &lt;element name="Marital_Status_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Ethnicity_Reference" type="{urn:com.workday/bsvc}EthnicityObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Hispanic_or_Latino" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Religion_Reference" type="{urn:com.workday/bsvc}ReligionObjectType" minOccurs="0"/>
 *         &lt;element name="Citizenship_Reference" type="{urn:com.workday/bsvc}Citizenship_StatusObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Nationality_Reference" type="{urn:com.workday/bsvc}CountryObjectType" minOccurs="0"/>
 *         &lt;element name="Hukou_Region_Reference" type="{urn:com.workday/bsvc}Country_RegionObjectType" minOccurs="0"/>
 *         &lt;element name="Hukou_Subregion_Reference" type="{urn:com.workday/bsvc}Country_SubregionObjectType" minOccurs="0"/>
 *         &lt;element name="Hukou_Locality" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Hukou_Postal_Code" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Hukou_Type_Reference" type="{urn:com.workday/bsvc}Hukou_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Native_Region_Reference" type="{urn:com.workday/bsvc}Country_RegionObjectType" minOccurs="0"/>
 *         &lt;element name="Personnel_File_Agency" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Political_Affiliation_Reference" type="{urn:com.workday/bsvc}Political_AffiliationObjectType" minOccurs="0"/>
 *         &lt;element name="Social_Benefits_Locality_Reference" type="{urn:com.workday/bsvc}Social_Benefits_LocalityObjectType" minOccurs="0"/>
 *         &lt;element name="Last_Medical_Exam_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Last_Medical_Exam_Valid_To" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Medical_Exam_Notes" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Disability_Information_Data" type="{urn:com.workday/bsvc}Generic_Disability_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Military_Information_Data" type="{urn:com.workday/bsvc}Generic_Military_Information_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Uses_Tobacco" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Generic_Personal_Information_DataType", propOrder = {
    "genderReference",
    "dateOfBirth",
    "dateOfDeath",
    "birthCountryReference",
    "birthRegionReference",
    "cityOfBirth",
    "maritalStatusReference",
    "maritalStatusDate",
    "ethnicityReference",
    "hispanicOrLatino",
    "religionReference",
    "citizenshipReference",
    "nationalityReference",
    "hukouRegionReference",
    "hukouSubregionReference",
    "hukouLocality",
    "hukouPostalCode",
    "hukouTypeReference",
    "nativeRegionReference",
    "personnelFileAgency",
    "politicalAffiliationReference",
    "socialBenefitsLocalityReference",
    "lastMedicalExamDate",
    "lastMedicalExamValidTo",
    "medicalExamNotes",
    "disabilityInformationData",
    "militaryInformationData",
    "usesTobacco"
})
public class GenericPersonalInformationDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Gender_Reference")
    protected GenderObjectType genderReference;
    @XmlElement(name = "Date_of_Birth")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar dateOfBirth;
    @XmlElement(name = "Date_of_Death")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar dateOfDeath;
    @XmlElement(name = "Birth_Country_Reference")
    protected CountryObjectType birthCountryReference;
    @XmlElement(name = "Birth_Region_Reference")
    protected CountryRegionObjectType birthRegionReference;
    @XmlElement(name = "City_of_Birth")
    protected String cityOfBirth;
    @XmlElement(name = "Marital_Status_Reference")
    protected MaritalStatusObjectType maritalStatusReference;
    @XmlElement(name = "Marital_Status_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar maritalStatusDate;
    @XmlElement(name = "Ethnicity_Reference")
    protected List<EthnicityObjectType> ethnicityReference;
    @XmlElement(name = "Hispanic_or_Latino")
    protected Boolean hispanicOrLatino;
    @XmlElement(name = "Religion_Reference")
    protected ReligionObjectType religionReference;
    @XmlElement(name = "Citizenship_Reference")
    protected List<CitizenshipStatusObjectType> citizenshipReference;
    @XmlElement(name = "Nationality_Reference")
    protected CountryObjectType nationalityReference;
    @XmlElement(name = "Hukou_Region_Reference")
    protected CountryRegionObjectType hukouRegionReference;
    @XmlElement(name = "Hukou_Subregion_Reference")
    protected CountrySubregionObjectType hukouSubregionReference;
    @XmlElement(name = "Hukou_Locality")
    protected String hukouLocality;
    @XmlElement(name = "Hukou_Postal_Code")
    protected String hukouPostalCode;
    @XmlElement(name = "Hukou_Type_Reference")
    protected HukouTypeObjectType hukouTypeReference;
    @XmlElement(name = "Native_Region_Reference")
    protected CountryRegionObjectType nativeRegionReference;
    @XmlElement(name = "Personnel_File_Agency")
    protected String personnelFileAgency;
    @XmlElement(name = "Political_Affiliation_Reference")
    protected PoliticalAffiliationObjectType politicalAffiliationReference;
    @XmlElement(name = "Social_Benefits_Locality_Reference")
    protected SocialBenefitsLocalityObjectType socialBenefitsLocalityReference;
    @XmlElement(name = "Last_Medical_Exam_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar lastMedicalExamDate;
    @XmlElement(name = "Last_Medical_Exam_Valid_To")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar lastMedicalExamValidTo;
    @XmlElement(name = "Medical_Exam_Notes")
    protected String medicalExamNotes;
    @XmlElement(name = "Disability_Information_Data")
    protected List<GenericDisabilityInformationDataType> disabilityInformationData;
    @XmlElement(name = "Military_Information_Data")
    protected List<GenericMilitaryInformationDataType> militaryInformationData;
    @XmlElement(name = "Uses_Tobacco")
    protected Boolean usesTobacco;

    /**
     * Gets the value of the genderReference property.
     * 
     * @return
     *     possible object is
     *     {@link GenderObjectType }
     *     
     */
    public GenderObjectType getGenderReference() {
        return genderReference;
    }

    /**
     * Sets the value of the genderReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GenderObjectType }
     *     
     */
    public void setGenderReference(GenderObjectType value) {
        this.genderReference = value;
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setDateOfBirth(XMLGregorianCalendar value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the dateOfDeath property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getDateOfDeath() {
        return dateOfDeath;
    }

    /**
     * Sets the value of the dateOfDeath property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setDateOfDeath(XMLGregorianCalendar value) {
        this.dateOfDeath = value;
    }

    /**
     * Gets the value of the birthCountryReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getBirthCountryReference() {
        return birthCountryReference;
    }

    /**
     * Sets the value of the birthCountryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setBirthCountryReference(CountryObjectType value) {
        this.birthCountryReference = value;
    }

    /**
     * Gets the value of the birthRegionReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public CountryRegionObjectType getBirthRegionReference() {
        return birthRegionReference;
    }

    /**
     * Sets the value of the birthRegionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public void setBirthRegionReference(CountryRegionObjectType value) {
        this.birthRegionReference = value;
    }

    /**
     * Gets the value of the cityOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCityOfBirth() {
        return cityOfBirth;
    }

    /**
     * Sets the value of the cityOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCityOfBirth(String value) {
        this.cityOfBirth = value;
    }

    /**
     * Gets the value of the maritalStatusReference property.
     * 
     * @return
     *     possible object is
     *     {@link MaritalStatusObjectType }
     *     
     */
    public MaritalStatusObjectType getMaritalStatusReference() {
        return maritalStatusReference;
    }

    /**
     * Sets the value of the maritalStatusReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaritalStatusObjectType }
     *     
     */
    public void setMaritalStatusReference(MaritalStatusObjectType value) {
        this.maritalStatusReference = value;
    }

    /**
     * Gets the value of the maritalStatusDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getMaritalStatusDate() {
        return maritalStatusDate;
    }

    /**
     * Sets the value of the maritalStatusDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setMaritalStatusDate(XMLGregorianCalendar value) {
        this.maritalStatusDate = value;
    }

    /**
     * Gets the value of the ethnicityReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ethnicityReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEthnicityReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EthnicityObjectType }
     * 
     * 
     */
    public List<EthnicityObjectType> getEthnicityReference() {
        if (ethnicityReference == null) {
            ethnicityReference = new ArrayList<EthnicityObjectType>();
        }
        return this.ethnicityReference;
    }

    /**
     * Gets the value of the hispanicOrLatino property.
     * This getter has been renamed from isHispanicOrLatino() to getHispanicOrLatino() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getHispanicOrLatino() {
        return hispanicOrLatino;
    }

    /**
     * Sets the value of the hispanicOrLatino property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHispanicOrLatino(Boolean value) {
        this.hispanicOrLatino = value;
    }

    /**
     * Gets the value of the religionReference property.
     * 
     * @return
     *     possible object is
     *     {@link ReligionObjectType }
     *     
     */
    public ReligionObjectType getReligionReference() {
        return religionReference;
    }

    /**
     * Sets the value of the religionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReligionObjectType }
     *     
     */
    public void setReligionReference(ReligionObjectType value) {
        this.religionReference = value;
    }

    /**
     * Gets the value of the citizenshipReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the citizenshipReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCitizenshipReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CitizenshipStatusObjectType }
     * 
     * 
     */
    public List<CitizenshipStatusObjectType> getCitizenshipReference() {
        if (citizenshipReference == null) {
            citizenshipReference = new ArrayList<CitizenshipStatusObjectType>();
        }
        return this.citizenshipReference;
    }

    /**
     * Gets the value of the nationalityReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryObjectType }
     *     
     */
    public CountryObjectType getNationalityReference() {
        return nationalityReference;
    }

    /**
     * Sets the value of the nationalityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryObjectType }
     *     
     */
    public void setNationalityReference(CountryObjectType value) {
        this.nationalityReference = value;
    }

    /**
     * Gets the value of the hukouRegionReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public CountryRegionObjectType getHukouRegionReference() {
        return hukouRegionReference;
    }

    /**
     * Sets the value of the hukouRegionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public void setHukouRegionReference(CountryRegionObjectType value) {
        this.hukouRegionReference = value;
    }

    /**
     * Gets the value of the hukouSubregionReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountrySubregionObjectType }
     *     
     */
    public CountrySubregionObjectType getHukouSubregionReference() {
        return hukouSubregionReference;
    }

    /**
     * Sets the value of the hukouSubregionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountrySubregionObjectType }
     *     
     */
    public void setHukouSubregionReference(CountrySubregionObjectType value) {
        this.hukouSubregionReference = value;
    }

    /**
     * Gets the value of the hukouLocality property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHukouLocality() {
        return hukouLocality;
    }

    /**
     * Sets the value of the hukouLocality property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHukouLocality(String value) {
        this.hukouLocality = value;
    }

    /**
     * Gets the value of the hukouPostalCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHukouPostalCode() {
        return hukouPostalCode;
    }

    /**
     * Sets the value of the hukouPostalCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHukouPostalCode(String value) {
        this.hukouPostalCode = value;
    }

    /**
     * Gets the value of the hukouTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link HukouTypeObjectType }
     *     
     */
    public HukouTypeObjectType getHukouTypeReference() {
        return hukouTypeReference;
    }

    /**
     * Sets the value of the hukouTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HukouTypeObjectType }
     *     
     */
    public void setHukouTypeReference(HukouTypeObjectType value) {
        this.hukouTypeReference = value;
    }

    /**
     * Gets the value of the nativeRegionReference property.
     * 
     * @return
     *     possible object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public CountryRegionObjectType getNativeRegionReference() {
        return nativeRegionReference;
    }

    /**
     * Sets the value of the nativeRegionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryRegionObjectType }
     *     
     */
    public void setNativeRegionReference(CountryRegionObjectType value) {
        this.nativeRegionReference = value;
    }

    /**
     * Gets the value of the personnelFileAgency property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPersonnelFileAgency() {
        return personnelFileAgency;
    }

    /**
     * Sets the value of the personnelFileAgency property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPersonnelFileAgency(String value) {
        this.personnelFileAgency = value;
    }

    /**
     * Gets the value of the politicalAffiliationReference property.
     * 
     * @return
     *     possible object is
     *     {@link PoliticalAffiliationObjectType }
     *     
     */
    public PoliticalAffiliationObjectType getPoliticalAffiliationReference() {
        return politicalAffiliationReference;
    }

    /**
     * Sets the value of the politicalAffiliationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PoliticalAffiliationObjectType }
     *     
     */
    public void setPoliticalAffiliationReference(PoliticalAffiliationObjectType value) {
        this.politicalAffiliationReference = value;
    }

    /**
     * Gets the value of the socialBenefitsLocalityReference property.
     * 
     * @return
     *     possible object is
     *     {@link SocialBenefitsLocalityObjectType }
     *     
     */
    public SocialBenefitsLocalityObjectType getSocialBenefitsLocalityReference() {
        return socialBenefitsLocalityReference;
    }

    /**
     * Sets the value of the socialBenefitsLocalityReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SocialBenefitsLocalityObjectType }
     *     
     */
    public void setSocialBenefitsLocalityReference(SocialBenefitsLocalityObjectType value) {
        this.socialBenefitsLocalityReference = value;
    }

    /**
     * Gets the value of the lastMedicalExamDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastMedicalExamDate() {
        return lastMedicalExamDate;
    }

    /**
     * Sets the value of the lastMedicalExamDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastMedicalExamDate(XMLGregorianCalendar value) {
        this.lastMedicalExamDate = value;
    }

    /**
     * Gets the value of the lastMedicalExamValidTo property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastMedicalExamValidTo() {
        return lastMedicalExamValidTo;
    }

    /**
     * Sets the value of the lastMedicalExamValidTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastMedicalExamValidTo(XMLGregorianCalendar value) {
        this.lastMedicalExamValidTo = value;
    }

    /**
     * Gets the value of the medicalExamNotes property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMedicalExamNotes() {
        return medicalExamNotes;
    }

    /**
     * Sets the value of the medicalExamNotes property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMedicalExamNotes(String value) {
        this.medicalExamNotes = value;
    }

    /**
     * Gets the value of the disabilityInformationData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the disabilityInformationData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDisabilityInformationData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GenericDisabilityInformationDataType }
     * 
     * 
     */
    public List<GenericDisabilityInformationDataType> getDisabilityInformationData() {
        if (disabilityInformationData == null) {
            disabilityInformationData = new ArrayList<GenericDisabilityInformationDataType>();
        }
        return this.disabilityInformationData;
    }

    /**
     * Gets the value of the militaryInformationData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the militaryInformationData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMilitaryInformationData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GenericMilitaryInformationDataType }
     * 
     * 
     */
    public List<GenericMilitaryInformationDataType> getMilitaryInformationData() {
        if (militaryInformationData == null) {
            militaryInformationData = new ArrayList<GenericMilitaryInformationDataType>();
        }
        return this.militaryInformationData;
    }

    /**
     * Gets the value of the usesTobacco property.
     * This getter has been renamed from isUsesTobacco() to getUsesTobacco() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getUsesTobacco() {
        return usesTobacco;
    }

    /**
     * Sets the value of the usesTobacco property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUsesTobacco(Boolean value) {
        this.usesTobacco = value;
    }

    /**
     * Sets the value of the ethnicityReference property.
     * 
     * @param ethnicityReference
     *     allowed object is
     *     {@link EthnicityObjectType }
     *     
     */
    public void setEthnicityReference(List<EthnicityObjectType> ethnicityReference) {
        this.ethnicityReference = ethnicityReference;
    }

    /**
     * Sets the value of the citizenshipReference property.
     * 
     * @param citizenshipReference
     *     allowed object is
     *     {@link CitizenshipStatusObjectType }
     *     
     */
    public void setCitizenshipReference(List<CitizenshipStatusObjectType> citizenshipReference) {
        this.citizenshipReference = citizenshipReference;
    }

    /**
     * Sets the value of the disabilityInformationData property.
     * 
     * @param disabilityInformationData
     *     allowed object is
     *     {@link GenericDisabilityInformationDataType }
     *     
     */
    public void setDisabilityInformationData(List<GenericDisabilityInformationDataType> disabilityInformationData) {
        this.disabilityInformationData = disabilityInformationData;
    }

    /**
     * Sets the value of the militaryInformationData property.
     * 
     * @param militaryInformationData
     *     allowed object is
     *     {@link GenericMilitaryInformationDataType }
     *     
     */
    public void setMilitaryInformationData(List<GenericMilitaryInformationDataType> militaryInformationData) {
        this.militaryInformationData = militaryInformationData;
    }

}
