
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains information for a filled position.
 * If this Position has already been filled, this element can be used to change this data. If the position has not been entered, an error will be returned if this element is supplied.
 * 
 * <p>Java class for Filled_Position_Edit_Details_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Filled_Position_Edit_Details_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Employee_Type_Reference" type="{urn:com.workday/bsvc}Employee_TypeObjectType" minOccurs="0"/>
 *           &lt;element name="Contingent_Worker_Type_Reference" type="{urn:com.workday/bsvc}Contingent_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Position_Details_Sub_Data" type="{urn:com.workday/bsvc}Position_Details_Sub_DataType" minOccurs="0"/>
 *         &lt;element name="End_Employment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Contract_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Contract_Details_Data" type="{urn:com.workday/bsvc}Contract_Details_Sub_DataType" minOccurs="0"/>
 *         &lt;element name="Exclude_from_Headcount" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Expected_Assignment_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="International_Assignment_Type_Reference" type="{urn:com.workday/bsvc}International_Assignment_TypeObjectType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Filled_Position_Edit_Details_DataType", propOrder = {
    "positionID",
    "employeeTypeReference",
    "contingentWorkerTypeReference",
    "positionDetailsSubData",
    "endEmploymentDate",
    "contractEndDate",
    "contractDetailsData",
    "excludeFromHeadcount",
    "expectedAssignmentEndDate",
    "internationalAssignmentTypeReference"
})
public class FilledPositionEditDetailsDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_ID")
    protected String positionID;
    @XmlElement(name = "Employee_Type_Reference")
    protected EmployeeTypeObjectType employeeTypeReference;
    @XmlElement(name = "Contingent_Worker_Type_Reference")
    protected ContingentWorkerTypeObjectType contingentWorkerTypeReference;
    @XmlElement(name = "Position_Details_Sub_Data")
    protected PositionDetailsSubDataType positionDetailsSubData;
    @XmlElement(name = "End_Employment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar endEmploymentDate;
    @XmlElement(name = "Contract_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar contractEndDate;
    @XmlElement(name = "Contract_Details_Data")
    protected ContractDetailsSubDataType contractDetailsData;
    @XmlElement(name = "Exclude_from_Headcount")
    protected Boolean excludeFromHeadcount;
    @XmlElement(name = "Expected_Assignment_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expectedAssignmentEndDate;
    @XmlElement(name = "International_Assignment_Type_Reference")
    protected InternationalAssignmentTypeObjectType internationalAssignmentTypeReference;

    /**
     * Gets the value of the positionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionID() {
        return positionID;
    }

    /**
     * Sets the value of the positionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionID(String value) {
        this.positionID = value;
    }

    /**
     * Gets the value of the employeeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeTypeObjectType }
     *     
     */
    public EmployeeTypeObjectType getEmployeeTypeReference() {
        return employeeTypeReference;
    }

    /**
     * Sets the value of the employeeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeTypeObjectType }
     *     
     */
    public void setEmployeeTypeReference(EmployeeTypeObjectType value) {
        this.employeeTypeReference = value;
    }

    /**
     * Gets the value of the contingentWorkerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public ContingentWorkerTypeObjectType getContingentWorkerTypeReference() {
        return contingentWorkerTypeReference;
    }

    /**
     * Sets the value of the contingentWorkerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public void setContingentWorkerTypeReference(ContingentWorkerTypeObjectType value) {
        this.contingentWorkerTypeReference = value;
    }

    /**
     * Gets the value of the positionDetailsSubData property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public PositionDetailsSubDataType getPositionDetailsSubData() {
        return positionDetailsSubData;
    }

    /**
     * Sets the value of the positionDetailsSubData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public void setPositionDetailsSubData(PositionDetailsSubDataType value) {
        this.positionDetailsSubData = value;
    }

    /**
     * Gets the value of the endEmploymentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEndEmploymentDate() {
        return endEmploymentDate;
    }

    /**
     * Sets the value of the endEmploymentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndEmploymentDate(XMLGregorianCalendar value) {
        this.endEmploymentDate = value;
    }

    /**
     * Gets the value of the contractEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContractEndDate() {
        return contractEndDate;
    }

    /**
     * Sets the value of the contractEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContractEndDate(XMLGregorianCalendar value) {
        this.contractEndDate = value;
    }

    /**
     * Gets the value of the contractDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link ContractDetailsSubDataType }
     *     
     */
    public ContractDetailsSubDataType getContractDetailsData() {
        return contractDetailsData;
    }

    /**
     * Sets the value of the contractDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractDetailsSubDataType }
     *     
     */
    public void setContractDetailsData(ContractDetailsSubDataType value) {
        this.contractDetailsData = value;
    }

    /**
     * Gets the value of the excludeFromHeadcount property.
     * This getter has been renamed from isExcludeFromHeadcount() to getExcludeFromHeadcount() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getExcludeFromHeadcount() {
        return excludeFromHeadcount;
    }

    /**
     * Sets the value of the excludeFromHeadcount property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExcludeFromHeadcount(Boolean value) {
        this.excludeFromHeadcount = value;
    }

    /**
     * Gets the value of the expectedAssignmentEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpectedAssignmentEndDate() {
        return expectedAssignmentEndDate;
    }

    /**
     * Sets the value of the expectedAssignmentEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpectedAssignmentEndDate(XMLGregorianCalendar value) {
        this.expectedAssignmentEndDate = value;
    }

    /**
     * Gets the value of the internationalAssignmentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link InternationalAssignmentTypeObjectType }
     *     
     */
    public InternationalAssignmentTypeObjectType getInternationalAssignmentTypeReference() {
        return internationalAssignmentTypeReference;
    }

    /**
     * Sets the value of the internationalAssignmentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link InternationalAssignmentTypeObjectType }
     *     
     */
    public void setInternationalAssignmentTypeReference(InternationalAssignmentTypeObjectType value) {
        this.internationalAssignmentTypeReference = value;
    }

}
