
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Data Element that contains the basic information to end the contract of a contingent worker. All required information must be included. The End Contingent Worker Contract business process will be initiated from this information.
 * 
 * <p>Java class for End_Contingent_Worker_Contract_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="End_Contingent_Worker_Contract_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Last_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Primary_Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType"/>
 *         &lt;element name="Secondary_Reason_Reference" type="{urn:com.workday/bsvc}Termination_SubcategoryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Local_Termination_Reason_Reference" type="{urn:com.workday/bsvc}Local_Termination_ReasonObjectType" minOccurs="0"/>
 *         &lt;element name="Notify_Worker_By_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Regrettable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Close_Position" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Job_Overlap_Allowed" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "End_Contingent_Worker_Contract_Event_DataType", propOrder = {
    "lastDayOfWork",
    "primaryReasonReference",
    "secondaryReasonReference",
    "localTerminationReasonReference",
    "notifyWorkerByDate",
    "regrettable",
    "closePosition",
    "jobOverlapAllowed",
    "workerDocumentData"
})
public class EndContingentWorkerContractEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Last_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar lastDayOfWork;
    @XmlElement(name = "Primary_Reason_Reference", required = true)
    protected EventClassificationSubcategoryObjectType primaryReasonReference;
    @XmlElement(name = "Secondary_Reason_Reference")
    protected List<TerminationSubcategoryObjectType> secondaryReasonReference;
    @XmlElement(name = "Local_Termination_Reason_Reference")
    protected LocalTerminationReasonObjectType localTerminationReasonReference;
    @XmlElement(name = "Notify_Worker_By_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar notifyWorkerByDate;
    @XmlElement(name = "Regrettable")
    protected Boolean regrettable;
    @XmlElement(name = "Close_Position")
    protected Boolean closePosition;
    @XmlElement(name = "Job_Overlap_Allowed")
    protected Boolean jobOverlapAllowed;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;

    /**
     * Gets the value of the lastDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastDayOfWork() {
        return lastDayOfWork;
    }

    /**
     * Sets the value of the lastDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastDayOfWork(XMLGregorianCalendar value) {
        this.lastDayOfWork = value;
    }

    /**
     * Gets the value of the primaryReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getPrimaryReasonReference() {
        return primaryReasonReference;
    }

    /**
     * Sets the value of the primaryReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setPrimaryReasonReference(EventClassificationSubcategoryObjectType value) {
        this.primaryReasonReference = value;
    }

    /**
     * Gets the value of the secondaryReasonReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the secondaryReasonReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSecondaryReasonReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TerminationSubcategoryObjectType }
     * 
     * 
     */
    public List<TerminationSubcategoryObjectType> getSecondaryReasonReference() {
        if (secondaryReasonReference == null) {
            secondaryReasonReference = new ArrayList<TerminationSubcategoryObjectType>();
        }
        return this.secondaryReasonReference;
    }

    /**
     * Gets the value of the localTerminationReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTerminationReasonObjectType }
     *     
     */
    public LocalTerminationReasonObjectType getLocalTerminationReasonReference() {
        return localTerminationReasonReference;
    }

    /**
     * Sets the value of the localTerminationReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTerminationReasonObjectType }
     *     
     */
    public void setLocalTerminationReasonReference(LocalTerminationReasonObjectType value) {
        this.localTerminationReasonReference = value;
    }

    /**
     * Gets the value of the notifyWorkerByDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getNotifyWorkerByDate() {
        return notifyWorkerByDate;
    }

    /**
     * Sets the value of the notifyWorkerByDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setNotifyWorkerByDate(XMLGregorianCalendar value) {
        this.notifyWorkerByDate = value;
    }

    /**
     * Gets the value of the regrettable property.
     * This getter has been renamed from isRegrettable() to getRegrettable() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getRegrettable() {
        return regrettable;
    }

    /**
     * Sets the value of the regrettable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRegrettable(Boolean value) {
        this.regrettable = value;
    }

    /**
     * Gets the value of the closePosition property.
     * This getter has been renamed from isClosePosition() to getClosePosition() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getClosePosition() {
        return closePosition;
    }

    /**
     * Sets the value of the closePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setClosePosition(Boolean value) {
        this.closePosition = value;
    }

    /**
     * Gets the value of the jobOverlapAllowed property.
     * This getter has been renamed from isJobOverlapAllowed() to getJobOverlapAllowed() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getJobOverlapAllowed() {
        return jobOverlapAllowed;
    }

    /**
     * Sets the value of the jobOverlapAllowed property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setJobOverlapAllowed(Boolean value) {
        this.jobOverlapAllowed = value;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Sets the value of the secondaryReasonReference property.
     * 
     * @param secondaryReasonReference
     *     allowed object is
     *     {@link TerminationSubcategoryObjectType }
     *     
     */
    public void setSecondaryReasonReference(List<TerminationSubcategoryObjectType> secondaryReasonReference) {
        this.secondaryReasonReference = secondaryReasonReference;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
