
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * This web service is used to end a contract for a contingent worker. This web service will run the End Contingent Worker Contract business process and any of its sub-processes.
 * 
 * <p>Java class for End_Contingent_Worker_Contract_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="End_Contingent_Worker_Contract_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Contingent_Worker_Reference" type="{urn:com.workday/bsvc}Contingent_WorkerObjectType"/>
 *         &lt;element name="Contract_End_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="End_Contract_Event_Data" type="{urn:com.workday/bsvc}End_Contingent_Worker_Contract_Event_DataType"/>
 *         &lt;element name="Assign_Organization_Roles_Sub_Process" type="{urn:com.workday/bsvc}Assign_Organization_Roles_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Create_Job_Requisition_Sub_Process" type="{urn:com.workday/bsvc}Create_Job_Requisition_Sub_ProcessType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "End_Contingent_Worker_Contract_DataType", propOrder = {
    "contingentWorkerReference",
    "contractEndDate",
    "endContractEventData",
    "assignOrganizationRolesSubProcess",
    "createJobRequisitionSubProcess"
})
public class EndContingentWorkerContractDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Contingent_Worker_Reference", required = true)
    protected ContingentWorkerObjectType contingentWorkerReference;
    @XmlElement(name = "Contract_End_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar contractEndDate;
    @XmlElement(name = "End_Contract_Event_Data", required = true)
    protected EndContingentWorkerContractEventDataType endContractEventData;
    @XmlElement(name = "Assign_Organization_Roles_Sub_Process")
    protected AssignOrganizationRolesSubBusinessProcessType assignOrganizationRolesSubProcess;
    @XmlElement(name = "Create_Job_Requisition_Sub_Process")
    protected List<CreateJobRequisitionSubProcessType> createJobRequisitionSubProcess;

    /**
     * Gets the value of the contingentWorkerReference property.
     * 
     * @return
     *     possible object is
     *     {@link ContingentWorkerObjectType }
     *     
     */
    public ContingentWorkerObjectType getContingentWorkerReference() {
        return contingentWorkerReference;
    }

    /**
     * Sets the value of the contingentWorkerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContingentWorkerObjectType }
     *     
     */
    public void setContingentWorkerReference(ContingentWorkerObjectType value) {
        this.contingentWorkerReference = value;
    }

    /**
     * Gets the value of the contractEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContractEndDate() {
        return contractEndDate;
    }

    /**
     * Sets the value of the contractEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContractEndDate(XMLGregorianCalendar value) {
        this.contractEndDate = value;
    }

    /**
     * Gets the value of the endContractEventData property.
     * 
     * @return
     *     possible object is
     *     {@link EndContingentWorkerContractEventDataType }
     *     
     */
    public EndContingentWorkerContractEventDataType getEndContractEventData() {
        return endContractEventData;
    }

    /**
     * Sets the value of the endContractEventData property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndContingentWorkerContractEventDataType }
     *     
     */
    public void setEndContractEventData(EndContingentWorkerContractEventDataType value) {
        this.endContractEventData = value;
    }

    /**
     * Gets the value of the assignOrganizationRolesSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignOrganizationRolesSubBusinessProcessType }
     *     
     */
    public AssignOrganizationRolesSubBusinessProcessType getAssignOrganizationRolesSubProcess() {
        return assignOrganizationRolesSubProcess;
    }

    /**
     * Sets the value of the assignOrganizationRolesSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignOrganizationRolesSubBusinessProcessType }
     *     
     */
    public void setAssignOrganizationRolesSubProcess(AssignOrganizationRolesSubBusinessProcessType value) {
        this.assignOrganizationRolesSubProcess = value;
    }

    /**
     * Gets the value of the createJobRequisitionSubProcess property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the createJobRequisitionSubProcess property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCreateJobRequisitionSubProcess().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CreateJobRequisitionSubProcessType }
     * 
     * 
     */
    public List<CreateJobRequisitionSubProcessType> getCreateJobRequisitionSubProcess() {
        if (createJobRequisitionSubProcess == null) {
            createJobRequisitionSubProcess = new ArrayList<CreateJobRequisitionSubProcessType>();
        }
        return this.createJobRequisitionSubProcess;
    }

    /**
     * Sets the value of the createJobRequisitionSubProcess property.
     * 
     * @param createJobRequisitionSubProcess
     *     allowed object is
     *     {@link CreateJobRequisitionSubProcessType }
     *     
     */
    public void setCreateJobRequisitionSubProcess(List<CreateJobRequisitionSubProcessType> createJobRequisitionSubProcess) {
        this.createJobRequisitionSubProcess = createJobRequisitionSubProcess;
    }

}
