
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the End Academic Appointment business process.
 * 
 * <p>Java class for End_Academic_Appointment_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="End_Academic_Appointment_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *           &lt;element name="Academic_Affiliate_Reference" type="{urn:com.workday/bsvc}Academic_AffiliateObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Academic_Appointment_Track_Reference" type="{urn:com.workday/bsvc}Academic_Appointment_TrackObjectType" minOccurs="0"/>
 *         &lt;element name="Reason_Reference" type="{urn:com.workday/bsvc}General_Event_SubcategoryObjectType"/>
 *         &lt;element name="Track_End_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "End_Academic_Appointment_DataType", propOrder = {
    "workerReference",
    "academicAffiliateReference",
    "academicAppointmentTrackReference",
    "reasonReference",
    "trackEndDate"
})
public class EndAcademicAppointmentDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Worker_Reference")
    protected WorkerObjectType workerReference;
    @XmlElement(name = "Academic_Affiliate_Reference")
    protected AcademicAffiliateObjectType academicAffiliateReference;
    @XmlElement(name = "Academic_Appointment_Track_Reference")
    protected AcademicAppointmentTrackObjectType academicAppointmentTrackReference;
    @XmlElement(name = "Reason_Reference", required = true)
    protected GeneralEventSubcategoryObjectType reasonReference;
    @XmlElement(name = "Track_End_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar trackEndDate;

    /**
     * Gets the value of the workerReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getWorkerReference() {
        return workerReference;
    }

    /**
     * Sets the value of the workerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setWorkerReference(WorkerObjectType value) {
        this.workerReference = value;
    }

    /**
     * Gets the value of the academicAffiliateReference property.
     * 
     * @return
     *     possible object is
     *     {@link AcademicAffiliateObjectType }
     *     
     */
    public AcademicAffiliateObjectType getAcademicAffiliateReference() {
        return academicAffiliateReference;
    }

    /**
     * Sets the value of the academicAffiliateReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AcademicAffiliateObjectType }
     *     
     */
    public void setAcademicAffiliateReference(AcademicAffiliateObjectType value) {
        this.academicAffiliateReference = value;
    }

    /**
     * Gets the value of the academicAppointmentTrackReference property.
     * 
     * @return
     *     possible object is
     *     {@link AcademicAppointmentTrackObjectType }
     *     
     */
    public AcademicAppointmentTrackObjectType getAcademicAppointmentTrackReference() {
        return academicAppointmentTrackReference;
    }

    /**
     * Sets the value of the academicAppointmentTrackReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link AcademicAppointmentTrackObjectType }
     *     
     */
    public void setAcademicAppointmentTrackReference(AcademicAppointmentTrackObjectType value) {
        this.academicAppointmentTrackReference = value;
    }

    /**
     * Gets the value of the reasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralEventSubcategoryObjectType }
     *     
     */
    public GeneralEventSubcategoryObjectType getReasonReference() {
        return reasonReference;
    }

    /**
     * Sets the value of the reasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link GeneralEventSubcategoryObjectType }
     *     
     */
    public void setReasonReference(GeneralEventSubcategoryObjectType value) {
        this.reasonReference = value;
    }

    /**
     * Gets the value of the trackEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTrackEndDate() {
        return trackEndDate;
    }

    /**
     * Sets the value of the trackEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTrackEndDate(XMLGregorianCalendar value) {
        this.trackEndDate = value;
    }

}
