
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper for the Edit Position Business Process Web Service and its sub business processes.
 * 
 * <p>Java class for Edit_Position_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Edit_Position_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *         &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_ElementObjectType" minOccurs="0"/>
 *         &lt;element name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Edit_Position_Event_Data" type="{urn:com.workday/bsvc}Edit_Position_Event_DataType"/>
 *         &lt;element name="Request_Compensation_Change_Sub_Process" type="{urn:com.workday/bsvc}Request_Compensation_For_Edit_Position_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Assign_Organization_Sub_Process" type="{urn:com.workday/bsvc}Edit_Assign_Position_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Pay_Group_Sub_Process" type="{urn:com.workday/bsvc}Assign_Pay_Group_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Review_Payroll_Interface_Sub_Process" type="{urn:com.workday/bsvc}Review_Payroll_Interface_Data_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Matrix_Organization_Sub_Process" type="{urn:com.workday/bsvc}Assign_Matrix_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Change_Personal_Information_Sub_Process" type="{urn:com.workday/bsvc}Change_Personal_Information_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_Default_Compensation_Sub_Process" type="{urn:com.workday/bsvc}Request_Compensation_Default_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Service_Dates_Sub_Process" type="{urn:com.workday/bsvc}Edit_Service_Dates_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Remove_Retiree_Status_Sub_Process" type="{urn:com.workday/bsvc}Remove_Retiree_Status_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Maintain_Employee_Contracts_Sub_Business_Process" type="{urn:com.workday/bsvc}Maintain_Employee_Contracts_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Request_Budget_Approval_Sub_Process" type="{urn:com.workday/bsvc}Request_Budget_Approval_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Check_Position_Budget_Sub_Process" type="{urn:com.workday/bsvc}Check_Position_Budget_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Update_Academic_Appointment_Sub_Process" type="{urn:com.workday/bsvc}Update_Academic_Appointment_Sub_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Costing_Allocation_Sub_Process" type="{urn:com.workday/bsvc}Assign_Costing_Allocation_Sub_Business_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Edit_Position_DataType", propOrder = {
    "workerReference",
    "positionReference",
    "effectiveDate",
    "editPositionEventData",
    "requestCompensationChangeSubProcess",
    "editAssignOrganizationSubProcess",
    "assignPayGroupSubProcess",
    "reviewPayrollInterfaceSubProcess",
    "assignMatrixOrganizationSubProcess",
    "changePersonalInformationSubProcess",
    "requestDefaultCompensationSubProcess",
    "editServiceDatesSubProcess",
    "removeRetireeStatusSubProcess",
    "maintainEmployeeContractsSubBusinessProcess",
    "requestBudgetApprovalSubProcess",
    "checkPositionBudgetSubProcess",
    "updateAcademicAppointmentSubProcess",
    "assignCostingAllocationSubProcess"
})
public class EditPositionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Worker_Reference")
    protected WorkerObjectType workerReference;
    @XmlElement(name = "Position_Reference")
    protected PositionElementObjectType positionReference;
    @XmlElement(name = "Effective_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;
    @XmlElement(name = "Edit_Position_Event_Data", required = true)
    protected EditPositionEventDataType editPositionEventData;
    @XmlElement(name = "Request_Compensation_Change_Sub_Process")
    protected RequestCompensationForEditPositionSubBusinessProcessType requestCompensationChangeSubProcess;
    @XmlElement(name = "Edit_Assign_Organization_Sub_Process")
    protected EditAssignPositionOrganizationSubBusinessProcessType editAssignOrganizationSubProcess;
    @XmlElement(name = "Assign_Pay_Group_Sub_Process")
    protected AssignPayGroupSubBusinessProcessType assignPayGroupSubProcess;
    @XmlElement(name = "Review_Payroll_Interface_Sub_Process")
    protected ReviewPayrollInterfaceDataSubBusinessProcessType reviewPayrollInterfaceSubProcess;
    @XmlElement(name = "Assign_Matrix_Organization_Sub_Process")
    protected AssignMatrixOrganizationSubBusinessProcessType assignMatrixOrganizationSubProcess;
    @XmlElement(name = "Change_Personal_Information_Sub_Process")
    protected ChangePersonalInformationSubBusinessProcessType changePersonalInformationSubProcess;
    @XmlElement(name = "Request_Default_Compensation_Sub_Process")
    protected RequestCompensationDefaultSubBusinessProcessType requestDefaultCompensationSubProcess;
    @XmlElement(name = "Edit_Service_Dates_Sub_Process")
    protected EditServiceDatesSubBusinessProcessType editServiceDatesSubProcess;
    @XmlElement(name = "Remove_Retiree_Status_Sub_Process")
    protected RemoveRetireeStatusSubBusinessProcessType removeRetireeStatusSubProcess;
    @XmlElement(name = "Maintain_Employee_Contracts_Sub_Business_Process")
    protected MaintainEmployeeContractsSubBusinessProcessType maintainEmployeeContractsSubBusinessProcess;
    @XmlElement(name = "Request_Budget_Approval_Sub_Process")
    protected RequestBudgetApprovalSubBusinessProcessType requestBudgetApprovalSubProcess;
    @XmlElement(name = "Check_Position_Budget_Sub_Process")
    protected CheckPositionBudgetSubBusinessProcessType checkPositionBudgetSubProcess;
    @XmlElement(name = "Update_Academic_Appointment_Sub_Process")
    protected UpdateAcademicAppointmentSubProcessType updateAcademicAppointmentSubProcess;
    @XmlElement(name = "Assign_Costing_Allocation_Sub_Process")
    protected AssignCostingAllocationSubBusinessProcessType assignCostingAllocationSubProcess;

    /**
     * Gets the value of the workerReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getWorkerReference() {
        return workerReference;
    }

    /**
     * Sets the value of the workerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setWorkerReference(WorkerObjectType value) {
        this.workerReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionElementObjectType }
     *     
     */
    public PositionElementObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionElementObjectType }
     *     
     */
    public void setPositionReference(PositionElementObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

    /**
     * Gets the value of the editPositionEventData property.
     * 
     * @return
     *     possible object is
     *     {@link EditPositionEventDataType }
     *     
     */
    public EditPositionEventDataType getEditPositionEventData() {
        return editPositionEventData;
    }

    /**
     * Sets the value of the editPositionEventData property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditPositionEventDataType }
     *     
     */
    public void setEditPositionEventData(EditPositionEventDataType value) {
        this.editPositionEventData = value;
    }

    /**
     * Gets the value of the requestCompensationChangeSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestCompensationForEditPositionSubBusinessProcessType }
     *     
     */
    public RequestCompensationForEditPositionSubBusinessProcessType getRequestCompensationChangeSubProcess() {
        return requestCompensationChangeSubProcess;
    }

    /**
     * Sets the value of the requestCompensationChangeSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestCompensationForEditPositionSubBusinessProcessType }
     *     
     */
    public void setRequestCompensationChangeSubProcess(RequestCompensationForEditPositionSubBusinessProcessType value) {
        this.requestCompensationChangeSubProcess = value;
    }

    /**
     * Gets the value of the editAssignOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public EditAssignPositionOrganizationSubBusinessProcessType getEditAssignOrganizationSubProcess() {
        return editAssignOrganizationSubProcess;
    }

    /**
     * Sets the value of the editAssignOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public void setEditAssignOrganizationSubProcess(EditAssignPositionOrganizationSubBusinessProcessType value) {
        this.editAssignOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the assignPayGroupSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public AssignPayGroupSubBusinessProcessType getAssignPayGroupSubProcess() {
        return assignPayGroupSubProcess;
    }

    /**
     * Sets the value of the assignPayGroupSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignPayGroupSubBusinessProcessType }
     *     
     */
    public void setAssignPayGroupSubProcess(AssignPayGroupSubBusinessProcessType value) {
        this.assignPayGroupSubProcess = value;
    }

    /**
     * Gets the value of the reviewPayrollInterfaceSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ReviewPayrollInterfaceDataSubBusinessProcessType }
     *     
     */
    public ReviewPayrollInterfaceDataSubBusinessProcessType getReviewPayrollInterfaceSubProcess() {
        return reviewPayrollInterfaceSubProcess;
    }

    /**
     * Sets the value of the reviewPayrollInterfaceSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReviewPayrollInterfaceDataSubBusinessProcessType }
     *     
     */
    public void setReviewPayrollInterfaceSubProcess(ReviewPayrollInterfaceDataSubBusinessProcessType value) {
        this.reviewPayrollInterfaceSubProcess = value;
    }

    /**
     * Gets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public AssignMatrixOrganizationSubBusinessProcessType getAssignMatrixOrganizationSubProcess() {
        return assignMatrixOrganizationSubProcess;
    }

    /**
     * Sets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public void setAssignMatrixOrganizationSubProcess(AssignMatrixOrganizationSubBusinessProcessType value) {
        this.assignMatrixOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the changePersonalInformationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public ChangePersonalInformationSubBusinessProcessType getChangePersonalInformationSubProcess() {
        return changePersonalInformationSubProcess;
    }

    /**
     * Sets the value of the changePersonalInformationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public void setChangePersonalInformationSubProcess(ChangePersonalInformationSubBusinessProcessType value) {
        this.changePersonalInformationSubProcess = value;
    }

    /**
     * Gets the value of the requestDefaultCompensationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestCompensationDefaultSubBusinessProcessType }
     *     
     */
    public RequestCompensationDefaultSubBusinessProcessType getRequestDefaultCompensationSubProcess() {
        return requestDefaultCompensationSubProcess;
    }

    /**
     * Sets the value of the requestDefaultCompensationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestCompensationDefaultSubBusinessProcessType }
     *     
     */
    public void setRequestDefaultCompensationSubProcess(RequestCompensationDefaultSubBusinessProcessType value) {
        this.requestDefaultCompensationSubProcess = value;
    }

    /**
     * Gets the value of the editServiceDatesSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public EditServiceDatesSubBusinessProcessType getEditServiceDatesSubProcess() {
        return editServiceDatesSubProcess;
    }

    /**
     * Sets the value of the editServiceDatesSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public void setEditServiceDatesSubProcess(EditServiceDatesSubBusinessProcessType value) {
        this.editServiceDatesSubProcess = value;
    }

    /**
     * Gets the value of the removeRetireeStatusSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public RemoveRetireeStatusSubBusinessProcessType getRemoveRetireeStatusSubProcess() {
        return removeRetireeStatusSubProcess;
    }

    /**
     * Sets the value of the removeRetireeStatusSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public void setRemoveRetireeStatusSubProcess(RemoveRetireeStatusSubBusinessProcessType value) {
        this.removeRetireeStatusSubProcess = value;
    }

    /**
     * Gets the value of the maintainEmployeeContractsSubBusinessProcess property.
     * 
     * @return
     *     possible object is
     *     {@link MaintainEmployeeContractsSubBusinessProcessType }
     *     
     */
    public MaintainEmployeeContractsSubBusinessProcessType getMaintainEmployeeContractsSubBusinessProcess() {
        return maintainEmployeeContractsSubBusinessProcess;
    }

    /**
     * Sets the value of the maintainEmployeeContractsSubBusinessProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaintainEmployeeContractsSubBusinessProcessType }
     *     
     */
    public void setMaintainEmployeeContractsSubBusinessProcess(MaintainEmployeeContractsSubBusinessProcessType value) {
        this.maintainEmployeeContractsSubBusinessProcess = value;
    }

    /**
     * Gets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public RequestBudgetApprovalSubBusinessProcessType getRequestBudgetApprovalSubProcess() {
        return requestBudgetApprovalSubProcess;
    }

    /**
     * Sets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestBudgetApprovalSubBusinessProcessType }
     *     
     */
    public void setRequestBudgetApprovalSubProcess(RequestBudgetApprovalSubBusinessProcessType value) {
        this.requestBudgetApprovalSubProcess = value;
    }

    /**
     * Gets the value of the checkPositionBudgetSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public CheckPositionBudgetSubBusinessProcessType getCheckPositionBudgetSubProcess() {
        return checkPositionBudgetSubProcess;
    }

    /**
     * Sets the value of the checkPositionBudgetSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public void setCheckPositionBudgetSubProcess(CheckPositionBudgetSubBusinessProcessType value) {
        this.checkPositionBudgetSubProcess = value;
    }

    /**
     * Gets the value of the updateAcademicAppointmentSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link UpdateAcademicAppointmentSubProcessType }
     *     
     */
    public UpdateAcademicAppointmentSubProcessType getUpdateAcademicAppointmentSubProcess() {
        return updateAcademicAppointmentSubProcess;
    }

    /**
     * Sets the value of the updateAcademicAppointmentSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link UpdateAcademicAppointmentSubProcessType }
     *     
     */
    public void setUpdateAcademicAppointmentSubProcess(UpdateAcademicAppointmentSubProcessType value) {
        this.updateAcademicAppointmentSubProcess = value;
    }

    /**
     * Gets the value of the assignCostingAllocationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public AssignCostingAllocationSubBusinessProcessType getAssignCostingAllocationSubProcess() {
        return assignCostingAllocationSubProcess;
    }

    /**
     * Sets the value of the assignCostingAllocationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignCostingAllocationSubBusinessProcessType }
     *     
     */
    public void setAssignCostingAllocationSubProcess(AssignCostingAllocationSubBusinessProcessType value) {
        this.assignCostingAllocationSubProcess = value;
    }

}
