
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper element for the Assign Organizations to Position sub business process.
 * If this element is submitted (Auto or Manual) as part of a Staffing event and the Position_Organization_Assignment  wrapper is not submitted, then the position's organization assignments will default from the supervisory organization.
 * 
 * <p>Java class for Edit_Assign_Position_Organization_Sub_Business_ProcessType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Edit_Assign_Position_Organization_Sub_Business_ProcessType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Business_Sub_Process_Parameters" type="{urn:com.workday/bsvc}Business_Sub_Process_ParametersType" minOccurs="0"/>
 *         &lt;element name="Position_Organization_Assignments_Data" type="{urn:com.workday/bsvc}Assign_Position_Organization_Event_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Edit_Assign_Position_Organization_Sub_Business_ProcessType", propOrder = {
    "businessSubProcessParameters",
    "positionOrganizationAssignmentsData"
})
public class EditAssignPositionOrganizationSubBusinessProcessType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Business_Sub_Process_Parameters")
    protected BusinessSubProcessParametersType businessSubProcessParameters;
    @XmlElement(name = "Position_Organization_Assignments_Data")
    protected AssignPositionOrganizationEventDataType positionOrganizationAssignmentsData;

    /**
     * Gets the value of the businessSubProcessParameters property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public BusinessSubProcessParametersType getBusinessSubProcessParameters() {
        return businessSubProcessParameters;
    }

    /**
     * Sets the value of the businessSubProcessParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessSubProcessParametersType }
     *     
     */
    public void setBusinessSubProcessParameters(BusinessSubProcessParametersType value) {
        this.businessSubProcessParameters = value;
    }

    /**
     * Gets the value of the positionOrganizationAssignmentsData property.
     * 
     * @return
     *     possible object is
     *     {@link AssignPositionOrganizationEventDataType }
     *     
     */
    public AssignPositionOrganizationEventDataType getPositionOrganizationAssignmentsData() {
        return positionOrganizationAssignmentsData;
    }

    /**
     * Sets the value of the positionOrganizationAssignmentsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignPositionOrganizationEventDataType }
     *     
     */
    public void setPositionOrganizationAssignmentsData(AssignPositionOrganizationEventDataType value) {
        this.positionOrganizationAssignmentsData = value;
    }

}
