
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Details of the allocation, (e.g., a set of allocation dimensions and percentages)
 * 
 * <p>Java class for Costing_Allocation_Detail_Replacement_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Costing_Allocation_Detail_Replacement_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Order" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;choice>
 *           &lt;element name="Default_from_Organization_Assignment" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *           &lt;element name="Costing_Override_Worktag_Reference" type="{urn:com.workday/bsvc}Tenanted_Payroll_WorktagObjectType" maxOccurs="unbounded"/>
 *         &lt;/choice>
 *         &lt;element name="Distribution_Percent">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="9"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Costing_Allocation_Detail_Replacement_DataType", propOrder = {
    "order",
    "defaultFromOrganizationAssignment",
    "costingOverrideWorktagReference",
    "distributionPercent"
})
public class CostingAllocationDetailReplacementDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Order", required = true)
    protected String order;
    @XmlElement(name = "Default_from_Organization_Assignment")
    protected Boolean defaultFromOrganizationAssignment;
    @XmlElement(name = "Costing_Override_Worktag_Reference")
    protected List<TenantedPayrollWorktagObjectType> costingOverrideWorktagReference;
    @XmlElement(name = "Distribution_Percent", required = true)
    protected BigDecimal distributionPercent;

    /**
     * Gets the value of the order property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrder() {
        return order;
    }

    /**
     * Sets the value of the order property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrder(String value) {
        this.order = value;
    }

    /**
     * Gets the value of the defaultFromOrganizationAssignment property.
     * This getter has been renamed from isDefaultFromOrganizationAssignment() to getDefaultFromOrganizationAssignment() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getDefaultFromOrganizationAssignment() {
        return defaultFromOrganizationAssignment;
    }

    /**
     * Sets the value of the defaultFromOrganizationAssignment property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDefaultFromOrganizationAssignment(Boolean value) {
        this.defaultFromOrganizationAssignment = value;
    }

    /**
     * Gets the value of the costingOverrideWorktagReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the costingOverrideWorktagReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCostingOverrideWorktagReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenantedPayrollWorktagObjectType }
     * 
     * 
     */
    public List<TenantedPayrollWorktagObjectType> getCostingOverrideWorktagReference() {
        if (costingOverrideWorktagReference == null) {
            costingOverrideWorktagReference = new ArrayList<TenantedPayrollWorktagObjectType>();
        }
        return this.costingOverrideWorktagReference;
    }

    /**
     * Gets the value of the distributionPercent property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getDistributionPercent() {
        return distributionPercent;
    }

    /**
     * Sets the value of the distributionPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setDistributionPercent(BigDecimal value) {
        this.distributionPercent = value;
    }

    /**
     * Sets the value of the costingOverrideWorktagReference property.
     * 
     * @param costingOverrideWorktagReference
     *     allowed object is
     *     {@link TenantedPayrollWorktagObjectType }
     *     
     */
    public void setCostingOverrideWorktagReference(List<TenantedPayrollWorktagObjectType> costingOverrideWorktagReference) {
        this.costingOverrideWorktagReference = costingOverrideWorktagReference;
    }

}
