
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the details of a contingent worker contract.
 * 
 * <p>Java class for Contract_Contingent_Worker_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Contract_Contingent_Worker_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Contingent_Worker_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Contract_Worker_Reason_Reference" type="{urn:com.workday/bsvc}Event_Classification_SubcategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Contract_Worker_Type_Reference" type="{urn:com.workday/bsvc}Contingent_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Create_Purchase_Order" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="Contract_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="First_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Conversion_Position_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType" minOccurs="0"/>
 *           &lt;element name="Default_Payment_Term_Reference" type="{urn:com.workday/bsvc}Payment_TermsObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Position_Details" type="{urn:com.workday/bsvc}Position_Details_Sub_DataType"/>
 *         &lt;element name="Contract_Details_Data" type="{urn:com.workday/bsvc}Contract_Details_Sub_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Purchase_Order_Contract_Details_Data" type="{urn:com.workday/bsvc}Purchase_Order_Contract_Details_DataType" minOccurs="0"/>
 *         &lt;element name="Contingent_Worker_External_ID_Data" type="{urn:com.workday/bsvc}External_ID_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Contract_Contingent_Worker_Event_DataType", propOrder = {
    "contingentWorkerID",
    "positionID",
    "contractWorkerReasonReference",
    "contractWorkerTypeReference",
    "createPurchaseOrder",
    "contractEndDate",
    "firstDayOfWork",
    "conversionPositionStartDate",
    "supplierReference",
    "defaultPaymentTermReference",
    "positionDetails",
    "contractDetailsData",
    "workerDocumentData",
    "purchaseOrderContractDetailsData",
    "contingentWorkerExternalIDData"
})
public class ContractContingentWorkerEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Contingent_Worker_ID")
    protected String contingentWorkerID;
    @XmlElement(name = "Position_ID")
    protected String positionID;
    @XmlElement(name = "Contract_Worker_Reason_Reference")
    protected EventClassificationSubcategoryObjectType contractWorkerReasonReference;
    @XmlElement(name = "Contract_Worker_Type_Reference")
    protected ContingentWorkerTypeObjectType contractWorkerTypeReference;
    @XmlElement(name = "Create_Purchase_Order")
    protected Boolean createPurchaseOrder;
    @XmlElement(name = "Contract_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar contractEndDate;
    @XmlElement(name = "First_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstDayOfWork;
    @XmlElement(name = "Conversion_Position_Start_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar conversionPositionStartDate;
    @XmlElement(name = "Supplier_Reference")
    protected SupplierObjectType supplierReference;
    @XmlElement(name = "Default_Payment_Term_Reference")
    protected PaymentTermsObjectType defaultPaymentTermReference;
    @XmlElement(name = "Position_Details", required = true)
    protected PositionDetailsSubDataType positionDetails;
    @XmlElement(name = "Contract_Details_Data")
    protected List<ContractDetailsSubDataType> contractDetailsData;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;
    @XmlElement(name = "Purchase_Order_Contract_Details_Data")
    protected PurchaseOrderContractDetailsDataType purchaseOrderContractDetailsData;
    @XmlElement(name = "Contingent_Worker_External_ID_Data")
    protected ExternalIDDataType contingentWorkerExternalIDData;

    /**
     * Gets the value of the contingentWorkerID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContingentWorkerID() {
        return contingentWorkerID;
    }

    /**
     * Sets the value of the contingentWorkerID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContingentWorkerID(String value) {
        this.contingentWorkerID = value;
    }

    /**
     * Gets the value of the positionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPositionID() {
        return positionID;
    }

    /**
     * Sets the value of the positionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPositionID(String value) {
        this.positionID = value;
    }

    /**
     * Gets the value of the contractWorkerReasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public EventClassificationSubcategoryObjectType getContractWorkerReasonReference() {
        return contractWorkerReasonReference;
    }

    /**
     * Sets the value of the contractWorkerReasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventClassificationSubcategoryObjectType }
     *     
     */
    public void setContractWorkerReasonReference(EventClassificationSubcategoryObjectType value) {
        this.contractWorkerReasonReference = value;
    }

    /**
     * Gets the value of the contractWorkerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public ContingentWorkerTypeObjectType getContractWorkerTypeReference() {
        return contractWorkerTypeReference;
    }

    /**
     * Sets the value of the contractWorkerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public void setContractWorkerTypeReference(ContingentWorkerTypeObjectType value) {
        this.contractWorkerTypeReference = value;
    }

    /**
     * Gets the value of the createPurchaseOrder property.
     * This getter has been renamed from isCreatePurchaseOrder() to getCreatePurchaseOrder() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCreatePurchaseOrder() {
        return createPurchaseOrder;
    }

    /**
     * Sets the value of the createPurchaseOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCreatePurchaseOrder(Boolean value) {
        this.createPurchaseOrder = value;
    }

    /**
     * Gets the value of the contractEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContractEndDate() {
        return contractEndDate;
    }

    /**
     * Sets the value of the contractEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContractEndDate(XMLGregorianCalendar value) {
        this.contractEndDate = value;
    }

    /**
     * Gets the value of the firstDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstDayOfWork() {
        return firstDayOfWork;
    }

    /**
     * Sets the value of the firstDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstDayOfWork(XMLGregorianCalendar value) {
        this.firstDayOfWork = value;
    }

    /**
     * Gets the value of the conversionPositionStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getConversionPositionStartDate() {
        return conversionPositionStartDate;
    }

    /**
     * Sets the value of the conversionPositionStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setConversionPositionStartDate(XMLGregorianCalendar value) {
        this.conversionPositionStartDate = value;
    }

    /**
     * Gets the value of the supplierReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierObjectType }
     *     
     */
    public SupplierObjectType getSupplierReference() {
        return supplierReference;
    }

    /**
     * Sets the value of the supplierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setSupplierReference(SupplierObjectType value) {
        this.supplierReference = value;
    }

    /**
     * Gets the value of the defaultPaymentTermReference property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTermsObjectType }
     *     
     */
    public PaymentTermsObjectType getDefaultPaymentTermReference() {
        return defaultPaymentTermReference;
    }

    /**
     * Sets the value of the defaultPaymentTermReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTermsObjectType }
     *     
     */
    public void setDefaultPaymentTermReference(PaymentTermsObjectType value) {
        this.defaultPaymentTermReference = value;
    }

    /**
     * Gets the value of the positionDetails property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public PositionDetailsSubDataType getPositionDetails() {
        return positionDetails;
    }

    /**
     * Sets the value of the positionDetails property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public void setPositionDetails(PositionDetailsSubDataType value) {
        this.positionDetails = value;
    }

    /**
     * Gets the value of the contractDetailsData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contractDetailsData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContractDetailsData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ContractDetailsSubDataType }
     * 
     * 
     */
    public List<ContractDetailsSubDataType> getContractDetailsData() {
        if (contractDetailsData == null) {
            contractDetailsData = new ArrayList<ContractDetailsSubDataType>();
        }
        return this.contractDetailsData;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Gets the value of the purchaseOrderContractDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link PurchaseOrderContractDetailsDataType }
     *     
     */
    public PurchaseOrderContractDetailsDataType getPurchaseOrderContractDetailsData() {
        return purchaseOrderContractDetailsData;
    }

    /**
     * Sets the value of the purchaseOrderContractDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PurchaseOrderContractDetailsDataType }
     *     
     */
    public void setPurchaseOrderContractDetailsData(PurchaseOrderContractDetailsDataType value) {
        this.purchaseOrderContractDetailsData = value;
    }

    /**
     * Gets the value of the contingentWorkerExternalIDData property.
     * 
     * @return
     *     possible object is
     *     {@link ExternalIDDataType }
     *     
     */
    public ExternalIDDataType getContingentWorkerExternalIDData() {
        return contingentWorkerExternalIDData;
    }

    /**
     * Sets the value of the contingentWorkerExternalIDData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExternalIDDataType }
     *     
     */
    public void setContingentWorkerExternalIDData(ExternalIDDataType value) {
        this.contingentWorkerExternalIDData = value;
    }

    /**
     * Sets the value of the contractDetailsData property.
     * 
     * @param contractDetailsData
     *     allowed object is
     *     {@link ContractDetailsSubDataType }
     *     
     */
    public void setContractDetailsData(List<ContractDetailsSubDataType> contractDetailsData) {
        this.contractDetailsData = contractDetailsData;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
