
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the Contract Contingent Worker business process web service and its sub business processes.
 * 
 * <p>Java class for Contract_Contingent_Worker_Business_Process_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Contract_Contingent_Worker_Business_Process_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Applicant_Reference" type="{urn:com.workday/bsvc}ApplicantObjectType"/>
 *           &lt;element name="Former_Worker_Reference" type="{urn:com.workday/bsvc}Former_WorkerObjectType"/>
 *           &lt;element name="Applicant_Data" type="{urn:com.workday/bsvc}Create_Applicant_DataType"/>
 *         &lt;/choice>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Headcount_Reference" type="{urn:com.workday/bsvc}Headcount_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Contract_Start_Date" type="{http://www.w3.org/2001/XMLSchema}date"/>
 *         &lt;element name="Contract_Contingent_Worker_Event_Data" type="{urn:com.workday/bsvc}Contract_Contingent_Worker_Event_DataType"/>
 *         &lt;element name="Update_ID_Information_Sub_Process" type="{urn:com.workday/bsvc}Update_ID_Information_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Government_IDs_Sub_Process" type="{urn:com.workday/bsvc}Edit_Government_IDs_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Passports_and_Visas_Sub_Process" type="{urn:com.workday/bsvc}Edit_Passports_and_Visas_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_License_Sub_Process" type="{urn:com.workday/bsvc}Edit_Licenses_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Custom_IDs_Sub_Process" type="{urn:com.workday/bsvc}Edit_Custom_IDs_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Assign_Organization_Sub_Process" type="{urn:com.workday/bsvc}Edit_Assign_Position_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Create_Workday_Account_Sub_Process" type="{urn:com.workday/bsvc}Create_Workday_Account_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Assign_Matrix_Organization_Sub_Process" type="{urn:com.workday/bsvc}Assign_Matrix_Organization_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Change_Personal_Information_Sub_Process" type="{urn:com.workday/bsvc}Change_Personal_Information_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Edit_Service_Dates_Sub_Process" type="{urn:com.workday/bsvc}Edit_Service_Dates_Sub_Business_ProcessType" minOccurs="0"/>
 *         &lt;element name="Remove_Retiree_Status_Sub_Process" type="{urn:com.workday/bsvc}Remove_Retiree_Status_Sub_Business_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Contract_Contingent_Worker_Business_Process_DataType", propOrder = {
    "applicantReference",
    "formerWorkerReference",
    "applicantData",
    "organizationReference",
    "positionReference",
    "headcountReference",
    "jobRequisitionReference",
    "contractStartDate",
    "contractContingentWorkerEventData",
    "updateIDInformationSubProcess",
    "editGovernmentIDsSubProcess",
    "editPassportsAndVisasSubProcess",
    "editLicenseSubProcess",
    "editCustomIDsSubProcess",
    "editAssignOrganizationSubProcess",
    "createWorkdayAccountSubProcess",
    "assignMatrixOrganizationSubProcess",
    "changePersonalInformationSubProcess",
    "editServiceDatesSubProcess",
    "removeRetireeStatusSubProcess"
})
public class ContractContingentWorkerBusinessProcessDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Applicant_Reference")
    protected ApplicantObjectType applicantReference;
    @XmlElement(name = "Former_Worker_Reference")
    protected FormerWorkerObjectType formerWorkerReference;
    @XmlElement(name = "Applicant_Data")
    protected CreateApplicantDataType applicantData;
    @XmlElement(name = "Organization_Reference")
    protected SupervisoryOrganizationObjectType organizationReference;
    @XmlElement(name = "Position_Reference")
    protected PositionRestrictionsObjectType positionReference;
    @XmlElement(name = "Headcount_Reference")
    protected HeadcountRestrictionsObjectType headcountReference;
    @XmlElement(name = "Job_Requisition_Reference")
    protected JobRequisitionObjectType jobRequisitionReference;
    @XmlElement(name = "Contract_Start_Date", required = true)
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar contractStartDate;
    @XmlElement(name = "Contract_Contingent_Worker_Event_Data", required = true)
    protected ContractContingentWorkerEventDataType contractContingentWorkerEventData;
    @XmlElement(name = "Update_ID_Information_Sub_Process")
    protected UpdateIDInformationSubBusinessProcessType updateIDInformationSubProcess;
    @XmlElement(name = "Edit_Government_IDs_Sub_Process")
    protected EditGovernmentIDsSubBusinessProcessType editGovernmentIDsSubProcess;
    @XmlElement(name = "Edit_Passports_and_Visas_Sub_Process")
    protected EditPassportsAndVisasSubBusinessProcessType editPassportsAndVisasSubProcess;
    @XmlElement(name = "Edit_License_Sub_Process")
    protected EditLicensesSubBusinessProcessType editLicenseSubProcess;
    @XmlElement(name = "Edit_Custom_IDs_Sub_Process")
    protected EditCustomIDsSubBusinessProcessType editCustomIDsSubProcess;
    @XmlElement(name = "Edit_Assign_Organization_Sub_Process")
    protected EditAssignPositionOrganizationSubBusinessProcessType editAssignOrganizationSubProcess;
    @XmlElement(name = "Create_Workday_Account_Sub_Process")
    protected CreateWorkdayAccountSubBusinessProcessType createWorkdayAccountSubProcess;
    @XmlElement(name = "Assign_Matrix_Organization_Sub_Process")
    protected AssignMatrixOrganizationSubBusinessProcessType assignMatrixOrganizationSubProcess;
    @XmlElement(name = "Change_Personal_Information_Sub_Process")
    protected ChangePersonalInformationSubBusinessProcessType changePersonalInformationSubProcess;
    @XmlElement(name = "Edit_Service_Dates_Sub_Process")
    protected EditServiceDatesSubBusinessProcessType editServiceDatesSubProcess;
    @XmlElement(name = "Remove_Retiree_Status_Sub_Process")
    protected RemoveRetireeStatusSubBusinessProcessType removeRetireeStatusSubProcess;

    /**
     * Gets the value of the applicantReference property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicantObjectType }
     *     
     */
    public ApplicantObjectType getApplicantReference() {
        return applicantReference;
    }

    /**
     * Sets the value of the applicantReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicantObjectType }
     *     
     */
    public void setApplicantReference(ApplicantObjectType value) {
        this.applicantReference = value;
    }

    /**
     * Gets the value of the formerWorkerReference property.
     * 
     * @return
     *     possible object is
     *     {@link FormerWorkerObjectType }
     *     
     */
    public FormerWorkerObjectType getFormerWorkerReference() {
        return formerWorkerReference;
    }

    /**
     * Sets the value of the formerWorkerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormerWorkerObjectType }
     *     
     */
    public void setFormerWorkerReference(FormerWorkerObjectType value) {
        this.formerWorkerReference = value;
    }

    /**
     * Gets the value of the applicantData property.
     * 
     * @return
     *     possible object is
     *     {@link CreateApplicantDataType }
     *     
     */
    public CreateApplicantDataType getApplicantData() {
        return applicantData;
    }

    /**
     * Sets the value of the applicantData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateApplicantDataType }
     *     
     */
    public void setApplicantData(CreateApplicantDataType value) {
        this.applicantData = value;
    }

    /**
     * Gets the value of the organizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getOrganizationReference() {
        return organizationReference;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.organizationReference = value;
    }

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(PositionRestrictionsObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the headcountReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public HeadcountRestrictionsObjectType getHeadcountReference() {
        return headcountReference;
    }

    /**
     * Sets the value of the headcountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public void setHeadcountReference(HeadcountRestrictionsObjectType value) {
        this.headcountReference = value;
    }

    /**
     * Gets the value of the jobRequisitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public JobRequisitionObjectType getJobRequisitionReference() {
        return jobRequisitionReference;
    }

    /**
     * Sets the value of the jobRequisitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setJobRequisitionReference(JobRequisitionObjectType value) {
        this.jobRequisitionReference = value;
    }

    /**
     * Gets the value of the contractStartDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContractStartDate() {
        return contractStartDate;
    }

    /**
     * Sets the value of the contractStartDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContractStartDate(XMLGregorianCalendar value) {
        this.contractStartDate = value;
    }

    /**
     * Gets the value of the contractContingentWorkerEventData property.
     * 
     * @return
     *     possible object is
     *     {@link ContractContingentWorkerEventDataType }
     *     
     */
    public ContractContingentWorkerEventDataType getContractContingentWorkerEventData() {
        return contractContingentWorkerEventData;
    }

    /**
     * Sets the value of the contractContingentWorkerEventData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractContingentWorkerEventDataType }
     *     
     */
    public void setContractContingentWorkerEventData(ContractContingentWorkerEventDataType value) {
        this.contractContingentWorkerEventData = value;
    }

    /**
     * Gets the value of the updateIDInformationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link UpdateIDInformationSubBusinessProcessType }
     *     
     */
    public UpdateIDInformationSubBusinessProcessType getUpdateIDInformationSubProcess() {
        return updateIDInformationSubProcess;
    }

    /**
     * Sets the value of the updateIDInformationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link UpdateIDInformationSubBusinessProcessType }
     *     
     */
    public void setUpdateIDInformationSubProcess(UpdateIDInformationSubBusinessProcessType value) {
        this.updateIDInformationSubProcess = value;
    }

    /**
     * Gets the value of the editGovernmentIDsSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditGovernmentIDsSubBusinessProcessType }
     *     
     */
    public EditGovernmentIDsSubBusinessProcessType getEditGovernmentIDsSubProcess() {
        return editGovernmentIDsSubProcess;
    }

    /**
     * Sets the value of the editGovernmentIDsSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditGovernmentIDsSubBusinessProcessType }
     *     
     */
    public void setEditGovernmentIDsSubProcess(EditGovernmentIDsSubBusinessProcessType value) {
        this.editGovernmentIDsSubProcess = value;
    }

    /**
     * Gets the value of the editPassportsAndVisasSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditPassportsAndVisasSubBusinessProcessType }
     *     
     */
    public EditPassportsAndVisasSubBusinessProcessType getEditPassportsAndVisasSubProcess() {
        return editPassportsAndVisasSubProcess;
    }

    /**
     * Sets the value of the editPassportsAndVisasSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditPassportsAndVisasSubBusinessProcessType }
     *     
     */
    public void setEditPassportsAndVisasSubProcess(EditPassportsAndVisasSubBusinessProcessType value) {
        this.editPassportsAndVisasSubProcess = value;
    }

    /**
     * Gets the value of the editLicenseSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditLicensesSubBusinessProcessType }
     *     
     */
    public EditLicensesSubBusinessProcessType getEditLicenseSubProcess() {
        return editLicenseSubProcess;
    }

    /**
     * Sets the value of the editLicenseSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditLicensesSubBusinessProcessType }
     *     
     */
    public void setEditLicenseSubProcess(EditLicensesSubBusinessProcessType value) {
        this.editLicenseSubProcess = value;
    }

    /**
     * Gets the value of the editCustomIDsSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditCustomIDsSubBusinessProcessType }
     *     
     */
    public EditCustomIDsSubBusinessProcessType getEditCustomIDsSubProcess() {
        return editCustomIDsSubProcess;
    }

    /**
     * Sets the value of the editCustomIDsSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditCustomIDsSubBusinessProcessType }
     *     
     */
    public void setEditCustomIDsSubProcess(EditCustomIDsSubBusinessProcessType value) {
        this.editCustomIDsSubProcess = value;
    }

    /**
     * Gets the value of the editAssignOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public EditAssignPositionOrganizationSubBusinessProcessType getEditAssignOrganizationSubProcess() {
        return editAssignOrganizationSubProcess;
    }

    /**
     * Sets the value of the editAssignOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditAssignPositionOrganizationSubBusinessProcessType }
     *     
     */
    public void setEditAssignOrganizationSubProcess(EditAssignPositionOrganizationSubBusinessProcessType value) {
        this.editAssignOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the createWorkdayAccountSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CreateWorkdayAccountSubBusinessProcessType }
     *     
     */
    public CreateWorkdayAccountSubBusinessProcessType getCreateWorkdayAccountSubProcess() {
        return createWorkdayAccountSubProcess;
    }

    /**
     * Sets the value of the createWorkdayAccountSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreateWorkdayAccountSubBusinessProcessType }
     *     
     */
    public void setCreateWorkdayAccountSubProcess(CreateWorkdayAccountSubBusinessProcessType value) {
        this.createWorkdayAccountSubProcess = value;
    }

    /**
     * Gets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public AssignMatrixOrganizationSubBusinessProcessType getAssignMatrixOrganizationSubProcess() {
        return assignMatrixOrganizationSubProcess;
    }

    /**
     * Sets the value of the assignMatrixOrganizationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssignMatrixOrganizationSubBusinessProcessType }
     *     
     */
    public void setAssignMatrixOrganizationSubProcess(AssignMatrixOrganizationSubBusinessProcessType value) {
        this.assignMatrixOrganizationSubProcess = value;
    }

    /**
     * Gets the value of the changePersonalInformationSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public ChangePersonalInformationSubBusinessProcessType getChangePersonalInformationSubProcess() {
        return changePersonalInformationSubProcess;
    }

    /**
     * Sets the value of the changePersonalInformationSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChangePersonalInformationSubBusinessProcessType }
     *     
     */
    public void setChangePersonalInformationSubProcess(ChangePersonalInformationSubBusinessProcessType value) {
        this.changePersonalInformationSubProcess = value;
    }

    /**
     * Gets the value of the editServiceDatesSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public EditServiceDatesSubBusinessProcessType getEditServiceDatesSubProcess() {
        return editServiceDatesSubProcess;
    }

    /**
     * Sets the value of the editServiceDatesSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link EditServiceDatesSubBusinessProcessType }
     *     
     */
    public void setEditServiceDatesSubProcess(EditServiceDatesSubBusinessProcessType value) {
        this.editServiceDatesSubProcess = value;
    }

    /**
     * Gets the value of the removeRetireeStatusSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public RemoveRetireeStatusSubBusinessProcessType getRemoveRetireeStatusSubProcess() {
        return removeRetireeStatusSubProcess;
    }

    /**
     * Sets the value of the removeRetireeStatusSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RemoveRetireeStatusSubBusinessProcessType }
     *     
     */
    public void setRemoveRetireeStatusSubProcess(RemoveRetireeStatusSubBusinessProcessType value) {
        this.removeRetireeStatusSubProcess = value;
    }

}
