
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * This element contains all information related to hiring/contracting a contingent worker.  This information only needs to be filled in if the worker type is for an employee.
 * 
 * <p>Java class for Contingent_Worker_Cost_Information_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Contingent_Worker_Cost_Information_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Requester_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *         &lt;element name="Company_for_Purchase_Order_Reference" type="{urn:com.workday/bsvc}CompanyObjectType" minOccurs="0"/>
 *         &lt;element name="Supplier_Reference" type="{urn:com.workday/bsvc}SupplierObjectType" minOccurs="0"/>
 *         &lt;element name="Currency_Reference" type="{urn:com.workday/bsvc}CurrencyObjectType" minOccurs="0"/>
 *         &lt;element name="Spend_Category_Reference" type="{urn:com.workday/bsvc}Spend_CategoryObjectType" minOccurs="0"/>
 *         &lt;element name="Pay_Rate" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Frequency_Reference" type="{urn:com.workday/bsvc}FrequencyObjectType" minOccurs="0"/>
 *         &lt;element name="Maximum_Amount" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;minInclusive value="0"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Worktags_Reference" type="{urn:com.workday/bsvc}Audited_Accounting_WorktagObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Contingent_Worker_Cost_Information_DataType", propOrder = {
    "requesterReference",
    "companyForPurchaseOrderReference",
    "supplierReference",
    "currencyReference",
    "spendCategoryReference",
    "payRate",
    "frequencyReference",
    "maximumAmount",
    "worktagsReference"
})
public class ContingentWorkerCostInformationDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Requester_Reference")
    protected WorkerObjectType requesterReference;
    @XmlElement(name = "Company_for_Purchase_Order_Reference")
    protected CompanyObjectType companyForPurchaseOrderReference;
    @XmlElement(name = "Supplier_Reference")
    protected SupplierObjectType supplierReference;
    @XmlElement(name = "Currency_Reference")
    protected CurrencyObjectType currencyReference;
    @XmlElement(name = "Spend_Category_Reference")
    protected SpendCategoryObjectType spendCategoryReference;
    @XmlElement(name = "Pay_Rate")
    protected BigDecimal payRate;
    @XmlElement(name = "Frequency_Reference")
    protected FrequencyObjectType frequencyReference;
    @XmlElement(name = "Maximum_Amount")
    protected BigDecimal maximumAmount;
    @XmlElement(name = "Worktags_Reference")
    protected List<AuditedAccountingWorktagObjectType> worktagsReference;

    /**
     * Gets the value of the requesterReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getRequesterReference() {
        return requesterReference;
    }

    /**
     * Sets the value of the requesterReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setRequesterReference(WorkerObjectType value) {
        this.requesterReference = value;
    }

    /**
     * Gets the value of the companyForPurchaseOrderReference property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyObjectType }
     *     
     */
    public CompanyObjectType getCompanyForPurchaseOrderReference() {
        return companyForPurchaseOrderReference;
    }

    /**
     * Sets the value of the companyForPurchaseOrderReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyObjectType }
     *     
     */
    public void setCompanyForPurchaseOrderReference(CompanyObjectType value) {
        this.companyForPurchaseOrderReference = value;
    }

    /**
     * Gets the value of the supplierReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierObjectType }
     *     
     */
    public SupplierObjectType getSupplierReference() {
        return supplierReference;
    }

    /**
     * Sets the value of the supplierReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierObjectType }
     *     
     */
    public void setSupplierReference(SupplierObjectType value) {
        this.supplierReference = value;
    }

    /**
     * Gets the value of the currencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyObjectType }
     *     
     */
    public CurrencyObjectType getCurrencyReference() {
        return currencyReference;
    }

    /**
     * Sets the value of the currencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyObjectType }
     *     
     */
    public void setCurrencyReference(CurrencyObjectType value) {
        this.currencyReference = value;
    }

    /**
     * Gets the value of the spendCategoryReference property.
     * 
     * @return
     *     possible object is
     *     {@link SpendCategoryObjectType }
     *     
     */
    public SpendCategoryObjectType getSpendCategoryReference() {
        return spendCategoryReference;
    }

    /**
     * Sets the value of the spendCategoryReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpendCategoryObjectType }
     *     
     */
    public void setSpendCategoryReference(SpendCategoryObjectType value) {
        this.spendCategoryReference = value;
    }

    /**
     * Gets the value of the payRate property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPayRate() {
        return payRate;
    }

    /**
     * Sets the value of the payRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPayRate(BigDecimal value) {
        this.payRate = value;
    }

    /**
     * Gets the value of the frequencyReference property.
     * 
     * @return
     *     possible object is
     *     {@link FrequencyObjectType }
     *     
     */
    public FrequencyObjectType getFrequencyReference() {
        return frequencyReference;
    }

    /**
     * Sets the value of the frequencyReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link FrequencyObjectType }
     *     
     */
    public void setFrequencyReference(FrequencyObjectType value) {
        this.frequencyReference = value;
    }

    /**
     * Gets the value of the maximumAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getMaximumAmount() {
        return maximumAmount;
    }

    /**
     * Sets the value of the maximumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setMaximumAmount(BigDecimal value) {
        this.maximumAmount = value;
    }

    /**
     * Gets the value of the worktagsReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the worktagsReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorktagsReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuditedAccountingWorktagObjectType }
     * 
     * 
     */
    public List<AuditedAccountingWorktagObjectType> getWorktagsReference() {
        if (worktagsReference == null) {
            worktagsReference = new ArrayList<AuditedAccountingWorktagObjectType>();
        }
        return this.worktagsReference;
    }

    /**
     * Sets the value of the worktagsReference property.
     * 
     * @param worktagsReference
     *     allowed object is
     *     {@link AuditedAccountingWorktagObjectType }
     *     
     */
    public void setWorktagsReference(List<AuditedAccountingWorktagObjectType> worktagsReference) {
        this.worktagsReference = worktagsReference;
    }

}
