
package com.workday.staffing;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Data element for the Propose Compensation for Hire business process.
 * 
 * <p>Java class for Compensation_Proposed_For_Employment_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Compensation_Proposed_For_Employment_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Primary_Compensation_Basis" minOccurs="0">
 *           &lt;simpleType>
 *             &lt;restriction base="{http://www.w3.org/2001/XMLSchema}decimal">
 *               &lt;totalDigits value="26"/>
 *               &lt;fractionDigits value="6"/>
 *             &lt;/restriction>
 *           &lt;/simpleType>
 *         &lt;/element>
 *         &lt;element name="Compensation_Guidelines_Data" type="{urn:com.workday/bsvc}Compensatable_Guidelines_DataType" minOccurs="0"/>
 *         &lt;element name="Pay_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Base_Pay_Plan_Job_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Unit_Salary_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Salary_Unit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Allowance_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Allowance_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Unit_Allowance_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Allowance_Unit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Bonus_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Bonus_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Merit_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Merit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Commission_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Commission_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Stock_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Stock_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Period_Salary_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Period_Salary_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Compensation_Proposed_For_Employment_DataType", propOrder = {
    "primaryCompensationBasis",
    "compensationGuidelinesData",
    "payPlanData",
    "unitSalaryPlanData",
    "allowancePlanData",
    "unitAllowancePlanData",
    "bonusPlanData",
    "meritPlanData",
    "commissionPlanData",
    "stockPlanData",
    "periodSalaryPlanData"
})
public class CompensationProposedForEmploymentDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Primary_Compensation_Basis")
    protected BigDecimal primaryCompensationBasis;
    @XmlElement(name = "Compensation_Guidelines_Data")
    protected CompensatableGuidelinesDataType compensationGuidelinesData;
    @XmlElement(name = "Pay_Plan_Data")
    protected ProposedBasePayPlanJobAssignmentContainerDataType payPlanData;
    @XmlElement(name = "Unit_Salary_Plan_Data")
    protected ProposedSalaryUnitPlanAssignmentContainerDataType unitSalaryPlanData;
    @XmlElement(name = "Allowance_Plan_Data")
    protected ProposedAllowancePlanAssignmentContainerDataType allowancePlanData;
    @XmlElement(name = "Unit_Allowance_Plan_Data")
    protected ProposedAllowanceUnitPlanAssignmentContainerDataType unitAllowancePlanData;
    @XmlElement(name = "Bonus_Plan_Data")
    protected ProposedBonusPlanAssignmentContainerDataType bonusPlanData;
    @XmlElement(name = "Merit_Plan_Data")
    protected ProposedMeritPlanAssignmentContainerDataType meritPlanData;
    @XmlElement(name = "Commission_Plan_Data")
    protected ProposedCommissionPlanAssignmentContainerDataType commissionPlanData;
    @XmlElement(name = "Stock_Plan_Data")
    protected ProposedStockPlanAssignmentContainerDataType stockPlanData;
    @XmlElement(name = "Period_Salary_Plan_Data")
    protected ProposedPeriodSalaryPlanAssignmentContainerDataType periodSalaryPlanData;

    /**
     * Gets the value of the primaryCompensationBasis property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getPrimaryCompensationBasis() {
        return primaryCompensationBasis;
    }

    /**
     * Sets the value of the primaryCompensationBasis property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPrimaryCompensationBasis(BigDecimal value) {
        this.primaryCompensationBasis = value;
    }

    /**
     * Gets the value of the compensationGuidelinesData property.
     * 
     * @return
     *     possible object is
     *     {@link CompensatableGuidelinesDataType }
     *     
     */
    public CompensatableGuidelinesDataType getCompensationGuidelinesData() {
        return compensationGuidelinesData;
    }

    /**
     * Sets the value of the compensationGuidelinesData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompensatableGuidelinesDataType }
     *     
     */
    public void setCompensationGuidelinesData(CompensatableGuidelinesDataType value) {
        this.compensationGuidelinesData = value;
    }

    /**
     * Gets the value of the payPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedBasePayPlanJobAssignmentContainerDataType }
     *     
     */
    public ProposedBasePayPlanJobAssignmentContainerDataType getPayPlanData() {
        return payPlanData;
    }

    /**
     * Sets the value of the payPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedBasePayPlanJobAssignmentContainerDataType }
     *     
     */
    public void setPayPlanData(ProposedBasePayPlanJobAssignmentContainerDataType value) {
        this.payPlanData = value;
    }

    /**
     * Gets the value of the unitSalaryPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedSalaryUnitPlanAssignmentContainerDataType }
     *     
     */
    public ProposedSalaryUnitPlanAssignmentContainerDataType getUnitSalaryPlanData() {
        return unitSalaryPlanData;
    }

    /**
     * Sets the value of the unitSalaryPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedSalaryUnitPlanAssignmentContainerDataType }
     *     
     */
    public void setUnitSalaryPlanData(ProposedSalaryUnitPlanAssignmentContainerDataType value) {
        this.unitSalaryPlanData = value;
    }

    /**
     * Gets the value of the allowancePlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedAllowancePlanAssignmentContainerDataType }
     *     
     */
    public ProposedAllowancePlanAssignmentContainerDataType getAllowancePlanData() {
        return allowancePlanData;
    }

    /**
     * Sets the value of the allowancePlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedAllowancePlanAssignmentContainerDataType }
     *     
     */
    public void setAllowancePlanData(ProposedAllowancePlanAssignmentContainerDataType value) {
        this.allowancePlanData = value;
    }

    /**
     * Gets the value of the unitAllowancePlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedAllowanceUnitPlanAssignmentContainerDataType }
     *     
     */
    public ProposedAllowanceUnitPlanAssignmentContainerDataType getUnitAllowancePlanData() {
        return unitAllowancePlanData;
    }

    /**
     * Sets the value of the unitAllowancePlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedAllowanceUnitPlanAssignmentContainerDataType }
     *     
     */
    public void setUnitAllowancePlanData(ProposedAllowanceUnitPlanAssignmentContainerDataType value) {
        this.unitAllowancePlanData = value;
    }

    /**
     * Gets the value of the bonusPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedBonusPlanAssignmentContainerDataType }
     *     
     */
    public ProposedBonusPlanAssignmentContainerDataType getBonusPlanData() {
        return bonusPlanData;
    }

    /**
     * Sets the value of the bonusPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedBonusPlanAssignmentContainerDataType }
     *     
     */
    public void setBonusPlanData(ProposedBonusPlanAssignmentContainerDataType value) {
        this.bonusPlanData = value;
    }

    /**
     * Gets the value of the meritPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedMeritPlanAssignmentContainerDataType }
     *     
     */
    public ProposedMeritPlanAssignmentContainerDataType getMeritPlanData() {
        return meritPlanData;
    }

    /**
     * Sets the value of the meritPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedMeritPlanAssignmentContainerDataType }
     *     
     */
    public void setMeritPlanData(ProposedMeritPlanAssignmentContainerDataType value) {
        this.meritPlanData = value;
    }

    /**
     * Gets the value of the commissionPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedCommissionPlanAssignmentContainerDataType }
     *     
     */
    public ProposedCommissionPlanAssignmentContainerDataType getCommissionPlanData() {
        return commissionPlanData;
    }

    /**
     * Sets the value of the commissionPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedCommissionPlanAssignmentContainerDataType }
     *     
     */
    public void setCommissionPlanData(ProposedCommissionPlanAssignmentContainerDataType value) {
        this.commissionPlanData = value;
    }

    /**
     * Gets the value of the stockPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedStockPlanAssignmentContainerDataType }
     *     
     */
    public ProposedStockPlanAssignmentContainerDataType getStockPlanData() {
        return stockPlanData;
    }

    /**
     * Sets the value of the stockPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedStockPlanAssignmentContainerDataType }
     *     
     */
    public void setStockPlanData(ProposedStockPlanAssignmentContainerDataType value) {
        this.stockPlanData = value;
    }

    /**
     * Gets the value of the periodSalaryPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedPeriodSalaryPlanAssignmentContainerDataType }
     *     
     */
    public ProposedPeriodSalaryPlanAssignmentContainerDataType getPeriodSalaryPlanData() {
        return periodSalaryPlanData;
    }

    /**
     * Sets the value of the periodSalaryPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedPeriodSalaryPlanAssignmentContainerDataType }
     *     
     */
    public void setPeriodSalaryPlanData(ProposedPeriodSalaryPlanAssignmentContainerDataType value) {
        this.periodSalaryPlanData = value;
    }

}
