
package com.workday.staffing;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Data element that contains the compensation default information.  If a section is to be provided, it must be provided fully as it will fully replace the current default compensation.
 * 
 * <p>Java class for Compensation_Default_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Compensation_Default_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Guidelines_Data" type="{urn:com.workday/bsvc}Compensatable_Default_Guidelines_DataType" minOccurs="0"/>
 *         &lt;element name="Pay_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Base_Pay_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Unit_Salary_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Salary_Unit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Allowance_Plan_Non-Unit_Based_Data" type="{urn:com.workday/bsvc}Proposed_Allowance_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Allowance_Plan_Unit_Based_Data" type="{urn:com.workday/bsvc}Proposed_Allowance_Unit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Bonus_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Bonus_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Merit_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Merit_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Commission_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Commission_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Stock_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Stock_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *         &lt;element name="Period_Salary_Plan_Data" type="{urn:com.workday/bsvc}Proposed_Period_Salary_Plan_Assignment_Container_DataType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Compensation_Default_DataType", propOrder = {
    "guidelinesData",
    "payPlanData",
    "unitSalaryPlanData",
    "allowancePlanNonUnitBasedData",
    "allowancePlanUnitBasedData",
    "bonusPlanData",
    "meritPlanData",
    "commissionPlanData",
    "stockPlanData",
    "periodSalaryPlanData"
})
public class CompensationDefaultDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Guidelines_Data")
    protected CompensatableDefaultGuidelinesDataType guidelinesData;
    @XmlElement(name = "Pay_Plan_Data")
    protected ProposedBasePayPlanAssignmentContainerDataType payPlanData;
    @XmlElement(name = "Unit_Salary_Plan_Data")
    protected ProposedSalaryUnitPlanAssignmentContainerDataType unitSalaryPlanData;
    @XmlElement(name = "Allowance_Plan_Non-Unit_Based_Data")
    protected ProposedAllowancePlanAssignmentContainerDataType allowancePlanNonUnitBasedData;
    @XmlElement(name = "Allowance_Plan_Unit_Based_Data")
    protected ProposedAllowanceUnitPlanAssignmentContainerDataType allowancePlanUnitBasedData;
    @XmlElement(name = "Bonus_Plan_Data")
    protected ProposedBonusPlanAssignmentContainerDataType bonusPlanData;
    @XmlElement(name = "Merit_Plan_Data")
    protected ProposedMeritPlanAssignmentContainerDataType meritPlanData;
    @XmlElement(name = "Commission_Plan_Data")
    protected ProposedCommissionPlanAssignmentContainerDataType commissionPlanData;
    @XmlElement(name = "Stock_Plan_Data")
    protected ProposedStockPlanAssignmentContainerDataType stockPlanData;
    @XmlElement(name = "Period_Salary_Plan_Data")
    protected ProposedPeriodSalaryPlanAssignmentContainerDataType periodSalaryPlanData;

    /**
     * Gets the value of the guidelinesData property.
     * 
     * @return
     *     possible object is
     *     {@link CompensatableDefaultGuidelinesDataType }
     *     
     */
    public CompensatableDefaultGuidelinesDataType getGuidelinesData() {
        return guidelinesData;
    }

    /**
     * Sets the value of the guidelinesData property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompensatableDefaultGuidelinesDataType }
     *     
     */
    public void setGuidelinesData(CompensatableDefaultGuidelinesDataType value) {
        this.guidelinesData = value;
    }

    /**
     * Gets the value of the payPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedBasePayPlanAssignmentContainerDataType }
     *     
     */
    public ProposedBasePayPlanAssignmentContainerDataType getPayPlanData() {
        return payPlanData;
    }

    /**
     * Sets the value of the payPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedBasePayPlanAssignmentContainerDataType }
     *     
     */
    public void setPayPlanData(ProposedBasePayPlanAssignmentContainerDataType value) {
        this.payPlanData = value;
    }

    /**
     * Gets the value of the unitSalaryPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedSalaryUnitPlanAssignmentContainerDataType }
     *     
     */
    public ProposedSalaryUnitPlanAssignmentContainerDataType getUnitSalaryPlanData() {
        return unitSalaryPlanData;
    }

    /**
     * Sets the value of the unitSalaryPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedSalaryUnitPlanAssignmentContainerDataType }
     *     
     */
    public void setUnitSalaryPlanData(ProposedSalaryUnitPlanAssignmentContainerDataType value) {
        this.unitSalaryPlanData = value;
    }

    /**
     * Gets the value of the allowancePlanNonUnitBasedData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedAllowancePlanAssignmentContainerDataType }
     *     
     */
    public ProposedAllowancePlanAssignmentContainerDataType getAllowancePlanNonUnitBasedData() {
        return allowancePlanNonUnitBasedData;
    }

    /**
     * Sets the value of the allowancePlanNonUnitBasedData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedAllowancePlanAssignmentContainerDataType }
     *     
     */
    public void setAllowancePlanNonUnitBasedData(ProposedAllowancePlanAssignmentContainerDataType value) {
        this.allowancePlanNonUnitBasedData = value;
    }

    /**
     * Gets the value of the allowancePlanUnitBasedData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedAllowanceUnitPlanAssignmentContainerDataType }
     *     
     */
    public ProposedAllowanceUnitPlanAssignmentContainerDataType getAllowancePlanUnitBasedData() {
        return allowancePlanUnitBasedData;
    }

    /**
     * Sets the value of the allowancePlanUnitBasedData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedAllowanceUnitPlanAssignmentContainerDataType }
     *     
     */
    public void setAllowancePlanUnitBasedData(ProposedAllowanceUnitPlanAssignmentContainerDataType value) {
        this.allowancePlanUnitBasedData = value;
    }

    /**
     * Gets the value of the bonusPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedBonusPlanAssignmentContainerDataType }
     *     
     */
    public ProposedBonusPlanAssignmentContainerDataType getBonusPlanData() {
        return bonusPlanData;
    }

    /**
     * Sets the value of the bonusPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedBonusPlanAssignmentContainerDataType }
     *     
     */
    public void setBonusPlanData(ProposedBonusPlanAssignmentContainerDataType value) {
        this.bonusPlanData = value;
    }

    /**
     * Gets the value of the meritPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedMeritPlanAssignmentContainerDataType }
     *     
     */
    public ProposedMeritPlanAssignmentContainerDataType getMeritPlanData() {
        return meritPlanData;
    }

    /**
     * Sets the value of the meritPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedMeritPlanAssignmentContainerDataType }
     *     
     */
    public void setMeritPlanData(ProposedMeritPlanAssignmentContainerDataType value) {
        this.meritPlanData = value;
    }

    /**
     * Gets the value of the commissionPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedCommissionPlanAssignmentContainerDataType }
     *     
     */
    public ProposedCommissionPlanAssignmentContainerDataType getCommissionPlanData() {
        return commissionPlanData;
    }

    /**
     * Sets the value of the commissionPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedCommissionPlanAssignmentContainerDataType }
     *     
     */
    public void setCommissionPlanData(ProposedCommissionPlanAssignmentContainerDataType value) {
        this.commissionPlanData = value;
    }

    /**
     * Gets the value of the stockPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedStockPlanAssignmentContainerDataType }
     *     
     */
    public ProposedStockPlanAssignmentContainerDataType getStockPlanData() {
        return stockPlanData;
    }

    /**
     * Sets the value of the stockPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedStockPlanAssignmentContainerDataType }
     *     
     */
    public void setStockPlanData(ProposedStockPlanAssignmentContainerDataType value) {
        this.stockPlanData = value;
    }

    /**
     * Gets the value of the periodSalaryPlanData property.
     * 
     * @return
     *     possible object is
     *     {@link ProposedPeriodSalaryPlanAssignmentContainerDataType }
     *     
     */
    public ProposedPeriodSalaryPlanAssignmentContainerDataType getPeriodSalaryPlanData() {
        return periodSalaryPlanData;
    }

    /**
     * Sets the value of the periodSalaryPlanData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProposedPeriodSalaryPlanAssignmentContainerDataType }
     *     
     */
    public void setPeriodSalaryPlanData(ProposedPeriodSalaryPlanAssignmentContainerDataType value) {
        this.periodSalaryPlanData = value;
    }

}
