
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper element for the Close Position business process data including the position to close and the event data.
 * 
 * <p>Java class for Close_Position_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Close_Position_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType"/>
 *           &lt;element name="Headcount_Restriction_Reference" type="{urn:com.workday/bsvc}Headcount_RestrictionsObjectType"/>
 *         &lt;/choice>
 *         &lt;element name="Close_Event_Data" type="{urn:com.workday/bsvc}Close_Position_Event_DataType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Close_Position_DataType", propOrder = {
    "positionReference",
    "headcountRestrictionReference",
    "closeEventData"
})
public class ClosePositionDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_Reference")
    protected PositionRestrictionsObjectType positionReference;
    @XmlElement(name = "Headcount_Restriction_Reference")
    protected HeadcountRestrictionsObjectType headcountRestrictionReference;
    @XmlElement(name = "Close_Event_Data", required = true)
    protected List<ClosePositionEventDataType> closeEventData;

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setPositionReference(PositionRestrictionsObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the headcountRestrictionReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public HeadcountRestrictionsObjectType getHeadcountRestrictionReference() {
        return headcountRestrictionReference;
    }

    /**
     * Sets the value of the headcountRestrictionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public void setHeadcountRestrictionReference(HeadcountRestrictionsObjectType value) {
        this.headcountRestrictionReference = value;
    }

    /**
     * Gets the value of the closeEventData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the closeEventData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCloseEventData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClosePositionEventDataType }
     * 
     * 
     */
    public List<ClosePositionEventDataType> getCloseEventData() {
        if (closeEventData == null) {
            closeEventData = new ArrayList<ClosePositionEventDataType>();
        }
        return this.closeEventData;
    }

    /**
     * Sets the value of the closeEventData property.
     * 
     * @param closeEventData
     *     allowed object is
     *     {@link ClosePositionEventDataType }
     *     
     */
    public void setCloseEventData(List<ClosePositionEventDataType> closeEventData) {
        this.closeEventData = closeEventData;
    }

}
