
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Contains the details of the change job business process including the reason.
 * 
 * <p>Java class for Change_Job_Detail_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Change_Job_Detail_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Reason_Reference" type="{urn:com.workday/bsvc}Change_Job_SubcategoryObjectType"/>
 *         &lt;element name="Supervisory_Organization_Reference" type="{urn:com.workday/bsvc}Supervisory_OrganizationObjectType" minOccurs="0"/>
 *         &lt;element name="Headcount_Option_Reference" type="{urn:com.workday/bsvc}Headcount_OptionsObjectType" minOccurs="0"/>
 *         &lt;element name="Job_Overlap_Allowed" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="Proposed_Position_Reference" type="{urn:com.workday/bsvc}Position_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Proposed_Headcount_Reference" type="{urn:com.workday/bsvc}Headcount_RestrictionsObjectType" minOccurs="0"/>
 *           &lt;element name="Proposed_Job_Requisition_Reference" type="{urn:com.workday/bsvc}Job_RequisitionObjectType" minOccurs="0"/>
 *           &lt;element name="Create_Position" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;choice>
 *           &lt;element name="Employee_Type_Reference" type="{urn:com.workday/bsvc}Employee_TypeObjectType" minOccurs="0"/>
 *           &lt;element name="Contingent_Worker_Type_Reference" type="{urn:com.workday/bsvc}Contingent_Worker_TypeObjectType" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="Job_Details_Data" type="{urn:com.workday/bsvc}Position_Details_Sub_DataType" minOccurs="0"/>
 *         &lt;element name="International_Assignment_Type_Reference" type="{urn:com.workday/bsvc}International_Assignment_TypeObjectType" minOccurs="0"/>
 *         &lt;element name="Expected_Assignment_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="End_Employment_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Contract_End_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="First_Day_of_Work" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Notify_Worker_By" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="New_Position_ID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Contract_Details_Data" type="{urn:com.workday/bsvc}Contract_Details_Sub_DataType" minOccurs="0"/>
 *         &lt;element name="Worker_Document_Data" type="{urn:com.workday/bsvc}Worker_Document_for_Staffing_Event_DataType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Change_Job_Detail_DataType", propOrder = {
    "reasonReference",
    "supervisoryOrganizationReference",
    "headcountOptionReference",
    "jobOverlapAllowed",
    "proposedPositionReference",
    "proposedHeadcountReference",
    "proposedJobRequisitionReference",
    "createPosition",
    "employeeTypeReference",
    "contingentWorkerTypeReference",
    "jobDetailsData",
    "internationalAssignmentTypeReference",
    "expectedAssignmentEndDate",
    "endEmploymentDate",
    "contractEndDate",
    "firstDayOfWork",
    "notifyWorkerBy",
    "newPositionID",
    "contractDetailsData",
    "workerDocumentData"
})
public class ChangeJobDetailDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Reason_Reference", required = true)
    protected ChangeJobSubcategoryObjectType reasonReference;
    @XmlElement(name = "Supervisory_Organization_Reference")
    protected SupervisoryOrganizationObjectType supervisoryOrganizationReference;
    @XmlElement(name = "Headcount_Option_Reference")
    protected HeadcountOptionsObjectType headcountOptionReference;
    @XmlElement(name = "Job_Overlap_Allowed")
    protected Boolean jobOverlapAllowed;
    @XmlElement(name = "Proposed_Position_Reference")
    protected PositionRestrictionsObjectType proposedPositionReference;
    @XmlElement(name = "Proposed_Headcount_Reference")
    protected HeadcountRestrictionsObjectType proposedHeadcountReference;
    @XmlElement(name = "Proposed_Job_Requisition_Reference")
    protected JobRequisitionObjectType proposedJobRequisitionReference;
    @XmlElement(name = "Create_Position")
    protected Boolean createPosition;
    @XmlElement(name = "Employee_Type_Reference")
    protected EmployeeTypeObjectType employeeTypeReference;
    @XmlElement(name = "Contingent_Worker_Type_Reference")
    protected ContingentWorkerTypeObjectType contingentWorkerTypeReference;
    @XmlElement(name = "Job_Details_Data")
    protected PositionDetailsSubDataType jobDetailsData;
    @XmlElement(name = "International_Assignment_Type_Reference")
    protected InternationalAssignmentTypeObjectType internationalAssignmentTypeReference;
    @XmlElement(name = "Expected_Assignment_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar expectedAssignmentEndDate;
    @XmlElement(name = "End_Employment_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar endEmploymentDate;
    @XmlElement(name = "Contract_End_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar contractEndDate;
    @XmlElement(name = "First_Day_of_Work")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar firstDayOfWork;
    @XmlElement(name = "Notify_Worker_By")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar notifyWorkerBy;
    @XmlElement(name = "New_Position_ID")
    protected String newPositionID;
    @XmlElement(name = "Contract_Details_Data")
    protected ContractDetailsSubDataType contractDetailsData;
    @XmlElement(name = "Worker_Document_Data")
    protected List<WorkerDocumentForStaffingEventDataType> workerDocumentData;

    /**
     * Gets the value of the reasonReference property.
     * 
     * @return
     *     possible object is
     *     {@link ChangeJobSubcategoryObjectType }
     *     
     */
    public ChangeJobSubcategoryObjectType getReasonReference() {
        return reasonReference;
    }

    /**
     * Sets the value of the reasonReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChangeJobSubcategoryObjectType }
     *     
     */
    public void setReasonReference(ChangeJobSubcategoryObjectType value) {
        this.reasonReference = value;
    }

    /**
     * Gets the value of the supervisoryOrganizationReference property.
     * 
     * @return
     *     possible object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public SupervisoryOrganizationObjectType getSupervisoryOrganizationReference() {
        return supervisoryOrganizationReference;
    }

    /**
     * Sets the value of the supervisoryOrganizationReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupervisoryOrganizationObjectType }
     *     
     */
    public void setSupervisoryOrganizationReference(SupervisoryOrganizationObjectType value) {
        this.supervisoryOrganizationReference = value;
    }

    /**
     * Gets the value of the headcountOptionReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountOptionsObjectType }
     *     
     */
    public HeadcountOptionsObjectType getHeadcountOptionReference() {
        return headcountOptionReference;
    }

    /**
     * Sets the value of the headcountOptionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountOptionsObjectType }
     *     
     */
    public void setHeadcountOptionReference(HeadcountOptionsObjectType value) {
        this.headcountOptionReference = value;
    }

    /**
     * Gets the value of the jobOverlapAllowed property.
     * This getter has been renamed from isJobOverlapAllowed() to getJobOverlapAllowed() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getJobOverlapAllowed() {
        return jobOverlapAllowed;
    }

    /**
     * Sets the value of the jobOverlapAllowed property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setJobOverlapAllowed(Boolean value) {
        this.jobOverlapAllowed = value;
    }

    /**
     * Gets the value of the proposedPositionReference property.
     * 
     * @return
     *     possible object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public PositionRestrictionsObjectType getProposedPositionReference() {
        return proposedPositionReference;
    }

    /**
     * Sets the value of the proposedPositionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionRestrictionsObjectType }
     *     
     */
    public void setProposedPositionReference(PositionRestrictionsObjectType value) {
        this.proposedPositionReference = value;
    }

    /**
     * Gets the value of the proposedHeadcountReference property.
     * 
     * @return
     *     possible object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public HeadcountRestrictionsObjectType getProposedHeadcountReference() {
        return proposedHeadcountReference;
    }

    /**
     * Sets the value of the proposedHeadcountReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeadcountRestrictionsObjectType }
     *     
     */
    public void setProposedHeadcountReference(HeadcountRestrictionsObjectType value) {
        this.proposedHeadcountReference = value;
    }

    /**
     * Gets the value of the proposedJobRequisitionReference property.
     * 
     * @return
     *     possible object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public JobRequisitionObjectType getProposedJobRequisitionReference() {
        return proposedJobRequisitionReference;
    }

    /**
     * Sets the value of the proposedJobRequisitionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobRequisitionObjectType }
     *     
     */
    public void setProposedJobRequisitionReference(JobRequisitionObjectType value) {
        this.proposedJobRequisitionReference = value;
    }

    /**
     * Gets the value of the createPosition property.
     * This getter has been renamed from isCreatePosition() to getCreatePosition() by cxf-xjc-boolean plugin.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getCreatePosition() {
        return createPosition;
    }

    /**
     * Sets the value of the createPosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCreatePosition(Boolean value) {
        this.createPosition = value;
    }

    /**
     * Gets the value of the employeeTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeTypeObjectType }
     *     
     */
    public EmployeeTypeObjectType getEmployeeTypeReference() {
        return employeeTypeReference;
    }

    /**
     * Sets the value of the employeeTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeTypeObjectType }
     *     
     */
    public void setEmployeeTypeReference(EmployeeTypeObjectType value) {
        this.employeeTypeReference = value;
    }

    /**
     * Gets the value of the contingentWorkerTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public ContingentWorkerTypeObjectType getContingentWorkerTypeReference() {
        return contingentWorkerTypeReference;
    }

    /**
     * Sets the value of the contingentWorkerTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContingentWorkerTypeObjectType }
     *     
     */
    public void setContingentWorkerTypeReference(ContingentWorkerTypeObjectType value) {
        this.contingentWorkerTypeReference = value;
    }

    /**
     * Gets the value of the jobDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public PositionDetailsSubDataType getJobDetailsData() {
        return jobDetailsData;
    }

    /**
     * Sets the value of the jobDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionDetailsSubDataType }
     *     
     */
    public void setJobDetailsData(PositionDetailsSubDataType value) {
        this.jobDetailsData = value;
    }

    /**
     * Gets the value of the internationalAssignmentTypeReference property.
     * 
     * @return
     *     possible object is
     *     {@link InternationalAssignmentTypeObjectType }
     *     
     */
    public InternationalAssignmentTypeObjectType getInternationalAssignmentTypeReference() {
        return internationalAssignmentTypeReference;
    }

    /**
     * Sets the value of the internationalAssignmentTypeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link InternationalAssignmentTypeObjectType }
     *     
     */
    public void setInternationalAssignmentTypeReference(InternationalAssignmentTypeObjectType value) {
        this.internationalAssignmentTypeReference = value;
    }

    /**
     * Gets the value of the expectedAssignmentEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpectedAssignmentEndDate() {
        return expectedAssignmentEndDate;
    }

    /**
     * Sets the value of the expectedAssignmentEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpectedAssignmentEndDate(XMLGregorianCalendar value) {
        this.expectedAssignmentEndDate = value;
    }

    /**
     * Gets the value of the endEmploymentDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEndEmploymentDate() {
        return endEmploymentDate;
    }

    /**
     * Sets the value of the endEmploymentDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndEmploymentDate(XMLGregorianCalendar value) {
        this.endEmploymentDate = value;
    }

    /**
     * Gets the value of the contractEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getContractEndDate() {
        return contractEndDate;
    }

    /**
     * Sets the value of the contractEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setContractEndDate(XMLGregorianCalendar value) {
        this.contractEndDate = value;
    }

    /**
     * Gets the value of the firstDayOfWork property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getFirstDayOfWork() {
        return firstDayOfWork;
    }

    /**
     * Sets the value of the firstDayOfWork property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setFirstDayOfWork(XMLGregorianCalendar value) {
        this.firstDayOfWork = value;
    }

    /**
     * Gets the value of the notifyWorkerBy property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getNotifyWorkerBy() {
        return notifyWorkerBy;
    }

    /**
     * Sets the value of the notifyWorkerBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setNotifyWorkerBy(XMLGregorianCalendar value) {
        this.notifyWorkerBy = value;
    }

    /**
     * Gets the value of the newPositionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNewPositionID() {
        return newPositionID;
    }

    /**
     * Sets the value of the newPositionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNewPositionID(String value) {
        this.newPositionID = value;
    }

    /**
     * Gets the value of the contractDetailsData property.
     * 
     * @return
     *     possible object is
     *     {@link ContractDetailsSubDataType }
     *     
     */
    public ContractDetailsSubDataType getContractDetailsData() {
        return contractDetailsData;
    }

    /**
     * Sets the value of the contractDetailsData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContractDetailsSubDataType }
     *     
     */
    public void setContractDetailsData(ContractDetailsSubDataType value) {
        this.contractDetailsData = value;
    }

    /**
     * Gets the value of the workerDocumentData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the workerDocumentData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWorkerDocumentData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkerDocumentForStaffingEventDataType }
     * 
     * 
     */
    public List<WorkerDocumentForStaffingEventDataType> getWorkerDocumentData() {
        if (workerDocumentData == null) {
            workerDocumentData = new ArrayList<WorkerDocumentForStaffingEventDataType>();
        }
        return this.workerDocumentData;
    }

    /**
     * Sets the value of the workerDocumentData property.
     * 
     * @param workerDocumentData
     *     allowed object is
     *     {@link WorkerDocumentForStaffingEventDataType }
     *     
     */
    public void setWorkerDocumentData(List<WorkerDocumentForStaffingEventDataType> workerDocumentData) {
        this.workerDocumentData = workerDocumentData;
    }

}
