
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Wrapper element for Assign Pay Group business process. The Pay Group cannot be removed from a worker once it is set. It can only be changed to another pay group.
 * 
 * <p>Java class for Assign_Pay_Group_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Assign_Pay_Group_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Pay_Group_Reference" type="{urn:com.workday/bsvc}Pay_GroupObjectType" minOccurs="0"/>
 *         &lt;element name="Additional_Positions_for_Pay_Group_Assignment_Reference" type="{urn:com.workday/bsvc}Position_ElementObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Assign_Pay_Group_DataType", propOrder = {
    "payGroupReference",
    "additionalPositionsForPayGroupAssignmentReference"
})
public class AssignPayGroupDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Pay_Group_Reference")
    protected PayGroupObjectType payGroupReference;
    @XmlElement(name = "Additional_Positions_for_Pay_Group_Assignment_Reference")
    protected List<PositionElementObjectType> additionalPositionsForPayGroupAssignmentReference;

    /**
     * Gets the value of the payGroupReference property.
     * 
     * @return
     *     possible object is
     *     {@link PayGroupObjectType }
     *     
     */
    public PayGroupObjectType getPayGroupReference() {
        return payGroupReference;
    }

    /**
     * Sets the value of the payGroupReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PayGroupObjectType }
     *     
     */
    public void setPayGroupReference(PayGroupObjectType value) {
        this.payGroupReference = value;
    }

    /**
     * Gets the value of the additionalPositionsForPayGroupAssignmentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalPositionsForPayGroupAssignmentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalPositionsForPayGroupAssignmentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PositionElementObjectType }
     * 
     * 
     */
    public List<PositionElementObjectType> getAdditionalPositionsForPayGroupAssignmentReference() {
        if (additionalPositionsForPayGroupAssignmentReference == null) {
            additionalPositionsForPayGroupAssignmentReference = new ArrayList<PositionElementObjectType>();
        }
        return this.additionalPositionsForPayGroupAssignmentReference;
    }

    /**
     * Sets the value of the additionalPositionsForPayGroupAssignmentReference property.
     * 
     * @param additionalPositionsForPayGroupAssignmentReference
     *     allowed object is
     *     {@link PositionElementObjectType }
     *     
     */
    public void setAdditionalPositionsForPayGroupAssignmentReference(List<PositionElementObjectType> additionalPositionsForPayGroupAssignmentReference) {
        this.additionalPositionsForPayGroupAssignmentReference = additionalPositionsForPayGroupAssignmentReference;
    }

}
