
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper for Organization Role Assignment Data.  Includes Role Assignments.
 * 
 * <p>Java class for Assign_Organization_Roles_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Assign_Organization_Roles_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Role_Assignee_Reference" type="{urn:com.workday/bsvc}RoleeObjectType"/>
 *         &lt;element name="Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/>
 *         &lt;element name="Role_Assignment" type="{urn:com.workday/bsvc}Role_AssignmentType" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Assign_Organization_Roles_Event_DataType", propOrder = {
    "roleAssigneeReference",
    "effectiveDate",
    "roleAssignment"
})
public class AssignOrganizationRolesEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Role_Assignee_Reference", required = true)
    protected RoleeObjectType roleAssigneeReference;
    @XmlElement(name = "Effective_Date")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar effectiveDate;
    @XmlElement(name = "Role_Assignment")
    protected List<RoleAssignmentType> roleAssignment;

    /**
     * Gets the value of the roleAssigneeReference property.
     * 
     * @return
     *     possible object is
     *     {@link RoleeObjectType }
     *     
     */
    public RoleeObjectType getRoleAssigneeReference() {
        return roleAssigneeReference;
    }

    /**
     * Sets the value of the roleAssigneeReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoleeObjectType }
     *     
     */
    public void setRoleAssigneeReference(RoleeObjectType value) {
        this.roleAssigneeReference = value;
    }

    /**
     * Gets the value of the effectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * Sets the value of the effectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEffectiveDate(XMLGregorianCalendar value) {
        this.effectiveDate = value;
    }

    /**
     * Gets the value of the roleAssignment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the roleAssignment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRoleAssignment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RoleAssignmentType }
     * 
     * 
     */
    public List<RoleAssignmentType> getRoleAssignment() {
        if (roleAssignment == null) {
            roleAssignment = new ArrayList<RoleAssignmentType>();
        }
        return this.roleAssignment;
    }

    /**
     * Sets the value of the roleAssignment property.
     * 
     * @param roleAssignment
     *     allowed object is
     *     {@link RoleAssignmentType }
     *     
     */
    public void setRoleAssignment(List<RoleAssignmentType> roleAssignment) {
        this.roleAssignment = roleAssignment;
    }

}
