
package com.workday.staffing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * Wrapper element for the Assign Organization web service.
 * 
 * <p>Java class for Assign_Organization_Event_DataType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Assign_Organization_Event_DataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Position_Reference" type="{urn:com.workday/bsvc}Staffing_InterfaceObjectType"/>
 *         &lt;element name="Worker_Reference" type="{urn:com.workday/bsvc}WorkerObjectType" minOccurs="0"/>
 *         &lt;element name="Organization_Reference" type="{urn:com.workday/bsvc}OrganizationObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Fund_Reference" type="{urn:com.workday/bsvc}FundObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Grant_Reference" type="{urn:com.workday/bsvc}GrantObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Program_Reference" type="{urn:com.workday/bsvc}ProgramObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Business_Unit_Reference" type="{urn:com.workday/bsvc}Business_UnitObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Gift_Reference" type="{urn:com.workday/bsvc}GiftObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="Request_Budget_Approval_Sub_Process" type="{urn:com.workday/bsvc}Request_Budget_Approval_Sub_Business_Process_non-autoType" minOccurs="0"/>
 *         &lt;element name="Check_Position_Budget_Sub_Process" type="{urn:com.workday/bsvc}Check_Position_Budget_Sub_Business_ProcessType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="As_Of_Effective_Date" type="{http://www.w3.org/2001/XMLSchema}date" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Assign_Organization_Event_DataType", propOrder = {
    "positionReference",
    "workerReference",
    "organizationReference",
    "fundReference",
    "grantReference",
    "programReference",
    "businessUnitReference",
    "giftReference",
    "requestBudgetApprovalSubProcess",
    "checkPositionBudgetSubProcess"
})
public class AssignOrganizationEventDataType
    implements Serializable
{

    private final static long serialVersionUID = 1L;
    @XmlElement(name = "Position_Reference", required = true)
    protected StaffingInterfaceObjectType positionReference;
    @XmlElement(name = "Worker_Reference")
    protected WorkerObjectType workerReference;
    @XmlElement(name = "Organization_Reference")
    protected List<OrganizationObjectType> organizationReference;
    @XmlElement(name = "Fund_Reference")
    protected List<FundObjectType> fundReference;
    @XmlElement(name = "Grant_Reference")
    protected List<GrantObjectType> grantReference;
    @XmlElement(name = "Program_Reference")
    protected List<ProgramObjectType> programReference;
    @XmlElement(name = "Business_Unit_Reference")
    protected List<BusinessUnitObjectType> businessUnitReference;
    @XmlElement(name = "Gift_Reference")
    protected List<GiftObjectType> giftReference;
    @XmlElement(name = "Request_Budget_Approval_Sub_Process")
    protected RequestBudgetApprovalSubBusinessProcessNonAutoType requestBudgetApprovalSubProcess;
    @XmlElement(name = "Check_Position_Budget_Sub_Process")
    protected CheckPositionBudgetSubBusinessProcessType checkPositionBudgetSubProcess;
    @XmlAttribute(name = "As_Of_Effective_Date", namespace = "urn:com.workday/bsvc")
    @XmlSchemaType(name = "date")
    protected XMLGregorianCalendar asOfEffectiveDate;

    /**
     * Gets the value of the positionReference property.
     * 
     * @return
     *     possible object is
     *     {@link StaffingInterfaceObjectType }
     *     
     */
    public StaffingInterfaceObjectType getPositionReference() {
        return positionReference;
    }

    /**
     * Sets the value of the positionReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link StaffingInterfaceObjectType }
     *     
     */
    public void setPositionReference(StaffingInterfaceObjectType value) {
        this.positionReference = value;
    }

    /**
     * Gets the value of the workerReference property.
     * 
     * @return
     *     possible object is
     *     {@link WorkerObjectType }
     *     
     */
    public WorkerObjectType getWorkerReference() {
        return workerReference;
    }

    /**
     * Sets the value of the workerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkerObjectType }
     *     
     */
    public void setWorkerReference(WorkerObjectType value) {
        this.workerReference = value;
    }

    /**
     * Gets the value of the organizationReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the organizationReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrganizationReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OrganizationObjectType }
     * 
     * 
     */
    public List<OrganizationObjectType> getOrganizationReference() {
        if (organizationReference == null) {
            organizationReference = new ArrayList<OrganizationObjectType>();
        }
        return this.organizationReference;
    }

    /**
     * Gets the value of the fundReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fundReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFundReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FundObjectType }
     * 
     * 
     */
    public List<FundObjectType> getFundReference() {
        if (fundReference == null) {
            fundReference = new ArrayList<FundObjectType>();
        }
        return this.fundReference;
    }

    /**
     * Gets the value of the grantReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the grantReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrantReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GrantObjectType }
     * 
     * 
     */
    public List<GrantObjectType> getGrantReference() {
        if (grantReference == null) {
            grantReference = new ArrayList<GrantObjectType>();
        }
        return this.grantReference;
    }

    /**
     * Gets the value of the programReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the programReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProgramReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProgramObjectType }
     * 
     * 
     */
    public List<ProgramObjectType> getProgramReference() {
        if (programReference == null) {
            programReference = new ArrayList<ProgramObjectType>();
        }
        return this.programReference;
    }

    /**
     * Gets the value of the businessUnitReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the businessUnitReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBusinessUnitReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BusinessUnitObjectType }
     * 
     * 
     */
    public List<BusinessUnitObjectType> getBusinessUnitReference() {
        if (businessUnitReference == null) {
            businessUnitReference = new ArrayList<BusinessUnitObjectType>();
        }
        return this.businessUnitReference;
    }

    /**
     * Gets the value of the giftReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the giftReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGiftReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GiftObjectType }
     * 
     * 
     */
    public List<GiftObjectType> getGiftReference() {
        if (giftReference == null) {
            giftReference = new ArrayList<GiftObjectType>();
        }
        return this.giftReference;
    }

    /**
     * Gets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link RequestBudgetApprovalSubBusinessProcessNonAutoType }
     *     
     */
    public RequestBudgetApprovalSubBusinessProcessNonAutoType getRequestBudgetApprovalSubProcess() {
        return requestBudgetApprovalSubProcess;
    }

    /**
     * Sets the value of the requestBudgetApprovalSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequestBudgetApprovalSubBusinessProcessNonAutoType }
     *     
     */
    public void setRequestBudgetApprovalSubProcess(RequestBudgetApprovalSubBusinessProcessNonAutoType value) {
        this.requestBudgetApprovalSubProcess = value;
    }

    /**
     * Gets the value of the checkPositionBudgetSubProcess property.
     * 
     * @return
     *     possible object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public CheckPositionBudgetSubBusinessProcessType getCheckPositionBudgetSubProcess() {
        return checkPositionBudgetSubProcess;
    }

    /**
     * Sets the value of the checkPositionBudgetSubProcess property.
     * 
     * @param value
     *     allowed object is
     *     {@link CheckPositionBudgetSubBusinessProcessType }
     *     
     */
    public void setCheckPositionBudgetSubProcess(CheckPositionBudgetSubBusinessProcessType value) {
        this.checkPositionBudgetSubProcess = value;
    }

    /**
     * Gets the value of the asOfEffectiveDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getAsOfEffectiveDate() {
        return asOfEffectiveDate;
    }

    /**
     * Sets the value of the asOfEffectiveDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setAsOfEffectiveDate(XMLGregorianCalendar value) {
        this.asOfEffectiveDate = value;
    }

    /**
     * Sets the value of the organizationReference property.
     * 
     * @param organizationReference
     *     allowed object is
     *     {@link OrganizationObjectType }
     *     
     */
    public void setOrganizationReference(List<OrganizationObjectType> organizationReference) {
        this.organizationReference = organizationReference;
    }

    /**
     * Sets the value of the fundReference property.
     * 
     * @param fundReference
     *     allowed object is
     *     {@link FundObjectType }
     *     
     */
    public void setFundReference(List<FundObjectType> fundReference) {
        this.fundReference = fundReference;
    }

    /**
     * Sets the value of the grantReference property.
     * 
     * @param grantReference
     *     allowed object is
     *     {@link GrantObjectType }
     *     
     */
    public void setGrantReference(List<GrantObjectType> grantReference) {
        this.grantReference = grantReference;
    }

    /**
     * Sets the value of the programReference property.
     * 
     * @param programReference
     *     allowed object is
     *     {@link ProgramObjectType }
     *     
     */
    public void setProgramReference(List<ProgramObjectType> programReference) {
        this.programReference = programReference;
    }

    /**
     * Sets the value of the businessUnitReference property.
     * 
     * @param businessUnitReference
     *     allowed object is
     *     {@link BusinessUnitObjectType }
     *     
     */
    public void setBusinessUnitReference(List<BusinessUnitObjectType> businessUnitReference) {
        this.businessUnitReference = businessUnitReference;
    }

    /**
     * Sets the value of the giftReference property.
     * 
     * @param giftReference
     *     allowed object is
     *     {@link GiftObjectType }
     *     
     */
    public void setGiftReference(List<GiftObjectType> giftReference) {
        this.giftReference = giftReference;
    }

}
